/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.integrationtests.datatable;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.faces.context.FacesContext;
import javax.faces.view.ViewScoped;
import javax.inject.Inject;
import javax.inject.Named;
import lombok.Generated;
import org.primefaces.component.datatable.DataTable;
import org.primefaces.integrationtests.datatable.DataTable001Dynamic;
import org.primefaces.integrationtests.datatable.ProgrammingLanguage;
import org.primefaces.integrationtests.datatable.ProgrammingLanguageService;

@Named
@ViewScoped
public class DataTable001Dynamic
implements Serializable {
    private static final long serialVersionUID = 8906909722127350633L;
    private List<ProgrammingLanguage> progLanguages;
    private List<ProgrammingLanguage> filteredProgLanguages;
    private boolean globalFilterOnly;
    private List<ColumnModel> columns = new ArrayList();
    @Inject
    private ProgrammingLanguageService service;

    @PostConstruct
    public void init() {
        this.progLanguages = this.service.getLangs();
        this.globalFilterOnly = false;
        this.populateColumns();
    }

    public void populateColumns() {
        this.columns.add(new ColumnModel("ID", "id", "startsWith", true));
        this.columns.add(new ColumnModel("Type", "type", "startsWith", true));
        this.columns.add(new ColumnModel("Name", "name", "contains", true));
        this.columns.add(new ColumnModel("First appeared", "firstAppeared", "gte", true));
    }

    public void resetTable() {
        DataTable dataTable = (DataTable)FacesContext.getCurrentInstance().getViewRoot().findComponent("form:datatable");
        dataTable.reset();
        this.progLanguages = this.service.getLangs();
    }

    public void toggleGlobalFilter() {
        this.setGlobalFilterOnly(!this.isGlobalFilterOnly());
    }

    public Object justReturn(Object value) {
        return value;
    }

    @Generated
    public DataTable001Dynamic() {
    }

    @Generated
    public List<ProgrammingLanguage> getProgLanguages() {
        return this.progLanguages;
    }

    @Generated
    public List<ProgrammingLanguage> getFilteredProgLanguages() {
        return this.filteredProgLanguages;
    }

    @Generated
    public boolean isGlobalFilterOnly() {
        return this.globalFilterOnly;
    }

    @Generated
    public List<ColumnModel> getColumns() {
        return this.columns;
    }

    @Generated
    public ProgrammingLanguageService getService() {
        return this.service;
    }

    @Generated
    public void setProgLanguages(List<ProgrammingLanguage> progLanguages) {
        this.progLanguages = progLanguages;
    }

    @Generated
    public void setFilteredProgLanguages(List<ProgrammingLanguage> filteredProgLanguages) {
        this.filteredProgLanguages = filteredProgLanguages;
    }

    @Generated
    public void setGlobalFilterOnly(boolean globalFilterOnly) {
        this.globalFilterOnly = globalFilterOnly;
    }

    @Generated
    public void setColumns(List<ColumnModel> columns) {
        this.columns = columns;
    }

    @Generated
    public void setService(ProgrammingLanguageService service) {
        this.service = service;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataTable001Dynamic)) {
            return false;
        }
        DataTable001Dynamic other = (DataTable001Dynamic)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.isGlobalFilterOnly() != other.isGlobalFilterOnly()) {
            return false;
        }
        List this$progLanguages = this.getProgLanguages();
        List other$progLanguages = other.getProgLanguages();
        if (this$progLanguages == null ? other$progLanguages != null : !((Object)this$progLanguages).equals(other$progLanguages)) {
            return false;
        }
        List this$filteredProgLanguages = this.getFilteredProgLanguages();
        List other$filteredProgLanguages = other.getFilteredProgLanguages();
        if (this$filteredProgLanguages == null ? other$filteredProgLanguages != null : !((Object)this$filteredProgLanguages).equals(other$filteredProgLanguages)) {
            return false;
        }
        List this$columns = this.getColumns();
        List other$columns = other.getColumns();
        if (this$columns == null ? other$columns != null : !((Object)this$columns).equals(other$columns)) {
            return false;
        }
        ProgrammingLanguageService this$service = this.getService();
        ProgrammingLanguageService other$service = other.getService();
        return !(this$service == null ? other$service != null : !this$service.equals(other$service));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DataTable001Dynamic;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isGlobalFilterOnly() ? 79 : 97);
        List $progLanguages = this.getProgLanguages();
        result = result * 59 + ($progLanguages == null ? 43 : ((Object)$progLanguages).hashCode());
        List $filteredProgLanguages = this.getFilteredProgLanguages();
        result = result * 59 + ($filteredProgLanguages == null ? 43 : ((Object)$filteredProgLanguages).hashCode());
        List $columns = this.getColumns();
        result = result * 59 + ($columns == null ? 43 : ((Object)$columns).hashCode());
        ProgrammingLanguageService $service = this.getService();
        result = result * 59 + ($service == null ? 43 : $service.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "DataTable001Dynamic(progLanguages=" + this.getProgLanguages() + ", filteredProgLanguages=" + this.getFilteredProgLanguages() + ", globalFilterOnly=" + this.isGlobalFilterOnly() + ", columns=" + this.getColumns() + ", service=" + this.getService() + ")";
    }
}

