/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.integrationtests.datatable;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.ComparatorUtils;
import org.primefaces.integrationtests.datatable.Customer;
import org.primefaces.integrationtests.datatable.CustomerLazySorter;
import org.primefaces.model.FilterMeta;
import org.primefaces.model.LazyDataModel;
import org.primefaces.model.SortMeta;

public class CustomerLazyDataModelNoCountImpl
extends LazyDataModel<Customer> {
    private static final long serialVersionUID = 1L;
    private List<Customer> datasource;

    public CustomerLazyDataModelNoCountImpl(List<Customer> datasource) {
        this.datasource = datasource;
    }

    public Customer getRowData(String rowKey) {
        for (Customer customer : this.datasource) {
            if (customer.getId() != Integer.parseInt(rowKey)) continue;
            return customer;
        }
        return null;
    }

    public String getRowKey(Customer customer) {
        return String.valueOf(customer.getId());
    }

    public int count(Map<String, FilterMeta> filterBy) {
        return 0;
    }

    public List<Customer> load(int offset, int pageSize, Map<String, SortMeta> sortBy, Map<String, FilterMeta> filterBy) {
        List<Customer> customers = this.datasource.stream().skip(offset).limit(pageSize).collect(Collectors.toList());
        if (!sortBy.isEmpty()) {
            List comparators = sortBy.values().stream().map(o -> new CustomerLazySorter(o.getField(), o.getOrder())).collect(Collectors.toList());
            Comparator cp = ComparatorUtils.chainedComparator(comparators);
            customers.sort(cp);
        }
        this.setRowCount(this.datasource.size());
        return customers;
    }
}

