/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.integrationtests.datatable;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import javax.faces.context.FacesContext;
import org.apache.commons.collections4.ComparatorUtils;
import org.primefaces.integrationtests.datatable.Customer;
import org.primefaces.integrationtests.datatable.CustomerLazySorter;
import org.primefaces.model.FilterMeta;
import org.primefaces.model.LazyDataModel;
import org.primefaces.model.SortMeta;
import org.primefaces.model.filter.FilterConstraint;

public class CustomerLazyDataModel
extends LazyDataModel<Customer> {
    private static final long serialVersionUID = 1L;
    private List<Customer> datasource;

    public CustomerLazyDataModel(List<Customer> datasource) {
        this.datasource = datasource;
    }

    public Customer getRowData(String rowKey) {
        for (Customer customer : this.datasource) {
            if (customer.getId() != Integer.parseInt(rowKey)) continue;
            return customer;
        }
        return null;
    }

    public String getRowKey(Customer customer) {
        return String.valueOf(customer.getId());
    }

    public int count(Map<String, FilterMeta> filterBy) {
        return (int)this.datasource.stream().filter(o -> this.filter(FacesContext.getCurrentInstance(), filterBy.values(), o)).count();
    }

    public List<Customer> load(int offset, int pageSize, Map<String, SortMeta> sortBy, Map<String, FilterMeta> filterBy) {
        List customers = this.datasource.stream().filter(o -> this.filter(FacesContext.getCurrentInstance(), filterBy.values(), o)).collect(Collectors.toList());
        if (!sortBy.isEmpty()) {
            List comparators = sortBy.values().stream().map(o -> new CustomerLazySorter(o.getField(), o.getOrder())).collect(Collectors.toList());
            Comparator cp = ComparatorUtils.chainedComparator(comparators);
            customers.sort(cp);
        }
        return customers.subList(offset, Math.min(offset + pageSize, customers.size()));
    }

    private boolean filter(FacesContext context, Collection<FilterMeta> filterBy, Object o) {
        boolean matching = true;
        for (FilterMeta filter : filterBy) {
            FilterConstraint constraint = filter.getConstraint();
            Object filterValue = filter.getFilterValue();
            try {
                String columnValue = String.valueOf(this.getPropertyValueViaReflection(o, filter.getField()));
                matching = constraint.isMatching(context, (Object)columnValue, filterValue, Locale.getDefault());
            }
            catch (IntrospectionException | ReflectiveOperationException e) {
                System.err.println("Error getting property value via reflection: " + e.getMessage());
                matching = false;
            }
            if (matching) continue;
            break;
        }
        return matching;
    }

    public Object getPropertyValueViaReflection(Object o, String field) throws ReflectiveOperationException, IllegalArgumentException, IntrospectionException {
        return new PropertyDescriptor(field, o.getClass()).getReadMethod().invoke(o, new Object[0]);
    }
}

