/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.util.product;

import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackageManifest {
    private static final Logger logger = LoggerFactory.getLogger(PackageManifest.class);
    private static final String MANIFEST_MF_PATH = "META-INF/MANIFEST.MF";
    private static final String IMPLEMENTATION_VERSION_UNKNOWN = "0.0.0";
    private String implementationTitle;
    private String implementationVersion;

    public PackageManifest(Class<?> clazz, String expectedImplementationTitle) {
        try {
            this.implementationTitle = expectedImplementationTitle;
            this.implementationVersion = IMPLEMENTATION_VERSION_UNKNOWN;
            Enumeration<URL> manifestURLs = clazz.getClassLoader().getResources(MANIFEST_MF_PATH);
            boolean found = false;
            while (manifestURLs.hasMoreElements() && !found) {
                URL manifestURL = manifestURLs.nextElement();
                InputStream inputStream = manifestURL.openStream();
                Manifest manifest = new Manifest(inputStream);
                Attributes mainAttributes = manifest.getMainAttributes();
                if (expectedImplementationTitle.equals(mainAttributes.getValue(Attributes.Name.IMPLEMENTATION_TITLE))) {
                    this.implementationVersion = mainAttributes.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
                    found = true;
                }
                inputStream.close();
            }
        }
        catch (IOException e) {
            logger.error(e);
        }
    }

    public String getImplementationTitle() {
        return this.implementationTitle;
    }

    public String getImplementationVersion() {
        return this.implementationVersion;
    }
}

