/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.util.model;

import com.liferay.faces.util.model.RowMarker;
import com.liferay.faces.util.model.RowMarks;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import javax.faces.model.DataModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RowMarkerDataModel<E>
extends DataModel<E>
implements RowMarker {
    protected boolean allRowsMarked = false;
    private RowMarks rowMarks;

    public abstract void deleteRow(Object var1) throws IOException;

    public abstract void reset();

    @Override
    public int deleteMarkedRows() throws IOException {
        Set<Map.Entry<Object, Boolean>> entrySet = this.getRowMarks().entrySet();
        Iterator<Map.Entry<Object, Boolean>> iterator = entrySet.iterator();
        int totalDeletedRows = 0;
        while (iterator.hasNext()) {
            Map.Entry<Object, Boolean> mapEntry = iterator.next();
            if (!mapEntry.getValue().booleanValue()) continue;
            try {
                this.deleteRow(mapEntry.getKey());
                ++totalDeletedRows;
            }
            catch (Exception e) {
                throw new IOException(e.getMessage());
            }
        }
        if (totalDeletedRows > 0) {
            this.reset();
        }
        return totalDeletedRows;
    }

    @Override
    public void setAllRowsMarked(boolean allRowsMarked) {
        this.allRowsMarked = allRowsMarked;
        Boolean allRowsMarkedAsBoolean = allRowsMarked;
        Set<Map.Entry<Object, Boolean>> entrySet = this.getRowMarks().entrySet();
        for (Map.Entry<Object, Boolean> mapEntry : entrySet) {
            mapEntry.setValue(allRowsMarkedAsBoolean);
        }
    }

    @Override
    public boolean isAllRowsMarked() {
        return this.allRowsMarked;
    }

    public abstract Object getPrimaryKey(E var1);

    @Override
    public RowMarks getRowMarks() {
        List wrappedData;
        if (this.rowMarks == null && (wrappedData = (List)this.getWrappedData()) != null) {
            this.rowMarks = new RowMarks();
            this.rowMarks.addObserver(new RowMarksObserver());
            for (Object e : wrappedData) {
                Object primaryKey = this.getPrimaryKey(e);
                this.rowMarks.put(primaryKey, Boolean.FALSE);
            }
        }
        return this.rowMarks;
    }

    @Override
    public void setRowMarks(RowMarks rowMarks) {
        this.rowMarks = rowMarks;
    }

    public abstract boolean isReset();

    protected class RowMarksObserver
    implements Observer {
        protected RowMarksObserver() {
        }

        public void update(Observable rowMarks, Object arg) {
            RowMarks.NotificationEvent notificationEvent = (RowMarks.NotificationEvent)((Object)arg);
            if (notificationEvent == RowMarks.NotificationEvent.ROW_MARKED) {
                RowMarkerDataModel.this.allRowsMarked = true;
                Set<Map.Entry<Object, Boolean>> entrySet = RowMarkerDataModel.this.getRowMarks().entrySet();
                Iterator<Map.Entry<Object, Boolean>> iterator = entrySet.iterator();
                while (iterator.hasNext() && RowMarkerDataModel.this.allRowsMarked) {
                    Map.Entry<Object, Boolean> mapEntry = iterator.next();
                    Boolean value = mapEntry.getValue();
                    if (value == null || value.booleanValue()) continue;
                    RowMarkerDataModel.this.allRowsMarked = false;
                }
            } else if (notificationEvent == RowMarks.NotificationEvent.ROW_UNMARKED) {
                RowMarkerDataModel.this.allRowsMarked = false;
            }
        }
    }
}

