/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.util.logging;

import com.liferay.faces.util.logging.LogRecordFactory;
import com.liferay.faces.util.logging.LogRecordFactoryImpl;
import com.liferay.faces.util.logging.Logger;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class LoggerDefaultImpl
implements Logger {
    private static LogRecordFactory logRecordFactory = LogRecordFactoryImpl.getInstance();
    private java.util.logging.Logger wrappedLogger;

    public LoggerDefaultImpl() {
    }

    public LoggerDefaultImpl(String className) {
        this.wrappedLogger = java.util.logging.Logger.getLogger(className);
    }

    public void debug(String message) {
        if (this.isDebugEnabled()) {
            LogRecord logRecord = logRecordFactory.getLogRecord(Level.FINE, message, null);
            this.wrappedLogger.log(logRecord);
        }
    }

    public void debug(String message, Object ... arguments) {
        if (this.isDebugEnabled()) {
            Throwable throwable = this.getThrowable(arguments);
            String formattedMessage = this.formatMessage(message, arguments);
            LogRecord logRecord = logRecordFactory.getLogRecord(Level.FINE, formattedMessage, throwable);
            this.wrappedLogger.log(logRecord);
        }
    }

    public void error(Throwable throwable) {
        if (this.isErrorEnabled()) {
            String message = throwable.getMessage();
            LogRecord logRecord = logRecordFactory.getLogRecord(Level.SEVERE, message, throwable);
            this.wrappedLogger.log(logRecord);
        }
    }

    public void error(String message) {
        if (this.isErrorEnabled()) {
            LogRecord logRecord = logRecordFactory.getLogRecord(Level.SEVERE, message, null);
            this.wrappedLogger.log(logRecord);
        }
    }

    public void error(String message, Object ... arguments) {
        if (this.isErrorEnabled()) {
            Throwable throwable = this.getThrowable(arguments);
            String formattedMessage = this.formatMessage(message, arguments);
            LogRecord logRecord = logRecordFactory.getLogRecord(Level.SEVERE, formattedMessage, throwable);
            this.wrappedLogger.log(logRecord);
        }
    }

    public void info(String message) {
        if (this.isInfoEnabled()) {
            LogRecord logRecord = logRecordFactory.getLogRecord(Level.INFO, message, null);
            this.wrappedLogger.log(logRecord);
        }
    }

    public void info(String message, Object ... arguments) {
        if (this.isInfoEnabled()) {
            String formattedMessage = this.formatMessage(message, arguments);
            Throwable throwable = this.getThrowable(arguments);
            LogRecord logRecord = logRecordFactory.getLogRecord(Level.INFO, formattedMessage, throwable);
            this.wrappedLogger.log(logRecord);
        }
    }

    public void trace(String message) {
        if (this.isTraceEnabled()) {
            LogRecord logRecord = logRecordFactory.getLogRecord(Level.FINEST, message, null);
            this.wrappedLogger.log(logRecord);
        }
    }

    public void trace(String message, Object ... arguments) {
        if (this.isTraceEnabled()) {
            String formattedMessage = this.formatMessage(message, arguments);
            Throwable throwable = this.getThrowable(arguments);
            LogRecord logRecord = logRecordFactory.getLogRecord(Level.FINEST, formattedMessage, throwable);
            this.wrappedLogger.log(logRecord);
        }
    }

    public void warn(String message) {
        if (this.isWarnEnabled()) {
            LogRecord logRecord = logRecordFactory.getLogRecord(Level.WARNING, message, null);
            this.wrappedLogger.log(logRecord);
        }
    }

    public void warn(String message, Object ... arguments) {
        if (this.isWarnEnabled()) {
            Throwable throwable = this.getThrowable(arguments);
            String formattedMessage = this.formatMessage(message, arguments);
            LogRecord logRecord = logRecordFactory.getLogRecord(Level.WARNING, formattedMessage, throwable);
            this.wrappedLogger.log(logRecord);
        }
    }

    protected String formatMessage(String message, Object[] arguments) {
        if (message == null || arguments == null || arguments.length == 0) {
            return message;
        }
        ArrayList<Object> argumentList = new ArrayList<Object>();
        for (Object argument : arguments) {
            if (argument == null || argument instanceof Exception) {
                argumentList.add(null);
                continue;
            }
            if (argument.getClass().isArray()) {
                Object[] argArray = (Object[])argument;
                StringBuilder arrayAsString = new StringBuilder("L[");
                boolean firstArg = true;
                for (Object arg : argArray) {
                    if (firstArg) {
                        firstArg = false;
                    } else {
                        arrayAsString.append(", ");
                    }
                    arrayAsString.append(arg);
                }
                arrayAsString.append("]");
                argumentList.add(arrayAsString.toString());
                continue;
            }
            argumentList.add(argument);
        }
        String formattedMessage = message;
        try {
            if (message.indexOf("'") >= 0) {
                message = message.replaceAll("'", "''");
            }
            formattedMessage = MessageFormat.format(message, argumentList.toArray(new Object[0]));
        }
        catch (IllegalArgumentException e) {
            System.err.println("ERROR " + e.getClass() + ": " + e.getMessage() + ": " + message);
        }
        return formattedMessage;
    }

    public boolean isDebugEnabled() {
        return this.wrappedLogger.isLoggable(Level.FINE);
    }

    public boolean isErrorEnabled() {
        return this.wrappedLogger.isLoggable(Level.SEVERE);
    }

    public boolean isInfoEnabled() {
        return this.wrappedLogger.isLoggable(Level.INFO);
    }

    public boolean isTraceEnabled() {
        return this.wrappedLogger.isLoggable(Level.FINEST);
    }

    public boolean isWarnEnabled() {
        return this.wrappedLogger.isLoggable(Level.WARNING);
    }

    protected Throwable getThrowable(Object[] arguments) {
        Throwable throwable = null;
        if (arguments != null) {
            for (Object arg : arguments) {
                if (arg == null || !(arg instanceof Throwable)) continue;
                throwable = (Throwable)arg;
                break;
            }
        }
        return throwable;
    }
}

