/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.util.listener;

import com.liferay.faces.util.context.MessageContext;
import com.liferay.faces.util.el.FaceletUtil;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import com.liferay.faces.util.model.RowMarker;
import com.liferay.faces.util.model.RowMarks;
import java.util.List;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.UIParameter;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.event.ActionListener;
import javax.faces.model.DataModel;

public class RowMarksActionListener
implements ActionListener {
    private static final String PARAM_NAME_FOR = "for";
    private static final String COMP_ID_MARK_ALL = "row-marks-mark-all";
    private static final String COMP_ID_UNMARK_ALL = "row-marks-unmark-all";
    private static final String COMP_ID_DELETE = "row-marks-delete";
    private static final Logger logger = LoggerFactory.getLogger(RowMarksActionListener.class);

    public void processAction(ActionEvent actionEvent) throws AbortProcessingException {
        UIComponent uiComponent = actionEvent.getComponent();
        String componentId = uiComponent.getId();
        List uiComponentChildren = uiComponent.getChildren();
        String forClientId = null;
        DataModel<?> dataModel = null;
        for (UIComponent uiComponentChild : uiComponentChildren) {
            UIParameter uiParameter;
            String uiParameterName;
            if (!(uiComponentChild instanceof UIParameter) || (uiParameterName = (uiParameter = (UIParameter)uiComponentChild).getName()) == null || !uiParameterName.equals(PARAM_NAME_FOR)) continue;
            forClientId = (String)uiParameter.getValue();
            dataModel = FaceletUtil.findDataModel(forClientId);
            break;
        }
        if (dataModel != null) {
            if (dataModel instanceof RowMarker) {
                RowMarker rowMarker = (RowMarker)dataModel;
                RowMarks rowMarks = rowMarker.getRowMarks();
                if (rowMarks != null) {
                    if (componentId.equals(COMP_ID_MARK_ALL) || componentId.equals(COMP_ID_UNMARK_ALL)) {
                        boolean checked = componentId.equals(COMP_ID_MARK_ALL);
                        if (checked) {
                            rowMarks.markAll();
                        } else {
                            rowMarks.unmarkAll();
                        }
                    } else if (componentId.equals(COMP_ID_DELETE)) {
                        try {
                            int totalDeletedRows = rowMarker.deleteMarkedRows();
                            logger.debug("Deleted {0} rows.", totalDeletedRows);
                            this.addGlobalSuccessInfoMessage();
                        }
                        catch (Exception e) {
                            logger.error(e.getMessage(), e);
                            this.addGlobalUnexpectedErrorMessage();
                        }
                    }
                }
            } else {
                logger.error("Unable to perform action for componentId=[{0}] since dataModel=[{1}] does not implement the RowMarker interface.");
            }
        }
    }

    protected void addGlobalSuccessInfoMessage() {
        MessageContext.getInstance().newFacesMessage(FacesContext.getCurrentInstance(), FacesMessage.SEVERITY_INFO, "your-request-processed-successfully");
    }

    protected void addGlobalUnexpectedErrorMessage() {
        MessageContext.getInstance().newFacesMessage(FacesContext.getCurrentInstance(), FacesMessage.SEVERITY_INFO, "an-unexpected-error-occurred");
    }
}

