/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.util.context.map;

import com.liferay.faces.util.context.map.JavaScriptMapEntry;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import com.liferay.faces.util.map.AbstractPropertyMap;
import com.liferay.faces.util.map.AbstractPropertyMapEntry;
import com.liferay.faces.util.product.Product;
import com.liferay.faces.util.product.ProductMap;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.faces.context.FacesContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaScriptMap
extends AbstractPropertyMap<String> {
    private static final Logger logger = LoggerFactory.getLogger(JavaScriptMap.class);
    private static final String FQCN_ICEFACES_JS_RUNNER = "org.icefaces.util.JavaScriptRunner";
    private static final boolean ICEFACES_DETECTED = ((Product)ProductMap.getInstance().get("ICEfaces")).isDetected();
    private static final String METHOD_RUNSCRIPT = "runScript";

    @Override
    protected AbstractPropertyMapEntry<String> createPropertyMapEntry(String name) {
        return new JavaScriptMapEntry(this, name);
    }

    @Override
    protected void removeProperty(String name) {
        if (!ICEFACES_DETECTED) {
            this.getRequestAttribute().remove(name);
        }
    }

    @Override
    protected String getProperty(String name) {
        if (ICEFACES_DETECTED) {
            return null;
        }
        return this.getRequestAttribute().get(name);
    }

    @Override
    protected void setProperty(String name, String value) {
        if (ICEFACES_DETECTED) {
            try {
                Class<?> jsRunnerClass = Class.forName(FQCN_ICEFACES_JS_RUNNER);
                Method runScriptMethod = jsRunnerClass.getMethod(METHOD_RUNSCRIPT, FacesContext.class, String.class);
                FacesContext facesContext = FacesContext.getCurrentInstance();
                runScriptMethod.invoke(null, facesContext, value);
            }
            catch (Exception e) {
                logger.error(e);
            }
        } else {
            Map<String, String> javaScriptMap = this.getRequestAttribute();
            javaScriptMap.put(name, value);
        }
    }

    @Override
    protected Enumeration<String> getPropertyNames() {
        return Collections.enumeration(this.getRequestAttribute().keySet());
    }

    protected Map<String, String> getRequestAttribute() {
        String key;
        FacesContext facesContext = FacesContext.getCurrentInstance();
        Map requestMap = facesContext.getExternalContext().getRequestMap();
        HashMap javaScriptMap = (HashMap)requestMap.get(key = JavaScriptMap.class.getName());
        if (javaScriptMap == null) {
            javaScriptMap = new HashMap();
            requestMap.put(key, javaScriptMap);
        }
        return javaScriptMap;
    }
}

