/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.util.context;

import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.FactoryFinder;
import javax.faces.application.FacesMessage;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.visit.VisitCallback;
import javax.faces.component.visit.VisitContext;
import javax.faces.component.visit.VisitContextFactory;
import javax.faces.component.visit.VisitHint;
import javax.faces.component.visit.VisitResult;
import javax.faces.context.FacesContext;
import javax.faces.context.PartialViewContext;
import javax.faces.context.PartialViewContextWrapper;
import javax.faces.event.PhaseId;

public class PartialViewContextOnChangeImpl
extends PartialViewContextWrapper {
    private static final Logger logger = LoggerFactory.getLogger(PartialViewContextOnChangeImpl.class);
    private FacesContext facesContext;
    private PartialViewContext wrappedPartialViewContext;
    private Map<String, Object> valueMap;
    private Map<String, Boolean> validMap;

    public PartialViewContextOnChangeImpl(PartialViewContext partialViewContext, FacesContext facesContext) {
        this.wrappedPartialViewContext = partialViewContext;
        this.facesContext = facesContext;
        this.validMap = new HashMap<String, Boolean>();
        this.valueMap = new HashMap<String, Object>();
    }

    public void processPartial(PhaseId phaseId) {
        if (phaseId == PhaseId.APPLY_REQUEST_VALUES) {
            VisitContextFactory visitContextFactory = (VisitContextFactory)FactoryFinder.getFactory((String)"javax.faces.component.visit.VisitContextFactory");
            Collection renderIds = this.wrappedPartialViewContext.getExecuteIds();
            EnumSet<VisitHint> visitHints = EnumSet.of(VisitHint.EXECUTE_LIFECYCLE);
            VisitContext visitContext = visitContextFactory.getVisitContext(this.facesContext, renderIds, visitHints);
            VisitCallbackApplyRequestValuesImpl visitCallback = new VisitCallbackApplyRequestValuesImpl();
            this.facesContext.getViewRoot().visitTree(visitContext, (VisitCallback)visitCallback);
        } else if (phaseId == PhaseId.RENDER_RESPONSE) {
            VisitContextFactory visitContextFactory = (VisitContextFactory)FactoryFinder.getFactory((String)"javax.faces.component.visit.VisitContextFactory");
            Collection renderIds = this.wrappedPartialViewContext.getExecuteIds();
            EnumSet<VisitHint> visitHints = EnumSet.of(VisitHint.EXECUTE_LIFECYCLE);
            VisitContext visitContext = visitContextFactory.getVisitContext(this.facesContext, renderIds, visitHints);
            VisitCallbackRenderResponseImpl visitCallback = new VisitCallbackRenderResponseImpl();
            this.facesContext.getViewRoot().visitTree(visitContext, (VisitCallback)visitCallback);
        }
        super.processPartial(phaseId);
    }

    public void setPartialRequest(boolean isPartialRequest) {
        this.wrappedPartialViewContext.setPartialRequest(isPartialRequest);
    }

    public PartialViewContext getWrapped() {
        return this.wrappedPartialViewContext;
    }

    protected class VisitCallbackRenderResponseImpl
    implements VisitCallback {
        protected VisitCallbackRenderResponseImpl() {
        }

        public VisitResult visit(VisitContext visitContext, UIComponent uiComponent) {
            if (uiComponent instanceof EditableValueHolder) {
                EditableValueHolder editableValueHolder = (EditableValueHolder)uiComponent;
                uiComponent.pushComponentToEL(PartialViewContextOnChangeImpl.this.facesContext, uiComponent);
                boolean required = editableValueHolder.isRequired();
                uiComponent.popComponentFromEL(PartialViewContextOnChangeImpl.this.facesContext);
                if (required) {
                    List messageList;
                    String clientId = uiComponent.getClientId();
                    Object previousValue = PartialViewContextOnChangeImpl.this.valueMap.get(clientId);
                    Object submittedValue = editableValueHolder.getSubmittedValue();
                    boolean submittedValueEmpty = submittedValue == null || "".equals(submittedValue);
                    boolean previouslyValid = (Boolean)PartialViewContextOnChangeImpl.this.validMap.get(clientId);
                    logger.debug("previousValue=[{0}] submittedValue=[{1}] submittedValueEmpty=[{2}] previouslyValid=[{3}]", previousValue, submittedValue, submittedValueEmpty, previouslyValid);
                    if (previousValue == null && submittedValueEmpty && previouslyValid && (messageList = PartialViewContextOnChangeImpl.this.facesContext.getMessageList(clientId)) != null) {
                        ArrayList facesMessagesForClientId = new ArrayList(messageList);
                        for (FacesMessage facesMessage : facesMessagesForClientId) {
                            Iterator allFacesMessagesItr = PartialViewContextOnChangeImpl.this.facesContext.getMessages();
                            while (allFacesMessagesItr.hasNext()) {
                                FacesMessage curFacesMessage = (FacesMessage)allFacesMessagesItr.next();
                                if (!facesMessage.equals(curFacesMessage)) continue;
                                allFacesMessagesItr.remove();
                                editableValueHolder.setValid(true);
                                if (!logger.isDebugEnabled()) continue;
                                String summary = facesMessage.getSummary();
                                logger.debug("Removed facesMessage summary=[{0}] for clientId=[{1}]", summary, clientId);
                            }
                        }
                    }
                }
            }
            return VisitResult.ACCEPT;
        }
    }

    protected class VisitCallbackApplyRequestValuesImpl
    implements VisitCallback {
        protected VisitCallbackApplyRequestValuesImpl() {
        }

        public VisitResult visit(VisitContext visitContext, UIComponent uiComponent) {
            if (uiComponent instanceof EditableValueHolder) {
                EditableValueHolder editableValueHolder = (EditableValueHolder)uiComponent;
                String clientId = uiComponent.getClientId();
                PartialViewContextOnChangeImpl.this.validMap.put(clientId, editableValueHolder.isValid());
                PartialViewContextOnChangeImpl.this.valueMap.put(clientId, editableValueHolder.getValue());
            }
            return VisitResult.ACCEPT;
        }
    }
}

