/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.util.context;

import com.liferay.faces.util.context.MessageContext;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;

public class MessageContextImpl
extends MessageContext {
    private Map<Locale, ResourceBundle> facesResourceBundleMap = new HashMap<Locale, ResourceBundle>();

    public FacesMessage newFacesMessage(FacesContext facesContext, FacesMessage.Severity severity, String key) {
        String messageId = key;
        Locale locale = facesContext.getViewRoot().getLocale();
        return this.newFacesMessage(locale, severity, messageId);
    }

    public FacesMessage newFacesMessage(Locale locale, FacesMessage.Severity severity, String messageId) {
        FacesMessage facesMessage = new FacesMessage();
        facesMessage.setSeverity(severity);
        facesMessage.setSummary(messageId);
        facesMessage.setDetail(null);
        String summary = this.getMessage(locale, messageId);
        if (summary != null) {
            facesMessage.setSummary(summary);
            String detailMessageId = messageId + "_detail";
            String detail = this.getMessage(locale, detailMessageId);
            if (detail != null && !detailMessageId.equals(detail)) {
                facesMessage.setDetail(detail);
            }
        }
        return facesMessage;
    }

    public FacesMessage newFacesMessage(FacesContext facesContext, FacesMessage.Severity severity, String key, Object ... arguments) {
        String messageId = key;
        Locale locale = facesContext.getViewRoot().getLocale();
        return this.newFacesMessage(locale, severity, messageId, arguments);
    }

    public FacesMessage newFacesMessage(Locale locale, FacesMessage.Severity severity, String messageId, Object ... arguments) {
        String detail;
        FacesMessage facesMessage = this.newFacesMessage(locale, severity, messageId);
        String summary = facesMessage.getSummary();
        if (summary != null) {
            facesMessage.setSummary(MessageFormat.format(summary, arguments));
        }
        if ((detail = facesMessage.getDetail()) != null) {
            facesMessage.setDetail(MessageFormat.format(detail, arguments));
        }
        return facesMessage;
    }

    protected ResourceBundle getFacesResourceBundle(Locale locale) {
        ResourceBundle facesResourceBundle = this.facesResourceBundleMap.get(locale);
        if (facesResourceBundle == null) {
            String messageBundle = FacesContext.getCurrentInstance().getApplication().getMessageBundle();
            if (messageBundle == null) {
                messageBundle = "javax.faces.Messages";
            }
            facesResourceBundle = ResourceBundle.getBundle(messageBundle, locale);
            this.facesResourceBundleMap.put(locale, facesResourceBundle);
        }
        return facesResourceBundle;
    }

    public String getMessage(Locale locale, String messageId) {
        String message = null;
        ResourceBundle resourceBundle = null;
        try {
            resourceBundle = ResourceBundle.getBundle("i18n", locale);
            message = resourceBundle.getString(messageId);
        }
        catch (MissingResourceException e) {
            // empty catch block
        }
        if (resourceBundle == null && (resourceBundle = this.getFacesResourceBundle(locale)) != null) {
            try {
                message = resourceBundle.getString(messageId);
            }
            catch (MissingResourceException e) {
                // empty catch block
            }
        }
        if (message == null) {
            message = messageId;
        }
        return message;
    }

    public String getMessage(Locale locale, String messageId, Object ... arguments) {
        String message = this.getMessage(locale, messageId);
        if (message != null) {
            message = MessageFormat.format(message, arguments);
        }
        return message;
    }
}

