/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.util.context;

import com.liferay.faces.util.context.FacesContextHelper;
import com.liferay.faces.util.context.MessageContext;
import com.liferay.faces.util.context.MessageContextImpl;
import com.liferay.faces.util.context.map.JavaScriptMap;
import com.liferay.faces.util.helper.BooleanHelper;
import com.liferay.faces.util.helper.IntegerHelper;
import com.liferay.faces.util.helper.LongHelper;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.faces.FactoryFinder;
import javax.faces.application.FacesMessage;
import javax.faces.application.ViewHandler;
import javax.faces.component.ActionSource;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseListener;
import javax.faces.lifecycle.LifecycleFactory;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FacesContextHelperImpl
implements FacesContextHelper,
Serializable {
    private static final long serialVersionUID = 1336108097295590097L;
    private static final String UNEXPECTED_ERROR_MSG_ID = "an-unexpected-error-occurred";
    private static final String SUCCESS_INFO_MSG_ID = "your-request-processed-successfully";
    private transient Map<String, String> javaScriptMap;

    @Override
    public void addComponentErrorMessage(String clientId, String key) {
        this.addMessage(clientId, FacesMessage.SEVERITY_ERROR, key);
    }

    @Override
    public void addComponentErrorMessage(String clientId, String key, Object argument) {
        this.addMessage(clientId, FacesMessage.SEVERITY_ERROR, key, argument);
    }

    @Override
    public void addComponentErrorMessage(String clientId, String key, Object ... arguments) {
        this.addMessage(clientId, FacesMessage.SEVERITY_ERROR, key, arguments);
    }

    @Override
    public void addComponentInfoMessage(String clientId, String key) {
        this.addMessage(clientId, FacesMessage.SEVERITY_INFO, key);
    }

    @Override
    public void addComponentInfoMessage(String clientId, String key, Object argument) {
        this.addMessage(clientId, FacesMessage.SEVERITY_INFO, key, argument);
    }

    @Override
    public void addComponentInfoMessage(String clientId, String key, Object ... arguments) {
        this.addMessage(clientId, FacesMessage.SEVERITY_INFO, key, arguments);
    }

    @Override
    public void addGlobalErrorMessage(String key) {
        this.addComponentErrorMessage(null, key);
    }

    @Override
    public void addGlobalErrorMessage(String key, Object argument) {
        this.addComponentErrorMessage((String)null, key, argument);
    }

    @Override
    public void addGlobalErrorMessage(String key, Object ... arguments) {
        this.addComponentErrorMessage((String)null, key, arguments);
    }

    @Override
    public void addGlobalInfoMessage(String key) {
        this.addComponentInfoMessage(null, key);
    }

    @Override
    public void addGlobalInfoMessage(String key, Object argument) {
        this.addComponentInfoMessage((String)null, key, argument);
    }

    @Override
    public void addGlobalInfoMessage(String key, Object ... arguments) {
        this.addComponentInfoMessage((String)null, key, arguments);
    }

    @Override
    public void addGlobalSuccessInfoMessage() {
        this.addGlobalInfoMessage(SUCCESS_INFO_MSG_ID);
    }

    @Override
    public void addGlobalUnexpectedErrorMessage() {
        this.addGlobalErrorMessage(UNEXPECTED_ERROR_MSG_ID);
    }

    @Override
    public void addMessage(String clientId, FacesMessage.Severity severity, String key) {
        Locale locale = this.getLocale();
        FacesMessage facesMessage = MessageContextImpl.getInstance().newFacesMessage(locale, severity, key);
        FacesContext.getCurrentInstance().addMessage(clientId, facesMessage);
    }

    @Override
    public void addMessage(String clientId, FacesMessage.Severity severity, String key, Object argument) {
        Locale locale = this.getLocale();
        FacesMessage facesMessage = MessageContextImpl.getInstance().newFacesMessage(locale, severity, key, argument);
        FacesContext.getCurrentInstance().addMessage(clientId, facesMessage);
    }

    @Override
    public void addMessage(String clientId, FacesMessage.Severity severity, String key, Object ... arguments) {
        Locale locale = this.getLocale();
        FacesMessage facesMessage = MessageContextImpl.getInstance().newFacesMessage(locale, severity, key, arguments);
        FacesContext.getCurrentInstance().addMessage(clientId, facesMessage);
    }

    @Override
    public UIComponent matchComponentInHierarchy(UIComponent parent, String partialClientId) {
        UIComponent uiComponent;
        block1: {
            UIComponent child;
            block2: {
                uiComponent = null;
                if (parent == null) break block1;
                String parentClientId = parent.getClientId(this.getFacesContext());
                if (parentClientId == null || parentClientId.indexOf(partialClientId) < 0) break block2;
                uiComponent = parent;
                break block1;
            }
            Iterator itr = parent.getFacetsAndChildren();
            if (itr == null) break block1;
            while (itr.hasNext() && (uiComponent = this.matchComponentInHierarchy(child = (UIComponent)itr.next(), partialClientId)) == null) {
            }
        }
        return uiComponent;
    }

    @Override
    public UIComponent matchComponentInViewRoot(String partialClientId) {
        return this.matchComponentInHierarchy((UIComponent)FacesContext.getCurrentInstance().getViewRoot(), partialClientId);
    }

    @Override
    public void navigate(String fromAction, String outcome) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        facesContext.getApplication().getNavigationHandler().handleNavigation(facesContext, fromAction, outcome);
    }

    @Override
    public void navigateTo(String outcome) {
        this.navigate(null, outcome);
    }

    @Override
    public void recreateComponentTree() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        ViewHandler viewHandler = facesContext.getApplication().getViewHandler();
        UIViewRoot viewRoot = viewHandler.createView(facesContext, facesContext.getViewRoot().getViewId());
        facesContext.setViewRoot(viewRoot);
        facesContext.renderResponse();
    }

    @Override
    public void registerPhaseListener(PhaseListener phaseListener) throws IllegalStateException {
        LifecycleFactory lifecycleFactory = (LifecycleFactory)FactoryFinder.getFactory((String)"javax.faces.lifecycle.LifecycleFactory");
        Iterator lifecycleIds = lifecycleFactory.getLifecycleIds();
        while (lifecycleIds.hasNext()) {
            String lifecycleId = (String)lifecycleIds.next();
            lifecycleFactory.getLifecycle(lifecycleId).addPhaseListener(phaseListener);
        }
    }

    @Override
    public void removeChildrenFromComponentTree(String clientId) {
        UIComponent comp = FacesContext.getCurrentInstance().getViewRoot().findComponent(clientId);
        if (comp != null) {
            comp.getChildren().clear();
            comp.getFacets().clear();
        }
    }

    @Override
    public void removeMessages(String clientId) {
        Iterator facesMessags = FacesContext.getCurrentInstance().getMessages(clientId);
        while (facesMessags.hasNext()) {
            facesMessags.next();
            facesMessags.remove();
        }
    }

    @Override
    public void removeMessagesForImmediateComponents() {
        this.removeMessagesForImmediateComponents((UIComponent)FacesContext.getCurrentInstance().getViewRoot());
    }

    @Override
    public void removeMessagesForImmediateComponents(UIComponent uiComponent) {
        EditableValueHolder editableValueHolder;
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (uiComponent instanceof ActionSource) {
            ActionSource actionSource = (ActionSource)uiComponent;
            if (actionSource.isImmediate()) {
                this.removeMessages(uiComponent.getClientId(facesContext));
            }
        } else if (uiComponent instanceof EditableValueHolder && (editableValueHolder = (EditableValueHolder)uiComponent).isImmediate()) {
            this.removeMessages(uiComponent.getClientId(facesContext));
        }
        List childComponents = uiComponent.getChildren();
        for (UIComponent childComponent : childComponents) {
            this.removeMessagesForImmediateComponents(childComponent);
        }
    }

    @Override
    public void removeParentFormFromComponentTree(UIComponent uiComponent) {
        UIForm form = this.getParentForm(uiComponent);
        if (form != null) {
            form.getChildren().clear();
            form.getFacets().clear();
        }
    }

    @Override
    public void resetView() {
        this.resetView(true);
    }

    @Override
    public void resetView(boolean renderResponse) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        ViewHandler viewHandler = facesContext.getApplication().getViewHandler();
        UIViewRoot emptyView = viewHandler.createView(facesContext, facesContext.getViewRoot().getViewId());
        facesContext.setViewRoot(emptyView);
        if (renderResponse) {
            facesContext.renderResponse();
        }
    }

    @Override
    public Object resolveExpression(String elExpression) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        return facesContext.getApplication().getELResolver().getValue(facesContext.getELContext(), null, (Object)elExpression);
    }

    @Override
    public FacesContext getFacesContext() {
        return FacesContext.getCurrentInstance();
    }

    @Override
    public Map<String, String> getJavaScriptMap() {
        if (this.javaScriptMap == null) {
            this.javaScriptMap = new JavaScriptMap();
        }
        return this.javaScriptMap;
    }

    @Override
    public Locale getLocale() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        Locale locale = facesContext.getViewRoot().getLocale();
        if (locale == null) {
            locale = facesContext.getApplication().getDefaultLocale();
        }
        return locale;
    }

    @Override
    public String getMessage(String messageId) {
        return this.getMessage(this.getLocale(), messageId);
    }

    @Override
    public String getMessage(String messageId, Object ... arguments) {
        return MessageContext.getInstance().getMessage(this.getLocale(), messageId, arguments);
    }

    @Override
    public String getMessage(Locale locale, String messageId) {
        return MessageContext.getInstance().getMessage(locale, messageId);
    }

    @Override
    public String getMessage(Locale locale, String messageId, Object ... arguments) {
        return MessageContext.getInstance().getMessage(locale, messageId, arguments);
    }

    @Override
    public String getNamespace() {
        return FacesContext.getCurrentInstance().getExternalContext().encodeNamespace("");
    }

    @Override
    public UIForm getParentForm(UIComponent uiComponent) {
        UIComponent parent;
        for (parent = uiComponent; parent != null && !(parent instanceof UIForm); parent = parent.getParent()) {
        }
        return (UIForm)parent;
    }

    @Override
    public Object getRequestAttribute(String name) {
        ExternalContext externalContext = FacesContext.getCurrentInstance().getExternalContext();
        HttpServletRequest httpServletRequest = (HttpServletRequest)externalContext.getRequest();
        return httpServletRequest.getAttribute(name);
    }

    @Override
    public void setRequestAttribute(String name, Object value) {
        ExternalContext externalContext = FacesContext.getCurrentInstance().getExternalContext();
        HttpServletRequest httpServletRequest = (HttpServletRequest)externalContext.getRequest();
        httpServletRequest.setAttribute(name, value);
    }

    @Override
    public String getRequestContextPath() {
        return FacesContext.getCurrentInstance().getExternalContext().getRequestContextPath();
    }

    @Override
    public String getRequestParameter(String name) {
        HttpServletRequest httpServletRequest = (HttpServletRequest)FacesContext.getCurrentInstance().getExternalContext().getRequest();
        return httpServletRequest.getParameter(name);
    }

    @Override
    public boolean getRequestParameterAsBool(String name, boolean defaultValue) {
        return BooleanHelper.toBoolean(this.getRequestParameter(name), defaultValue);
    }

    @Override
    public int getRequestParameterAsInt(String name, int defaultValue) {
        return IntegerHelper.toInteger(this.getRequestParameter(name), defaultValue);
    }

    @Override
    public long getRequestParameterAsLong(String name, long defaultValue) {
        return LongHelper.toLong(this.getRequestParameter(name), defaultValue);
    }

    @Override
    public String getRequestParameterFromMap(String name) {
        return (String)FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap().get(name);
    }

    @Override
    public Map<String, String> getRequestParameterMap() {
        return FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap();
    }

    @Override
    public String getRequestQueryString() {
        return (String)this.getRequestAttribute("javax.servlet.forward.query_string");
    }

    @Override
    public String getRequestQueryStringParameter(String name) {
        String value = null;
        String queryString = this.getRequestQueryString();
        if (queryString != null) {
            String[] queryStringTokens = queryString.split("&");
            boolean found = false;
            for (int i = 0; !found && i < queryStringTokens.length; ++i) {
                String nameValuePair = queryStringTokens[i];
                String[] nameValuePairArray = nameValuePair.split("=");
                found = nameValuePairArray[0].equals(name);
                if (!found || nameValuePairArray.length <= 1) continue;
                value = nameValuePairArray[1];
            }
        }
        return value;
    }

    @Override
    public Object getSession(boolean create) {
        return FacesContext.getCurrentInstance().getExternalContext().getSession(create);
    }

    @Override
    public Object getSessionAttribute(String name) {
        Object value = null;
        HttpSession httpSession = (HttpSession)this.getSession(false);
        if (httpSession != null) {
            value = httpSession.getAttribute(name);
        }
        return value;
    }

    @Override
    public void setSessionAttribute(String name, Object value) {
        HttpSession httpSession = (HttpSession)this.getSession(true);
        if (httpSession != null) {
            httpSession.setAttribute(name, value);
        }
    }
}

