/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.portlet.component.renderurl.internal;

import com.liferay.faces.portlet.component.renderurl.RenderURLBase;
import com.liferay.faces.portlet.component.renderurl.internal.RenderURLRendererBase;
import java.io.IOException;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.portlet.BaseURL;
import javax.portlet.MimeResponse;
import javax.portlet.PortletMode;
import javax.portlet.PortletModeException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.portlet.WindowState;
import javax.portlet.WindowStateException;

public class AbstractRenderURLRenderer
extends RenderURLRendererBase {
    @Override
    protected BaseURL getBaseURL(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        String portletModeString;
        ExternalContext externalContext = facesContext.getExternalContext();
        MimeResponse mimeResponse = (MimeResponse)externalContext.getResponse();
        PortletURL renderURL = this.getPortletURL(mimeResponse, uiComponent);
        RenderURLBase renderURLcomponent = (RenderURLBase)uiComponent;
        PortletRequest portletRequest = (PortletRequest)externalContext.getRequest();
        if (renderURLcomponent.isCopyCurrentRenderParameters()) {
            Map currentRenderParameters = portletRequest.getParameterMap();
            String namespace = facesContext.getExternalContext().encodeNamespace("");
            for (Map.Entry param : currentRenderParameters.entrySet()) {
                String name = (String)param.getKey();
                if (name.contains(namespace)) {
                    name = name.substring(namespace.length());
                }
                renderURL.setParameter(name, (String[])param.getValue());
            }
        }
        PortletMode portletMode = (portletModeString = renderURLcomponent.getPortletMode()) != null ? new PortletMode(portletModeString) : portletRequest.getPortletMode();
        try {
            renderURL.setPortletMode(portletMode);
        }
        catch (PortletModeException e) {
            throw new IOException(e);
        }
        String windowStateString = renderURLcomponent.getWindowState();
        WindowState windowState = windowStateString != null ? new WindowState(windowStateString) : portletRequest.getWindowState();
        try {
            renderURL.setWindowState(windowState);
        }
        catch (WindowStateException e) {
            throw new IOException(e);
        }
        return renderURL;
    }

    protected PortletURL getPortletURL(MimeResponse mimeResponse, UIComponent uiComponent) {
        return mimeResponse.createRenderURL();
    }
}

