/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.portlet.component.baseurl.internal;

import com.liferay.faces.portlet.component.baseurl.BaseURL;
import com.liferay.faces.portlet.component.baseurl.internal.BaseURLRendererBase;
import com.liferay.faces.portlet.component.param.Param;
import com.liferay.faces.portlet.component.property.Property;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.portlet.PortletSecurityException;
import javax.portlet.faces.Bridge;
import javax.portlet.faces.BridgeUtil;

public abstract class BaseURLRenderer
extends BaseURLRendererBase {
    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        BaseURL baseURLComponent = (BaseURL)uiComponent;
        javax.portlet.BaseURL baseURL = this.getBaseURL(facesContext, uiComponent);
        Boolean secure = baseURLComponent.getSecure();
        if (secure != null) {
            try {
                baseURL.setSecure(secure.booleanValue());
            }
            catch (PortletSecurityException e) {
                throw new IOException(e);
            }
        }
        List children = baseURLComponent.getChildren();
        HashMap<String, String[]> parameterMap = new HashMap<String, String[]>(baseURL.getParameterMap());
        HashMap initialParameterMap = new HashMap(parameterMap);
        boolean RESOURCE_PHASE = BridgeUtil.getPortletRequestPhase().equals((Object)Bridge.PortletPhase.RESOURCE_PHASE);
        for (UIComponent child : children) {
            Property property;
            String value;
            if (child instanceof Param) {
                Param param = (Param)child;
                String name = param.getName();
                String value2 = param.getValue();
                if (parameterMap.containsKey(name)) {
                    boolean REMOVE_EMPTY_PARAMETER;
                    boolean PARAM_SET_BY_PORTLET_CONTAINER = initialParameterMap.containsKey(name);
                    boolean bl = REMOVE_EMPTY_PARAMETER = !RESOURCE_PHASE || !PARAM_SET_BY_PORTLET_CONTAINER;
                    if ("".equals(value2) && REMOVE_EMPTY_PARAMETER) {
                        parameterMap.remove(name);
                        continue;
                    }
                    if ("".equals(value2) && !REMOVE_EMPTY_PARAMETER) continue;
                    String[] paramValueArray = (String[])parameterMap.get(name);
                    String[] newParamValueArray = new String[paramValueArray.length + 1];
                    System.arraycopy(paramValueArray, 0, newParamValueArray, 0, paramValueArray.length);
                    newParamValueArray[newParamValueArray.length - 1] = value2;
                    parameterMap.put(name, newParamValueArray);
                    continue;
                }
                parameterMap.put(name, new String[]{value2});
                continue;
            }
            if (!(child instanceof Property) || (value = (property = (Property)child).getValue()) == null) continue;
            baseURL.addProperty(property.getName(), value);
        }
        baseURL.setParameters(parameterMap);
        String varName = baseURLComponent.getVar();
        String url = baseURL.toString();
        if (baseURLComponent.isEscapeXml()) {
            url = this.escapeXML(url);
        }
        if (varName == null) {
            ResponseWriter responseWriter = facesContext.getResponseWriter();
            responseWriter.write(url);
        } else {
            ExternalContext externalContext = facesContext.getExternalContext();
            Map requestMap = externalContext.getRequestMap();
            requestMap.put(varName, url);
        }
    }

    private String escapeXML(String text) {
        if (text == null) {
            return null;
        }
        if (text.length() == 0) {
            return "";
        }
        StringBuilder sb = null;
        int lastReplacementIndex = 0;
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            String replacement = null;
            switch (c) {
                case '<': {
                    replacement = "&lt;";
                    break;
                }
                case '>': {
                    replacement = "&gt;";
                    break;
                }
                case '&': {
                    replacement = "&amp;";
                    break;
                }
                case '\"': {
                    replacement = "&#034;";
                    break;
                }
                case '\'': {
                    replacement = "&#039;";
                    break;
                }
                case '\u00bb': {
                    replacement = "&#187;";
                    break;
                }
                case '\u2013': {
                    replacement = "&#x2013;";
                    break;
                }
                case '\u2014': {
                    replacement = "&#x2014;";
                }
            }
            if (replacement == null) continue;
            if (sb == null) {
                sb = new StringBuilder();
            }
            if (i > lastReplacementIndex) {
                sb.append(text.substring(lastReplacementIndex, i));
            }
            sb.append(replacement);
            lastReplacementIndex = i + 1;
        }
        if (sb == null) {
            return text;
        }
        if (lastReplacementIndex < text.length()) {
            sb.append(text.substring(lastReplacementIndex));
        }
        return sb.toString();
    }

    protected abstract javax.portlet.BaseURL getBaseURL(FacesContext var1, UIComponent var2) throws IOException;

    public boolean getRendersChildren() {
        return true;
    }
}

