/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.util.internal;

import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.net.URLEncoder;

public class FacesURLEncoder {
    private static final Logger logger = LoggerFactory.getLogger(FacesURLEncoder.class);
    private static final String MOJARRA_ENCODER_FQCN = "com.sun.faces.util.HtmlUtils";
    private static final String MOJARRA_METHOD_WRITE_URL = "writeURL";
    private static final String MYFACES_ENCODER_FQCN = "org.apache.myfaces.shared.renderkit.html.util.HTMLEncoder";
    private static final String MYFACES_METHOD_ENCODE_URI_ATTRIBUTE = "encodeURIAtributte";
    private static Class<?> mojarraHtmlUtilsClass;
    private static Method mojarraMethodWriteURL;
    private static Class<?> myFacesHTMLEncoderClass;
    private static Method myFacesMethodEncodeURIAtributte;

    public static String encode(String url, String encoding) {
        String encodedURL = url;
        if (url != null) {
            try {
                if (mojarraMethodWriteURL != null) {
                    StringWriter stringWriter = new StringWriter();
                    char[] urlBuf = new char[url.length() * 2];
                    mojarraMethodWriteURL.invoke(null, stringWriter, url, urlBuf, encoding);
                    stringWriter.flush();
                    encodedURL = stringWriter.toString();
                } else {
                    encodedURL = myFacesMethodEncodeURIAtributte != null ? (String)myFacesMethodEncodeURIAtributte.invoke(null, url, encoding) : URLEncoder.encode(url, encoding);
                }
            }
            catch (Exception e) {
                logger.error((Throwable)e);
            }
        }
        return encodedURL;
    }

    static {
        try {
            mojarraHtmlUtilsClass = Class.forName(MOJARRA_ENCODER_FQCN);
            mojarraMethodWriteURL = mojarraHtmlUtilsClass.getMethod(MOJARRA_METHOD_WRITE_URL, Writer.class, String.class, char[].class, String.class);
        }
        catch (Exception e1) {
            try {
                myFacesHTMLEncoderClass = Class.forName(MYFACES_ENCODER_FQCN);
                myFacesMethodEncodeURIAtributte = myFacesHTMLEncoderClass.getMethod(MYFACES_METHOD_ENCODE_URI_ATTRIBUTE, String.class, String.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

