/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.scope.internal;

import com.liferay.faces.bridge.config.BridgeConfig;
import com.liferay.faces.bridge.scope.internal.BridgeRequestScopeImpl;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import com.liferay.portal.kernel.util.JavaConstants;
import java.lang.reflect.Field;
import java.util.ArrayList;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.portlet.PortalContext;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletSession;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpSession;

public class BridgeRequestScopeLiferayImpl
extends BridgeRequestScopeImpl {
    private static final Logger logger;
    private static final long serialVersionUID = 1814762389345663517L;
    private static final String[] LIFERAY_ATTRIBUTE_NAMES;
    private static final String[] PORTLET_REQUEST_ATTRIBUTE_NAMES;

    public BridgeRequestScopeLiferayImpl(PortletRequest portletRequest, PortletConfig portletConfig, BridgeConfig bridgeConfig) {
        super(portletRequest, portletConfig, bridgeConfig);
    }

    @Override
    protected boolean isExcludedRequestAttributeByInstance(String attributeName, Object attributeValue) {
        boolean excluded = false;
        if (attributeValue != null) {
            if (attributeValue instanceof ExternalContext || attributeValue instanceof FacesContext) {
                excluded = true;
            } else if (attributeValue instanceof PortletConfig) {
                if (!"javax.portlet.config".equals(attributeName) && !"javax.portlet.portlet".equals(attributeName)) {
                    excluded = true;
                }
            } else if (attributeValue instanceof PortletRequest) {
                if (!"javax.portlet.request".equals(attributeName)) {
                    excluded = true;
                }
            } else if (attributeValue instanceof PortletResponse) {
                if (!"javax.portlet.response".equals(attributeName)) {
                    excluded = true;
                }
            } else if (attributeValue instanceof PortalContext || attributeValue instanceof PortletContext || attributeValue instanceof PortletPreferences || attributeValue instanceof PortletSession) {
                excluded = true;
            } else if ((attributeValue instanceof HttpSession || attributeValue instanceof ServletConfig || attributeValue instanceof ServletContext || attributeValue instanceof ServletRequest || attributeValue instanceof ServletResponse) && !attributeValue.getClass().getName().startsWith("com.liferay")) {
                excluded = true;
            }
        }
        return excluded;
    }

    @Override
    protected boolean isExcludedRequestAttributeByNamespace(String attributeName) {
        boolean excluded = false;
        if (this.isNamespaceMatch(attributeName, "javax.faces") || this.isNamespaceMatch(attributeName, "javax.servlet") || this.isNamespaceMatch(attributeName, "javax.servlet.include")) {
            excluded = true;
        } else if (this.isNamespaceMatch(attributeName, "javax.portlet.faces")) {
            if (!"javax.portlet.faces.phase".equals(attributeName)) {
                excluded = true;
            }
        } else if (this.isNamespaceMatch(attributeName, "javax.portlet")) {
            excluded = true;
        }
        if (excluded) {
            for (String liferayAttributeName : LIFERAY_ATTRIBUTE_NAMES) {
                if (!liferayAttributeName.equals(attributeName)) continue;
                excluded = false;
                break;
            }
        }
        if (excluded) {
            for (String portletRequestAttributeName : PORTLET_REQUEST_ATTRIBUTE_NAMES) {
                if (!portletRequestAttributeName.equals(attributeName)) continue;
                excluded = false;
                break;
            }
        }
        return excluded;
    }

    static {
        Field[] fields;
        logger = LoggerFactory.getLogger(BridgeRequestScopeLiferayImpl.class);
        PORTLET_REQUEST_ATTRIBUTE_NAMES = new String[]{"javax.portlet.ccpp", "javax.portlet.lifecycle_phase", "RENDER_HEADERS", "RENDER_MARKUP", "javax.portlet.render_part", "javax.portlet.userinfo"};
        ArrayList<String> fieldList = new ArrayList<String>();
        for (Field field : fields = JavaConstants.class.getFields()) {
            String fieldName = field.getName();
            if (fieldName == null || !fieldName.startsWith("JAVAX")) continue;
            try {
                Object value = field.get(null);
                if (value == null || !(value instanceof String)) continue;
                fieldList.add((String)value);
            }
            catch (Exception e) {
                logger.error((Throwable)e);
            }
        }
        LIFERAY_ATTRIBUTE_NAMES = fieldList.toArray(new String[fieldList.size()]);
    }
}

