/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.renderkit.richfaces.internal;

import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import com.liferay.faces.util.model.UploadedFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;

public class RichFacesUploadedFileHandler
implements InvocationHandler,
Serializable {
    private static final long serialVersionUID = 8136440019333815546L;
    private static final Logger logger = LoggerFactory.getLogger(RichFacesUploadedFileHandler.class);
    private static final String METHOD_DELETE = "delete";
    private static final String METHOD_GET_CONTENT_TYPE = "getContentType";
    private static final String METHOD_GET_DATA = "getData";
    private static final String METHOD_GET_INPUT_STREAM = "getInputStream";
    private static final String METHOD_GET_NAME = "getName";
    private static final String METHOD_GET_SIZE = "getSize";
    private static final String METHOD_WRITE = "write";
    private UploadedFile uploadedFile;

    public RichFacesUploadedFileHandler(UploadedFile uploadedFile) {
        this.uploadedFile = uploadedFile;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        if (METHOD_DELETE.equals(methodName)) {
            File file = new File(this.uploadedFile.getAbsolutePath());
            file.delete();
            return null;
        }
        if (METHOD_GET_CONTENT_TYPE.equals(methodName)) {
            return this.uploadedFile.getContentType();
        }
        if (METHOD_GET_DATA.equals(methodName)) {
            return this.getBytes();
        }
        if (METHOD_GET_INPUT_STREAM.equals(methodName)) {
            return new FileInputStream(this.uploadedFile.getAbsolutePath());
        }
        if (METHOD_GET_NAME.equals(methodName)) {
            return this.uploadedFile.getName();
        }
        if (METHOD_GET_SIZE.equals(methodName)) {
            return this.uploadedFile.getSize();
        }
        if (METHOD_WRITE.equals(methodName)) {
            String fileName = (String)args[0];
            FileOutputStream outputStream = new FileOutputStream(fileName);
            ((OutputStream)outputStream).write(this.getBytes());
            ((OutputStream)outputStream).close();
            return null;
        }
        return null;
    }

    protected byte[] getBytes() {
        byte[] bytes = null;
        try {
            File file = new File(this.uploadedFile.getAbsolutePath());
            if (file.exists()) {
                RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
                bytes = new byte[(int)randomAccessFile.length()];
                randomAccessFile.readFully(bytes);
                randomAccessFile.close();
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        return bytes;
    }
}

