/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.renderkit.richfaces.internal;

import com.liferay.faces.bridge.BridgeFactoryFinder;
import com.liferay.faces.bridge.context.BridgeContext;
import com.liferay.faces.bridge.context.map.internal.ContextMapFactory;
import com.liferay.faces.bridge.renderkit.richfaces.internal.RichFacesUploadedFileHandler;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import com.liferay.faces.util.model.UploadedFile;
import com.liferay.faces.util.render.RendererWrapper;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.FacesEvent;
import javax.faces.render.Renderer;

public class FileUploadRendererRichFacesImpl
extends RendererWrapper {
    private static final Logger logger = LoggerFactory.getLogger(FileUploadRendererRichFacesImpl.class);
    private static final String RICHFACES_UPLOADED_FILE_FQCN = "org.richfaces.model.UploadedFile";
    private static final String RICHFACES_FILE_UPLOAD_EVENT_FQCN = "org.richfaces.event.FileUploadEvent";
    private Renderer wrappedRenderer;

    public FileUploadRendererRichFacesImpl(Renderer renderer) {
        this.wrappedRenderer = renderer;
    }

    public void decode(FacesContext facesContext, UIComponent uiComponent) {
        try {
            ContextMapFactory contextMapFactory = (ContextMapFactory)BridgeFactoryFinder.getFactory(ContextMapFactory.class);
            BridgeContext bridgeContext = BridgeContext.getCurrentInstance();
            Map<String, List<UploadedFile>> uploadedFileMap = contextMapFactory.getUploadedFileMap(bridgeContext);
            if (uploadedFileMap != null) {
                Class<?> uploadedFileInterface = Class.forName(RICHFACES_UPLOADED_FILE_FQCN);
                Class<?> fileUploadEventClass = Class.forName(RICHFACES_FILE_UPLOAD_EVENT_FQCN);
                ClassLoader classLoader = uploadedFileInterface.getClassLoader();
                String clientId = uiComponent.getClientId(facesContext);
                List<UploadedFile> uploadedFiles = uploadedFileMap.get(clientId);
                if (uploadedFiles != null) {
                    for (UploadedFile uploadedFile : uploadedFiles) {
                        RichFacesUploadedFileHandler richFacesUploadedFileHandler = new RichFacesUploadedFileHandler(uploadedFile);
                        Object richFacesUploadedFile = Proxy.newProxyInstance(classLoader, new Class[]{uploadedFileInterface}, (InvocationHandler)richFacesUploadedFileHandler);
                        FacesEvent fileUploadEvent = (FacesEvent)fileUploadEventClass.getConstructor(UIComponent.class, uploadedFileInterface).newInstance(uiComponent, richFacesUploadedFile);
                        uiComponent.queueEvent(fileUploadEvent);
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
    }

    public Renderer getWrapped() {
        return this.wrappedRenderer;
    }
}

