/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.renderkit.primefaces.internal;

import com.liferay.faces.bridge.renderkit.html_basic.internal.BodyRendererBridgeImpl;
import com.liferay.faces.util.context.FacesRequestContext;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;

public class BodyRendererPrimeFacesImpl
extends BodyRendererBridgeImpl {
    private static final Logger logger = LoggerFactory.getLogger(BodyRendererPrimeFacesImpl.class);
    private static final Method GET_CURRENT_INSTANCE_METHOD;
    private static final Method GET_SCRIPTS_TO_EXECUTE_METHOD;

    @Override
    protected void encodeScripts(FacesContext facesContext, ResponseWriter responseWriter, UIComponent uiComponent) throws IOException {
        Object requestContext = this.getRequestContextCurrentInstance();
        try {
            List scriptsToExecute = (List)GET_SCRIPTS_TO_EXECUTE_METHOD.invoke(requestContext, new Object[0]);
            if (scriptsToExecute != null) {
                FacesRequestContext facesRequestContext = FacesRequestContext.getCurrentInstance();
                for (String scriptToExecute : scriptsToExecute) {
                    facesRequestContext.addScript(scriptToExecute);
                }
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        super.encodeScripts(facesContext, responseWriter, uiComponent);
    }

    protected Object getRequestContextCurrentInstance() {
        Object requestContext = null;
        try {
            requestContext = GET_CURRENT_INSTANCE_METHOD.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        return requestContext;
    }

    static {
        Method getCurrentInstanceMethod = null;
        Method getScriptsToExecuteMethod = null;
        try {
            Class<?> requestContextClass = Class.forName("org.primefaces.context.RequestContext");
            getCurrentInstanceMethod = requestContextClass.getDeclaredMethod("getCurrentInstance", new Class[0]);
            getScriptsToExecuteMethod = requestContextClass.getMethod("getScriptsToExecute", new Class[0]);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        GET_CURRENT_INSTANCE_METHOD = getCurrentInstanceMethod;
        GET_SCRIPTS_TO_EXECUTE_METHOD = getScriptsToExecuteMethod;
    }
}

