/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.renderkit.html_basic.internal;

import com.liferay.faces.bridge.renderkit.html_basic.internal.HeadManagedBean;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import java.util.Set;
import javax.faces.context.FacesContext;
import javax.faces.context.Flash;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import javax.portlet.faces.Bridge;
import javax.portlet.faces.BridgeUtil;

public class HeadPhaseListener
implements PhaseListener {
    private static final String HEAD_RESOURCE_IDS = "HEAD_RESOURCE_IDS";
    private static final long serialVersionUID = 8502242430265622811L;
    private static final Logger logger = LoggerFactory.getLogger(HeadPhaseListener.class);

    public void afterPhase(PhaseEvent phaseEvent) {
        if (logger.isDebugEnabled() && phaseEvent.getPhaseId() == PhaseId.INVOKE_APPLICATION) {
            FacesContext facesContext = phaseEvent.getFacesContext();
            String viewId = facesContext.getViewRoot().getViewId();
            logger.debug("After INVOKE_APPLICATION: viewId=[{0}]", new Object[]{viewId});
        }
    }

    public void beforePhase(PhaseEvent phaseEvent) {
        Bridge.PortletPhase portletRequestPhase = BridgeUtil.getPortletRequestPhase();
        if (portletRequestPhase == Bridge.PortletPhase.RESOURCE_PHASE || portletRequestPhase == Bridge.PortletPhase.RENDER_PHASE) {
            FacesContext facesContext;
            if (phaseEvent.getPhaseId() == PhaseId.APPLY_REQUEST_VALUES) {
                this.beforeApplyRequestValuesPhase(phaseEvent);
            } else if (phaseEvent.getPhaseId() == PhaseId.RENDER_RESPONSE && (facesContext = phaseEvent.getFacesContext()).getPartialViewContext().isAjaxRequest()) {
                this.beforeAjaxifiedRenderResponsePhase(phaseEvent);
            }
        }
    }

    protected void beforeAjaxifiedRenderResponsePhase(PhaseEvent phaseEvent) {
        FacesContext facesContext = phaseEvent.getFacesContext();
        Flash flash = facesContext.getExternalContext().getFlash();
        String viewId = facesContext.getViewRoot().getViewId();
        Set headResourceIdsFromFlash = (Set)flash.get((Object)HEAD_RESOURCE_IDS);
        if (headResourceIdsFromFlash != null) {
            HeadManagedBean headManagedBean = HeadManagedBean.getInstance(facesContext);
            Set<String> managedBeanResourceIds = headManagedBean.getHeadResourceIds();
            for (String resourceIdFromFlash : headResourceIdsFromFlash) {
                if (managedBeanResourceIds.contains(resourceIdFromFlash)) continue;
                managedBeanResourceIds.add(resourceIdFromFlash);
                logger.debug("Added resourceId=[{0}] from the Flash scope to the list of resourceIds in the HeadManagedBean for viewId=[{1}]", new Object[]{resourceIdFromFlash, viewId});
            }
        }
    }

    protected void beforeApplyRequestValuesPhase(PhaseEvent phaseEvent) {
        HeadManagedBean headManagedBean;
        FacesContext facesContext = phaseEvent.getFacesContext();
        Flash flash = facesContext.getExternalContext().getFlash();
        Set headResourceIdsFromFlash = (Set)flash.get((Object)HEAD_RESOURCE_IDS);
        logger.debug("Before APPLY_REQUEST_VALUES: viewId=[{0}]", new Object[]{facesContext.getViewRoot().getViewId()});
        if (headResourceIdsFromFlash == null && (headManagedBean = HeadManagedBean.getInstance(facesContext)) != null) {
            Set<String> headResourceIds = headManagedBean.getHeadResourceIds();
            if (flash != null && headResourceIds != null && headResourceIds.size() > 0) {
                flash.put((Object)HEAD_RESOURCE_IDS, headManagedBean.getHeadResourceIds());
            }
        }
    }

    public PhaseId getPhaseId() {
        return PhaseId.ANY_PHASE;
    }
}

