/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.internal;

import com.liferay.faces.bridge.BridgeFactoryFinder;
import com.liferay.faces.bridge.BridgePhase;
import com.liferay.faces.bridge.config.BridgeConfig;
import com.liferay.faces.bridge.config.internal.PortletConfigParam;
import com.liferay.faces.bridge.context.BridgeContext;
import com.liferay.faces.bridge.context.BridgeContextFactory;
import com.liferay.faces.bridge.context.IncongruityContext;
import com.liferay.faces.bridge.context.IncongruityContextFactory;
import com.liferay.faces.bridge.filter.BridgePortletContextFactory;
import com.liferay.faces.bridge.helper.internal.PortletModeHelper;
import com.liferay.faces.bridge.scope.BridgeRequestScope;
import com.liferay.faces.bridge.scope.BridgeRequestScopeCache;
import com.liferay.faces.bridge.scope.BridgeRequestScopeCacheFactory;
import com.liferay.faces.bridge.scope.BridgeRequestScopeFactory;
import com.liferay.faces.util.factory.FactoryExtensionFinder;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import javax.el.ELContext;
import javax.faces.FactoryFinder;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.context.FacesContextFactory;
import javax.faces.lifecycle.Lifecycle;
import javax.faces.lifecycle.LifecycleFactory;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletSession;
import javax.portlet.StateAwareResponse;
import javax.portlet.faces.Bridge;
import javax.portlet.faces.annotation.PortletNamingContainer;

public abstract class BridgePhaseBaseImpl
implements BridgePhase {
    private static final Logger logger = LoggerFactory.getLogger(BridgePhaseBaseImpl.class);
    private static final String PARAM_BRIDGE_REQUEST_SCOPE_ID = "com.liferay.faces.bridge.bridgeRequestScopeId";
    protected BridgeConfig bridgeConfig;
    protected BridgeContext bridgeContext;
    protected BridgeRequestScope bridgeRequestScope;
    protected BridgeRequestScopeCache bridgeRequestScopeCache;
    protected boolean bridgeRequestScopePreserved;
    protected FacesContext facesContext;
    protected IncongruityContext incongruityContext;
    protected Lifecycle facesLifecycle;
    protected PortletConfig portletConfig;
    protected PortletContext portletContext;
    protected String portletName;
    private FacesContextFactory facesContextFactory;
    private String pathInfo;
    private String servletPath;

    public BridgePhaseBaseImpl(PortletConfig portletConfig, BridgeConfig bridgeConfig) {
        this.portletConfig = portletConfig;
        this.bridgeConfig = bridgeConfig;
        this.portletName = portletConfig.getPortletName();
        this.bridgeRequestScopePreserved = PortletConfigParam.BridgeRequestScopePreserved.getBooleanValue(portletConfig);
        BridgePortletContextFactory bridgePortletContextFactory = (BridgePortletContextFactory)BridgeFactoryFinder.getFactory(BridgePortletContextFactory.class);
        this.portletContext = bridgePortletContextFactory.getPortletContext(portletConfig.getPortletContext());
        IncongruityContextFactory incongruityContextFactory = (IncongruityContextFactory)FactoryExtensionFinder.getFactory(IncongruityContextFactory.class);
        this.incongruityContext = incongruityContextFactory.getIncongruityContext();
        BridgeRequestScopeCacheFactory bridgeRequestScopeCacheFactory = (BridgeRequestScopeCacheFactory)BridgeFactoryFinder.getFactory(BridgeRequestScopeCacheFactory.class);
        this.bridgeRequestScopeCache = bridgeRequestScopeCacheFactory.getBridgeRequestScopeCache(this.portletContext);
        LifecycleFactory lifecycleFactory = (LifecycleFactory)FactoryFinder.getFactory((String)"javax.faces.lifecycle.LifecycleFactory");
        String lifecycleId = this.portletContext.getInitParameter("javax.faces.LIFECYCLE_ID");
        if (lifecycleId == null) {
            lifecycleId = "DEFAULT";
        }
        this.facesLifecycle = lifecycleFactory.getLifecycle(lifecycleId);
    }

    protected abstract void removeBridgeContextAttribute(PortletRequest var1);

    protected void cleanup() {
        if (this.facesContext != null) {
            this.facesContext.release();
        }
        if (this.bridgeContext != null) {
            PortletRequest portletRequest = this.bridgeContext.getPortletRequest();
            if (portletRequest != null) {
                this.removeBridgeContextAttribute(portletRequest);
                portletRequest.removeAttribute("javax.portlet.faces.phase");
                portletRequest.setAttribute("javax.servlet.include.path_info", (Object)this.pathInfo);
                portletRequest.setAttribute("javax.servlet.include.servlet_path", (Object)this.servletPath);
            }
            this.bridgeContext.release();
        }
    }

    protected void indicateNamespacingToConsumers(UIViewRoot uiViewRoot, PortletResponse portletResponse) {
        if (uiViewRoot != null) {
            if (uiViewRoot.getClass().getAnnotation(PortletNamingContainer.class) != null) {
                portletResponse.addProperty("X-JAVAX-PORTLET-FACES-NAMESPACED-RESPONSE", Boolean.TRUE.toString());
            }
        } else {
            logger.debug("UIViewRoot is null -- might be push related");
        }
    }

    protected void init(PortletRequest portletRequest, PortletResponse portletResponse, Bridge.PortletPhase portletPhase) {
        portletRequest.setAttribute("javax.portlet.faces.phase", (Object)portletPhase);
        this.initBridgeRequestScope(portletRequest, portletResponse, portletPhase);
        BridgeContextFactory bridgeContextFactory = (BridgeContextFactory)BridgeFactoryFinder.getFactory(BridgeContextFactory.class);
        this.bridgeContext = bridgeContextFactory.getBridgeContext(this.bridgeConfig, this.bridgeRequestScope, this.portletConfig, this.portletContext, portletRequest, portletResponse, portletPhase, this.incongruityContext);
        this.setBridgeContextAttribute(portletRequest, this.bridgeContext);
        this.facesContext = this.getFacesContext(portletRequest, portletResponse, this.facesLifecycle);
        this.pathInfo = (String)portletRequest.getAttribute("javax.servlet.include.path_info");
        portletRequest.removeAttribute("javax.servlet.include.path_info");
        this.servletPath = (String)portletRequest.getAttribute("javax.servlet.include.servlet_path");
        portletRequest.removeAttribute("javax.servlet.include.servlet_path");
        for (String portletMode : PortletModeHelper.PORTLET_MODE_NAMES) {
            String attributeName = "javax.portlet.faces.viewIdHistory." + portletMode;
            PortletSession portletSession = portletRequest.getPortletSession();
            if (portletSession.getAttribute(attributeName) != null) continue;
            portletSession.setAttribute(attributeName, this.bridgeContext.getDefaultViewIdMap().get(portletMode));
        }
    }

    protected void initBridgeRequestScope(PortletRequest portletRequest, PortletResponse portletResponse, Bridge.PortletPhase portletPhase) {
        boolean bridgeRequestScopeEnabled = true;
        if (portletPhase == Bridge.PortletPhase.RESOURCE_PHASE) {
            bridgeRequestScopeEnabled = PortletConfigParam.BridgeRequestScopeAjaxEnabled.getBooleanValue(this.portletConfig);
        }
        if (bridgeRequestScopeEnabled) {
            PortletSession portletSession;
            String portletName = this.portletConfig.getPortletName();
            String bridgeRequestScopeKey = portletName + PARAM_BRIDGE_REQUEST_SCOPE_ID;
            String bridgeRequestScopeId = portletRequest.getParameter(bridgeRequestScopeKey);
            if (bridgeRequestScopeId != null) {
                this.bridgeRequestScope = (BridgeRequestScope)this.bridgeRequestScopeCache.get((Object)bridgeRequestScopeId);
                if (this.bridgeRequestScope != null) {
                    logger.debug("Found render parameter name=[{0}] value=[{1}] and cached bridgeRequestScope=[{2}]", new Object[]{bridgeRequestScopeKey, bridgeRequestScopeId, this.bridgeRequestScope});
                } else if (this.bridgeRequestScopePreserved) {
                    logger.error("Found render parameter name=[{0}] value=[{1}] BUT bridgeRequestScope is NOT in the cache", new Object[]{bridgeRequestScopeKey, bridgeRequestScopeId});
                }
            }
            if (this.bridgeRequestScope == null && (bridgeRequestScopeId = (String)(portletSession = portletRequest.getPortletSession()).getAttribute(bridgeRequestScopeKey)) != null) {
                portletSession.removeAttribute(bridgeRequestScopeKey);
                this.bridgeRequestScope = (BridgeRequestScope)this.bridgeRequestScopeCache.get((Object)bridgeRequestScopeId);
                if (this.bridgeRequestScope != null) {
                    logger.debug("Found (and removed) session-attribute name=[{0}] value=[{1}] and cached bridgeRequestScope=[{2}]", new Object[]{bridgeRequestScopeKey, bridgeRequestScopeId, this.bridgeRequestScope});
                    if (portletResponse instanceof StateAwareResponse) {
                        logger.debug("Setting former session-attribute as render parameter name=[{0}] value=[{1}]", new Object[]{bridgeRequestScopeKey, bridgeRequestScopeId});
                        StateAwareResponse stateAwareResponse = (StateAwareResponse)portletResponse;
                        stateAwareResponse.setRenderParameter(bridgeRequestScopeKey, bridgeRequestScopeId);
                    }
                } else {
                    logger.error("Found session attribute name=[{0}] value=[{1}] but bridgeRequestScope is not in the cache", new Object[]{bridgeRequestScopeKey, bridgeRequestScopeId});
                }
            }
            if (this.bridgeRequestScope == null) {
                BridgeRequestScopeFactory bridgeRequestScopeFactory = (BridgeRequestScopeFactory)FactoryExtensionFinder.getFactory(BridgeRequestScopeFactory.class);
                this.bridgeRequestScope = bridgeRequestScopeFactory.getBridgeRequestScope(portletRequest, this.portletConfig, this.bridgeConfig);
            }
        }
    }

    protected void maintainBridgeRequestScope(PortletRequest portletRequest, PortletResponse portletResponse, BridgeRequestScope.Transport bridgeRequestScopeTransport) {
        block5: {
            String bridgeRequestScopeId = this.bridgeRequestScope.getId();
            this.bridgeRequestScopeCache.put((Object)bridgeRequestScopeId, (Object)this.bridgeRequestScope);
            String bridgeRequestScopeKey = this.portletName + PARAM_BRIDGE_REQUEST_SCOPE_ID;
            if (bridgeRequestScopeTransport == BridgeRequestScope.Transport.PORTLET_SESSION_ATTRIBUTE) {
                PortletSession portletSession = portletRequest.getPortletSession(true);
                portletSession.setAttribute(bridgeRequestScopeKey, (Object)bridgeRequestScopeId);
            } else if (portletResponse instanceof StateAwareResponse) {
                logger.debug("Setting render parameter name=[{0}] value=[{1}]", new Object[]{bridgeRequestScopeKey, bridgeRequestScopeId});
                try {
                    StateAwareResponse stateAwareResponse = (StateAwareResponse)portletResponse;
                    stateAwareResponse.setRenderParameter(bridgeRequestScopeKey, bridgeRequestScopeId);
                }
                catch (IllegalStateException e) {
                    if (this.bridgeRequestScope.isRedirectOccurred()) break block5;
                    throw e;
                }
            }
        }
    }

    protected abstract void setBridgeContextAttribute(PortletRequest var1, BridgeContext var2);

    protected FacesContext getFacesContext(PortletRequest portletRequest, PortletResponse portletResponse, Lifecycle lifecycle) {
        FacesContext newFacesContext = this.getFacesContextFactory().getFacesContext((Object)this.portletContext, (Object)portletRequest, (Object)portletResponse, lifecycle);
        ELContext elContext = newFacesContext.getELContext();
        elContext.putContext(FacesContext.class, (Object)newFacesContext);
        return newFacesContext;
    }

    protected FacesContextFactory getFacesContextFactory() {
        if (this.facesContextFactory == null) {
            this.facesContextFactory = (FacesContextFactory)FactoryFinder.getFactory((String)"javax.faces.context.FacesContextFactory");
        }
        return this.facesContextFactory;
    }
}

