/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.internal;

import com.liferay.faces.bridge.BridgeFactoryFinder;
import com.liferay.faces.bridge.config.BridgeConfig;
import com.liferay.faces.bridge.filter.BridgePortletRequestFactory;
import com.liferay.faces.bridge.filter.BridgePortletResponseFactory;
import com.liferay.faces.bridge.internal.BridgePhaseCompat_2_2_Impl;
import com.liferay.faces.bridge.scope.BridgeRequestScope;
import com.liferay.faces.util.factory.FactoryExtensionFinder;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletMode;
import javax.portlet.PortletModeException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.faces.Bridge;
import javax.portlet.faces.BridgeDefaultViewNotSpecifiedException;
import javax.portlet.faces.BridgeException;

public class BridgePhaseActionImpl
extends BridgePhaseCompat_2_2_Impl {
    private static final Logger logger = LoggerFactory.getLogger(BridgePhaseActionImpl.class);
    private ActionRequest actionRequest;
    private ActionResponse actionResponse;

    public BridgePhaseActionImpl(ActionRequest actionRequest, ActionResponse actionResponse, PortletConfig portletConfig, BridgeConfig bridgeConfig) {
        super(portletConfig, bridgeConfig);
        BridgePortletRequestFactory bridgePortletRequestFactory = (BridgePortletRequestFactory)FactoryExtensionFinder.getFactory(BridgePortletRequestFactory.class);
        this.actionRequest = bridgePortletRequestFactory.getActionRequest(actionRequest);
        BridgePortletResponseFactory bridgePortletResponseFactory = (BridgePortletResponseFactory)BridgeFactoryFinder.getFactory(BridgePortletResponseFactory.class);
        this.actionResponse = bridgePortletResponseFactory.getActionResponse(actionResponse);
    }

    public void execute() throws BridgeDefaultViewNotSpecifiedException, BridgeException {
        logger.debug("----------------------------------------------------------------------");
        logger.debug("execute(ActionRequest, ActionResponse) portletName=[{0}]", new Object[]{this.portletName});
        try {
            this.init((PortletRequest)this.actionRequest, (PortletResponse)this.actionResponse, Bridge.PortletPhase.ACTION_PHASE);
            this.bridgeRequestScope.setPortletMode(this.actionRequest.getPortletMode());
            String portletModeParam = this.actionRequest.getParameter("javax.portlet.faces.PortletMode");
            if (portletModeParam != null) {
                try {
                    this.actionResponse.setPortletMode(new PortletMode(portletModeParam));
                }
                catch (PortletModeException e) {
                    logger.error("Invalid parameter value {0}=[{1}]}", new Object[]{"javax.portlet.faces.PortletMode", portletModeParam});
                }
            }
            this.attachClientWindowToLifecycle(this.facesContext, this.facesLifecycle);
            this.facesLifecycle.execute(this.facesContext);
            Throwable handledException = this.getJSF2HandledException(this.facesContext);
            if (handledException != null) {
                throw new BridgeException(handledException);
            }
            Throwable unhandledException = this.getJSF2UnhandledException(this.facesContext);
            if (unhandledException != null) {
                throw new BridgeException(unhandledException);
            }
            this.bridgeRequestScope.setFacesLifecycleExecuted(true);
            this.clearHeadManagedBeanResources(this.facesContext);
            this.bridgeRequestScope.saveState(this.facesContext);
            if (!this.bridgeRequestScope.isRedirectOccurred() || !this.bridgeRequestScope.isPortletModeChanged()) {
                this.maintainBridgeRequestScope((PortletRequest)this.actionRequest, (PortletResponse)this.actionResponse, BridgeRequestScope.Transport.RENDER_PARAMETER);
            }
            this.indicateNamespacingToConsumers(this.facesContext.getViewRoot(), (PortletResponse)this.actionResponse);
        }
        catch (Throwable t) {
            throw new BridgeException(t);
        }
        finally {
            this.cleanup();
        }
    }
}

