/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.filter.liferay.internal;

import com.liferay.faces.bridge.filter.liferay.LiferayURLGenerator;
import com.liferay.faces.bridge.util.internal.URLParameter;
import com.liferay.faces.util.helper.StringHelper;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import com.liferay.faces.util.product.Product;
import com.liferay.faces.util.product.ProductMap;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.service.PortletLocalServiceUtil;
import com.liferay.portal.theme.ThemeDisplay;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.faces.context.FacesContext;
import javax.portlet.PortletMode;
import javax.portlet.PortletRequest;
import javax.portlet.WindowState;

public abstract class LiferayURLGeneratorBaseImpl
implements LiferayURLGenerator {
    private static final Logger logger = LoggerFactory.getLogger(LiferayURLGeneratorBaseImpl.class);
    private static final String CONTROL_PANEL_CATEGORY = "controlPanelCategory";
    private static final String DO_AS_GROUP_ID = "doAsGroupId";
    private static final String DO_AS_USER_ID = "doAsUserId";
    private static final String DO_AS_USER_LANGUAGE_ID = "doAsUserLanguageId";
    private static final int LIFERAY_BUILD_NUMBER = ((Product)ProductMap.getInstance().get((Object)"Liferay Portal")).getBuildId();
    public static final String P_AUTH = "p_auth";
    public static final String P_L_ID = "p_l_id";
    public static final String P_P_AUTH = "p_p_auth";
    public static final String P_P_CACHEABILITY = "p_p_cacheability";
    public static final String P_P_COL_ID = "p_p_col_id";
    public static final String P_P_COL_POS = "p_p_col_pos";
    public static final String P_P_COL_COUNT = "p_p_col_count";
    public static final String P_P_ID = "p_p_id";
    public static final String P_P_MODE = "p_p_mode";
    public static final String P_P_LIFECYCLE = "p_p_lifecycle";
    public static final String P_O_P_ID = "p_o_p_id";
    public static final String P_P_RESOURCE_ID = "p_p_resource_id";
    public static final String P_P_STATE = "p_p_state";
    public static final String P_P_STATE_RCV = "p_p_state_rcv";
    private static final String REFERER_GROUP_ID = "refererGroupId";
    private static final String REFERER_PLID = "refererPlid";
    protected static final String LIFECYCLE_RESOURCE_PHASE_ID = "2";
    private static final ArrayList<String> LIFERAY_NON_NAMESPACED_PARAMS = new ArrayList(5);
    private String baseURL;
    private Map<String, String> parameterMap;
    private PortletMode initialPortletMode;
    private String prefix;
    private String responseNamespace;
    private WindowState initialWindowState;
    private List<URLParameter> wsrpParameters;
    private String portletURLAnchor;

    public LiferayURLGeneratorBaseImpl(String baseURL, String responseNamespace) {
        this(baseURL, null, responseNamespace, null);
    }

    public LiferayURLGeneratorBaseImpl(String baseURL, PortletMode portletMode, String responseNamespace, WindowState windowState) {
        this.baseURL = baseURL;
        this.initialPortletMode = portletMode;
        this.responseNamespace = responseNamespace;
        this.initialWindowState = windowState;
        this.parse();
    }

    @Override
    public String generateURL(Map<String, String[]> additionalParameterMap) {
        return this.generateURL(additionalParameterMap, null, null, null, null);
    }

    @Override
    public String generateURL(Map<String, String[]> additionalParameterMap, String cacheability, String resourceId) {
        return this.generateURL(additionalParameterMap, cacheability, null, resourceId, null);
    }

    @Override
    public String generateURL(Map<String, String[]> additionalParameterMap, PortletMode portletMode, WindowState windowState) {
        return this.generateURL(additionalParameterMap, null, portletMode, null, windowState);
    }

    public String generateURL(Map<String, String[]> additionalParameterMap, String cacheability, PortletMode portletMode, String resourceId, WindowState windowState) {
        String toStringValue;
        if (this.baseURL.contains("/-/")) {
            toStringValue = this.baseURL;
        } else {
            String controlPanelCategory;
            String refererPlid;
            String refererGroupId;
            String doAsGroupId;
            String doAsUserLanguageId;
            String doAsUserId;
            String outerPortletId;
            String parameterValue;
            String portletAuthToken;
            String plid;
            StringBuilder url = new StringBuilder();
            url.append(this.prefix);
            boolean firstParameter = true;
            String portalAuthToken = StringHelper.toString((String[])additionalParameterMap.get(P_AUTH), (String)this.parameterMap.get(P_AUTH));
            if (portalAuthToken != null) {
                this.appendParameterToURL(firstParameter, P_AUTH, portalAuthToken, url);
                firstParameter = false;
            }
            if ((plid = StringHelper.toString((String[])additionalParameterMap.get(P_L_ID), (String)this.parameterMap.get(P_L_ID))) != null) {
                this.appendParameterToURL(firstParameter, P_L_ID, plid, url);
                firstParameter = false;
            }
            if ((portletAuthToken = StringHelper.toString((String[])additionalParameterMap.get(P_P_AUTH), (String)this.parameterMap.get(P_P_AUTH))) != null) {
                boolean addPortletAuthToken = true;
                if (LIFERAY_BUILD_NUMBER < 6102 || LIFERAY_BUILD_NUMBER > 6102 && LIFERAY_BUILD_NUMBER < 6130) {
                    FacesContext facesContext = FacesContext.getCurrentInstance();
                    PortletRequest portletRequest = (PortletRequest)facesContext.getExternalContext().getRequest();
                    String portletId = (String)portletRequest.getAttribute("PORTLET_ID");
                    ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
                    try {
                        Portlet portlet = PortletLocalServiceUtil.getPortletById((long)themeDisplay.getCompanyId(), (String)portletId);
                        addPortletAuthToken = portlet.isAddDefaultResource();
                    }
                    catch (SystemException e) {
                        logger.error((Throwable)e);
                    }
                }
                if (addPortletAuthToken) {
                    this.appendParameterToURL(firstParameter, P_P_AUTH, portletAuthToken, url);
                    firstParameter = false;
                }
            }
            if ((parameterValue = StringHelper.toString((String[])additionalParameterMap.get(P_P_ID), (String)this.responseNamespace)).startsWith("_")) {
                parameterValue = parameterValue.substring(1);
            }
            if (parameterValue.endsWith("_")) {
                parameterValue = parameterValue.substring(0, parameterValue.length() - 1);
            }
            this.appendParameterToURL(firstParameter, P_P_ID, parameterValue, url);
            firstParameter = false;
            String portletLifecycleId = this.getPortletLifecycleId();
            this.appendParameterToURL(P_P_LIFECYCLE, portletLifecycleId, url);
            FacesContext facesContext = FacesContext.getCurrentInstance();
            Map applicationMap = facesContext.getExternalContext().getApplicationMap();
            WindowState urlWindowState = this.initialWindowState;
            if (additionalParameterMap.get(P_P_STATE) != null) {
                urlWindowState = new WindowState(additionalParameterMap.get(P_P_STATE)[0]);
            }
            if (windowState != null) {
                urlWindowState = windowState;
            }
            parameterValue = urlWindowState == null ? (String)applicationMap.get(this.responseNamespace + P_P_STATE) : urlWindowState.toString();
            this.appendParameterToURL(P_P_STATE, parameterValue, url);
            String stateRestoreCurrentView = StringHelper.toString((String[])additionalParameterMap.get(P_P_STATE_RCV), (String)this.parameterMap.get(P_P_STATE_RCV));
            if (stateRestoreCurrentView != null) {
                this.appendParameterToURL(P_P_STATE_RCV, stateRestoreCurrentView, url);
            }
            PortletMode urlPortletMode = this.initialPortletMode;
            if (additionalParameterMap.get(P_P_MODE) != null) {
                urlPortletMode = new PortletMode(additionalParameterMap.get(P_P_MODE)[0]);
            }
            if (portletMode != null) {
                urlPortletMode = portletMode;
            }
            parameterValue = urlPortletMode == null ? (String)applicationMap.get(this.responseNamespace + P_P_MODE) : urlPortletMode.toString();
            this.appendParameterToURL(P_P_MODE, parameterValue, url);
            if (LIFECYCLE_RESOURCE_PHASE_ID.equals(portletLifecycleId)) {
                String urlCacheability = null;
                if (cacheability != null) {
                    urlCacheability = cacheability;
                }
                if (urlCacheability == null) {
                    urlCacheability = StringHelper.toString((String[])additionalParameterMap.get(P_P_CACHEABILITY), (String)this.parameterMap.get(P_P_CACHEABILITY));
                }
                if (urlCacheability != null) {
                    this.appendParameterToURL(P_P_CACHEABILITY, urlCacheability, url);
                }
            }
            parameterValue = (String)applicationMap.get(this.responseNamespace + P_P_COL_ID);
            this.appendParameterToURL(P_P_COL_ID, parameterValue, url);
            parameterValue = (String)applicationMap.get(this.responseNamespace + P_P_COL_COUNT);
            this.appendParameterToURL(P_P_COL_COUNT, parameterValue, url);
            parameterValue = (String)applicationMap.get(this.responseNamespace + P_P_COL_POS);
            if (parameterValue != null && parameterValue.length() > 0) {
                try {
                    int colPos = Integer.parseInt(parameterValue);
                    if (colPos > 0) {
                        this.appendParameterToURL(P_P_COL_POS, parameterValue, url);
                    }
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            if ((outerPortletId = StringHelper.toString((String[])additionalParameterMap.get(P_O_P_ID), (String)this.parameterMap.get(P_O_P_ID))) != null) {
                this.appendParameterToURL(P_O_P_ID, outerPortletId, url);
            }
            if ((doAsUserId = StringHelper.toString((String[])additionalParameterMap.get(DO_AS_USER_ID), (String)this.parameterMap.get(DO_AS_USER_ID))) != null) {
                this.appendParameterToURL(DO_AS_USER_ID, doAsUserId, url);
            }
            if ((doAsUserLanguageId = StringHelper.toString((String[])additionalParameterMap.get(DO_AS_USER_LANGUAGE_ID), (String)this.parameterMap.get(DO_AS_USER_LANGUAGE_ID))) != null) {
                this.appendParameterToURL(DO_AS_USER_LANGUAGE_ID, doAsUserLanguageId, url);
            }
            if ((doAsGroupId = StringHelper.toString((String[])additionalParameterMap.get(DO_AS_GROUP_ID), (String)this.parameterMap.get(DO_AS_GROUP_ID))) != null) {
                this.appendParameterToURL(DO_AS_GROUP_ID, doAsGroupId, url);
            }
            if ((refererGroupId = StringHelper.toString((String[])additionalParameterMap.get(REFERER_GROUP_ID), (String)this.parameterMap.get(REFERER_GROUP_ID))) != null) {
                this.appendParameterToURL(REFERER_GROUP_ID, refererGroupId, url);
            }
            if ((refererPlid = StringHelper.toString((String[])additionalParameterMap.get(REFERER_PLID), (String)this.parameterMap.get(REFERER_PLID))) != null) {
                this.appendParameterToURL(REFERER_PLID, refererPlid, url);
            }
            if ((controlPanelCategory = StringHelper.toString((String[])additionalParameterMap.get(CONTROL_PANEL_CATEGORY), (String)this.parameterMap.get(CONTROL_PANEL_CATEGORY))) != null) {
                this.appendParameterToURL(CONTROL_PANEL_CATEGORY, controlPanelCategory, url);
            }
            boolean namespaced = !this.responseNamespace.startsWith("wsrp");
            Set<Map.Entry<String, String[]>> mapEntries = additionalParameterMap.entrySet();
            if (mapEntries != null) {
                for (Map.Entry entry : mapEntries) {
                    String parameterName;
                    String[] parameterValues = (String[])entry.getValue();
                    if (parameterValues == null || LIFERAY_NON_NAMESPACED_PARAMS.contains(parameterName = (String)entry.getKey())) continue;
                    for (String curParameterValue : parameterValues) {
                        if (curParameterValue == null) continue;
                        String encodedParameterValue = this.encode(curParameterValue);
                        this.appendParameterToURL(firstParameter, namespaced, parameterName, encodedParameterValue, url);
                    }
                }
            }
            for (URLParameter uRLParameter : this.wsrpParameters) {
                this.appendParameterToURL((String)uRLParameter.getName(), (String)uRLParameter.getValue(), url);
            }
            String urlResourceId = this.parameterMap.get(P_O_P_ID);
            if (resourceId != null) {
                urlResourceId = resourceId;
            }
            if (urlResourceId == null) {
                if (this.prefix.startsWith("wsrp")) {
                    this.appendParameterToURL(P_P_RESOURCE_ID, "wsrp", url);
                }
            } else {
                this.appendParameterToURL(P_P_RESOURCE_ID, urlResourceId, url);
            }
            if (this.portletURLAnchor != null) {
                url.append(this.portletURLAnchor);
            }
            toStringValue = url.toString();
        }
        return toStringValue;
    }

    protected void appendParameterToURL(String parameterName, String parameterValue, StringBuilder url) {
        this.appendParameterToURL(false, false, parameterName, parameterValue, url);
    }

    protected void appendParameterToURL(boolean firstParameter, String parameterName, String parameterValue, StringBuilder url) {
        this.appendParameterToURL(firstParameter, false, parameterName, parameterValue, url);
    }

    protected void appendParameterToURL(boolean firstParameter, boolean namespaced, String parameterName, String parameterValue, StringBuilder url) {
        if (!firstParameter) {
            url.append("&");
        }
        if (namespaced) {
            url.append(this.responseNamespace);
        }
        url.append(parameterName);
        url.append("=");
        url.append(parameterValue);
        logger.debug("Appended param to URL name=[{0}] parameterValue=[{1}]", new Object[]{parameterName, parameterValue});
    }

    protected String encode(String value) {
        String encodedValue = "";
        if (value != null && value.length() > 0) {
            try {
                encodedValue = URLEncoder.encode(value, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                logger.error((Throwable)e);
                encodedValue = "";
            }
        }
        return encodedValue;
    }

    protected void parse() {
        int pos;
        String[] nameValuePairs;
        this.parameterMap = new HashMap<String, String>();
        this.wsrpParameters = new ArrayList<URLParameter>();
        String queryString = this.baseURL;
        int queryPos = this.baseURL.indexOf("?");
        if (queryPos > 0) {
            this.prefix = this.baseURL.substring(0, queryPos + 1);
            queryString = this.baseURL.substring(queryPos + 1);
        }
        if ((nameValuePairs = queryString.split("[&]")) != null) {
            for (String nameValuePair : nameValuePairs) {
                int equalsPos = nameValuePair.indexOf("=");
                if (equalsPos <= 0) continue;
                String name = nameValuePair.substring(0, equalsPos);
                String value = nameValuePair.substring(equalsPos + 1);
                if (nameValuePair.startsWith("wsrp")) {
                    URLParameter urlParameter = new URLParameter(name, value);
                    this.wsrpParameters.add(urlParameter);
                    continue;
                }
                this.parameterMap.put(name, value);
            }
        }
        if ((pos = this.baseURL.indexOf("#")) > 0) {
            this.portletURLAnchor = this.baseURL.substring(pos);
        }
    }

    static {
        LIFERAY_NON_NAMESPACED_PARAMS.add(P_AUTH);
        LIFERAY_NON_NAMESPACED_PARAMS.add(P_L_ID);
        LIFERAY_NON_NAMESPACED_PARAMS.add(P_P_AUTH);
        LIFERAY_NON_NAMESPACED_PARAMS.add(P_P_ID);
        LIFERAY_NON_NAMESPACED_PARAMS.add(P_P_STATE);
        LIFERAY_NON_NAMESPACED_PARAMS.add(P_P_STATE_RCV);
        LIFERAY_NON_NAMESPACED_PARAMS.add(P_P_MODE);
        LIFERAY_NON_NAMESPACED_PARAMS.add(P_P_CACHEABILITY);
        LIFERAY_NON_NAMESPACED_PARAMS.add(P_O_P_ID);
        LIFERAY_NON_NAMESPACED_PARAMS.add(DO_AS_USER_ID);
        LIFERAY_NON_NAMESPACED_PARAMS.add(DO_AS_USER_LANGUAGE_ID);
        LIFERAY_NON_NAMESPACED_PARAMS.add(DO_AS_GROUP_ID);
        LIFERAY_NON_NAMESPACED_PARAMS.add(REFERER_GROUP_ID);
        LIFERAY_NON_NAMESPACED_PARAMS.add(REFERER_PLID);
        LIFERAY_NON_NAMESPACED_PARAMS.add(CONTROL_PANEL_CATEGORY);
    }
}

