/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.filter.liferay.internal;

import com.liferay.faces.bridge.filter.liferay.LiferayBaseURL;
import com.liferay.faces.bridge.filter.liferay.LiferayURLGenerator;
import com.liferay.faces.bridge.util.internal.FacesURLEncoder;
import java.io.IOException;
import java.io.Writer;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.portlet.PortletSecurityException;

public abstract class LiferayBaseURLImpl
implements LiferayBaseURL {
    private LiferayURLGenerator liferayURLGenerator;
    private Map<String, String[]> parameterMap;

    public LiferayBaseURLImpl(LiferayURLGenerator liferayURLGenerator) {
        this.liferayURLGenerator = liferayURLGenerator;
        this.parameterMap = new LinkedHashMap<String, String[]>();
    }

    public void addProperty(String key, String value) {
    }

    public void write(Writer writer) throws IOException {
        writer.write(this.toString());
    }

    public void write(Writer writer, boolean escapeXML) throws IOException {
        String valueAsString = this.toString();
        if (escapeXML) {
            valueAsString = FacesURLEncoder.encode(valueAsString, "UTF-8");
        }
        writer.write(valueAsString);
    }

    protected abstract void resetToString();

    public LiferayURLGenerator getLiferayURLGenerator() {
        return this.liferayURLGenerator;
    }

    public void setParameter(String name, String value) {
        this.parameterMap.put(name, new String[]{value});
        this.resetToString();
    }

    public void setParameter(String name, String[] values) {
        this.parameterMap.put(name, values);
        this.resetToString();
    }

    public Map<String, String[]> getParameterMap() {
        return this.parameterMap;
    }

    public void setParameters(Map<String, String[]> parameters) {
        this.parameterMap.putAll(parameters);
        this.resetToString();
    }

    public void setProperty(String key, String value) {
    }

    public void setSecure(boolean secure) throws PortletSecurityException {
    }
}

