/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.filter.liferay.internal;

import com.liferay.faces.bridge.filter.internal.BaseURLWrapper;
import com.liferay.faces.bridge.filter.liferay.LiferayBaseURL;
import com.liferay.faces.bridge.filter.liferay.LiferayURLGenerator;
import com.liferay.faces.bridge.util.internal.FacesURLEncoder;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import javax.portlet.PortletSecurityException;

public abstract class LiferayBaseURLFriendlyImpl
extends BaseURLWrapper
implements LiferayBaseURL {
    private String toStringValue;

    @Override
    public void addProperty(String key, String value) {
        super.addProperty(key, value);
        this.resetToString();
    }

    @Override
    public String toString() {
        if (this.toStringValue == null) {
            LiferayURLGenerator liferayURLGenerator = this.getLiferayURLGenerator();
            this.toStringValue = liferayURLGenerator.generateURL(this.getParameterMap());
        }
        return this.toStringValue;
    }

    @Override
    public void write(Writer writer) throws IOException {
        writer.write(this.toString());
    }

    @Override
    public void write(Writer writer, boolean escapeXML) throws IOException {
        String valueAsString = this.toString();
        if (escapeXML) {
            valueAsString = FacesURLEncoder.encode(valueAsString, "UTF-8");
        }
        writer.write(valueAsString);
    }

    protected void resetToString() {
        this.toStringValue = null;
    }

    protected abstract LiferayURLGenerator getLiferayURLGenerator();

    @Override
    public void setParameter(String name, String value) {
        super.setParameter(name, value);
        this.resetToString();
    }

    @Override
    public void setParameter(String name, String[] values) {
        super.setParameter(name, values);
        this.resetToString();
    }

    @Override
    public void setParameters(Map<String, String[]> parameters) {
        super.setParameters(parameters);
        this.resetToString();
    }

    @Override
    public void setProperty(String key, String value) {
        super.setProperty(key, value);
        this.resetToString();
    }

    @Override
    public void setSecure(boolean secure) throws PortletSecurityException {
        super.setSecure(secure);
        this.resetToString();
    }
}

