/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.filter.internal;

import com.liferay.faces.bridge.BridgeFactoryFinder;
import com.liferay.faces.bridge.context.BridgeContext;
import com.liferay.faces.bridge.filter.internal.LiferayPortletRequest;
import com.liferay.faces.bridge.filter.internal.ResourceResponseBridgeImpl;
import com.liferay.faces.bridge.filter.liferay.LiferayURLFactory;
import com.liferay.faces.bridge.filter.liferay.internal.LiferayPortalUtil;
import javax.portlet.MimeResponse;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.portlet.ResourceResponse;
import javax.portlet.ResourceURL;

public class ResourceResponseBridgeLiferayImpl
extends ResourceResponseBridgeImpl {
    private Boolean friendlyURLMapperEnabled;
    private LiferayURLFactory liferayURLFactory = (LiferayURLFactory)BridgeFactoryFinder.getFactory(LiferayURLFactory.class);
    private String responseNamespaceWSRP;

    public ResourceResponseBridgeLiferayImpl(ResourceResponse resourceResponse) {
        super(resourceResponse);
    }

    public PortletURL createActionURL() throws IllegalStateException {
        BridgeContext bridgeContext = BridgeContext.getCurrentInstance();
        return this.liferayURLFactory.getLiferayActionURL(bridgeContext, (MimeResponse)this.getResponse(), this.getNamespace());
    }

    public PortletURL createRenderURL() throws IllegalStateException {
        BridgeContext bridgeContext = BridgeContext.getCurrentInstance();
        return this.liferayURLFactory.getLiferayRenderURL(bridgeContext, (MimeResponse)this.getResponse(), this.getNamespace(), this.isFriendlyURLMapperEnabled(bridgeContext));
    }

    public ResourceURL createResourceURL() throws IllegalStateException {
        BridgeContext bridgeContext = BridgeContext.getCurrentInstance();
        return this.liferayURLFactory.getLiferayResourceURL(bridgeContext, (MimeResponse)this.getResponse(), this.getNamespace());
    }

    protected boolean isFriendlyURLMapperEnabled(BridgeContext bridgeContext) {
        if (this.friendlyURLMapperEnabled == null) {
            PortletRequest portletRequest = bridgeContext.getPortletRequest();
            LiferayPortletRequest liferayPortletRequest = new LiferayPortletRequest(portletRequest);
            this.friendlyURLMapperEnabled = liferayPortletRequest.getPortlet().getFriendlyURLMapperInstance() != null;
        }
        return this.friendlyURLMapperEnabled;
    }

    @Override
    protected String getNamespaceWSRP(BridgeContext bridgeContext) {
        if (this.responseNamespaceWSRP == null) {
            PortletRequest portletRequest = bridgeContext.getPortletRequest();
            this.responseNamespaceWSRP = LiferayPortalUtil.getPortletId(portletRequest);
        }
        return this.responseNamespaceWSRP;
    }
}

