/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.filter.internal;

import com.liferay.faces.bridge.filter.internal.PortletRequestDispatcherWrapper;
import com.liferay.faces.util.product.Product;
import com.liferay.faces.util.product.ProductMap;
import java.io.IOException;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.PortletResponse;
import javax.portlet.filter.PortletRequestWrapper;

public class PortletRequestDispatcherBridgeLiferayImpl
extends PortletRequestDispatcherWrapper {
    private static final Product LIFERAY_PORTAL = (Product)ProductMap.getInstance().get((Object)"Liferay Portal");
    private static final int LIFERAY_PORTAL_MAJOR_VERSION = LIFERAY_PORTAL.getMajorVersion();
    private static final int LIFERAY_PORTAL_MINOR_VERSION = LIFERAY_PORTAL.getMinorVersion();
    private static final int LIFERAY_PORTAL_REVISION_VERSION = LIFERAY_PORTAL.getRevisionVersion();
    private PortletRequestDispatcher wrappedPortletRequestDispatcher;

    public PortletRequestDispatcherBridgeLiferayImpl(PortletRequestDispatcher portletRequestDispatcher) {
        this.wrappedPortletRequestDispatcher = portletRequestDispatcher;
    }

    @Override
    public void forward(PortletRequest portletRequest, PortletResponse portletResponse) throws PortletException, IOException {
        this.include(portletRequest, portletResponse);
    }

    @Override
    public void include(PortletRequest portletRequest, PortletResponse portletResponse) throws PortletException, IOException {
        boolean unwrapRequest = false;
        if (LIFERAY_PORTAL_MAJOR_VERSION < 6) {
            unwrapRequest = true;
        } else if (LIFERAY_PORTAL_MAJOR_VERSION == 6) {
            if (LIFERAY_PORTAL_MINOR_VERSION == 0) {
                unwrapRequest = true;
            } else if (LIFERAY_PORTAL_MINOR_VERSION == 1) {
                if (LIFERAY_PORTAL_REVISION_VERSION < 10) {
                    unwrapRequest = LIFERAY_PORTAL_REVISION_VERSION < 2;
                } else if (LIFERAY_PORTAL_REVISION_VERSION < 30) {
                    unwrapRequest = true;
                }
            }
        }
        if (unwrapRequest) {
            super.include(this.getLiferayPortletRequest(portletRequest), portletResponse);
        } else {
            super.include(portletRequest, portletResponse);
        }
    }

    protected PortletRequest getLiferayPortletRequest(PortletRequest portletRequest) {
        if (portletRequest instanceof PortletRequestWrapper) {
            PortletRequestWrapper portletRequestWrapper = (PortletRequestWrapper)portletRequest;
            PortletRequest wrappedPortletRequest = portletRequestWrapper.getRequest();
            portletRequest = this.getLiferayPortletRequest(wrappedPortletRequest);
        }
        return portletRequest;
    }

    @Override
    public PortletRequestDispatcher getWrapped() {
        return this.wrappedPortletRequestDispatcher;
    }
}

