/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.filter.internal;

import com.liferay.faces.bridge.filter.internal.LiferayHttpServletRequest;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import com.liferay.portal.model.Portlet;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.portlet.PortletRequest;
import javax.portlet.filter.PortletRequestWrapper;
import javax.servlet.http.HttpServletRequest;

public class LiferayPortletRequest {
    private static final String METHOD_NAME_GET_ORIGINAL_HTTP_SERVLET_REQUEST = "getOriginalHttpServletRequest";
    private static final String METHOD_NAME_GET_PORTLET = "getPortlet";
    private static final Logger logger = LoggerFactory.getLogger(LiferayPortletRequest.class);
    private LiferayHttpServletRequest liferayHttpServletRequest;
    private Portlet portlet;
    private List<String> propertyNameList;
    private PortletRequest wrappedPortletRequest;

    public LiferayPortletRequest(PortletRequest portletRequest) {
        String headerName;
        Enumeration headerNames;
        Method method;
        if (portletRequest != null) {
            while (portletRequest instanceof PortletRequestWrapper) {
                PortletRequestWrapper portletRequestWrapper = (PortletRequestWrapper)portletRequest;
                portletRequest = portletRequestWrapper.getRequest();
            }
        }
        this.wrappedPortletRequest = portletRequest;
        try {
            method = this.wrappedPortletRequest.getClass().getMethod(METHOD_NAME_GET_PORTLET, null);
            this.portlet = (Portlet)method.invoke((Object)this.wrappedPortletRequest, (Object[])null);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), new Object[]{e});
        }
        try {
            method = this.wrappedPortletRequest.getClass().getMethod(METHOD_NAME_GET_ORIGINAL_HTTP_SERVLET_REQUEST, null);
            this.liferayHttpServletRequest = new LiferayHttpServletRequest((HttpServletRequest)method.invoke((Object)this.wrappedPortletRequest, (Object[])null));
        }
        catch (Exception e) {
            logger.error(e.getMessage(), new Object[]{e});
        }
        this.propertyNameList = new ArrayList<String>();
        boolean foundIfModifiedSince = false;
        boolean foundUserAgent = false;
        Enumeration propertyNames = portletRequest.getPropertyNames();
        while (propertyNames.hasMoreElements() && !foundUserAgent) {
            String propertyName = (String)propertyNames.nextElement();
            this.propertyNameList.add(propertyName);
            if ("If-Modified-Since".equals(propertyName)) {
                foundIfModifiedSince = true;
                continue;
            }
            if (!"User-Agent".equals(propertyName)) continue;
            foundUserAgent = true;
        }
        if (!foundIfModifiedSince) {
            headerNames = this.liferayHttpServletRequest.getHeaderNames();
            while (headerNames.hasMoreElements() && !foundIfModifiedSince) {
                headerName = (String)headerNames.nextElement();
                foundIfModifiedSince = "If-Modified-Since".equalsIgnoreCase(headerName);
            }
            if (foundIfModifiedSince) {
                this.propertyNameList.add("If-Modified-Since");
            }
        }
        if (!foundUserAgent) {
            headerNames = this.liferayHttpServletRequest.getHeaderNames();
            while (headerNames.hasMoreElements() && !foundUserAgent) {
                headerName = (String)headerNames.nextElement();
                foundUserAgent = "User-Agent".equalsIgnoreCase(headerName);
            }
            if (foundUserAgent) {
                this.propertyNameList.add("User-Agent");
            }
        }
    }

    public Portlet getPortlet() {
        return this.portlet;
    }

    public Enumeration<String> getProperties(String name) {
        Enumeration properties = this.wrappedPortletRequest.getProperties(name);
        if (!properties.hasMoreElements() && ("User-Agent".equals(name) || "If-Modified-Since".equals(name))) {
            properties = this.liferayHttpServletRequest.getHeaders(name);
        }
        return properties;
    }

    public String getProperty(String name) {
        String property = this.wrappedPortletRequest.getProperty(name);
        if (property == null) {
            property = this.liferayHttpServletRequest.getHeader(name);
        }
        return property;
    }

    public Enumeration<String> getPropertyNames() {
        return Collections.enumeration(this.propertyNameList);
    }
}

