/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.filter.internal;

import com.liferay.faces.bridge.context.BridgeContext;
import com.liferay.faces.bridge.filter.internal.ActionResponseBridgeCompatImpl;
import com.liferay.faces.bridge.scope.BridgeRequestScope;
import java.io.IOException;
import javax.faces.context.FacesContext;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;

public class ActionResponseBridgeImpl
extends ActionResponseBridgeCompatImpl {
    private String namespace;
    private String namespaceWSRP;

    public ActionResponseBridgeImpl(ActionResponse actionResponse) {
        super(actionResponse);
    }

    public void sendRedirect(String location) throws IOException {
        this.prepareForRedirect();
        super.sendRedirect(location);
    }

    public void sendRedirect(String location, String renderUrlParamName) throws IOException {
        this.prepareForRedirect();
        super.sendRedirect(location, renderUrlParamName);
    }

    protected void prepareForRedirect() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        this.partialViewContextRenderAll(facesContext);
        facesContext.responseComplete();
        BridgeContext bridgeContext = BridgeContext.getCurrentInstance();
        BridgeRequestScope bridgeRequestScope = bridgeContext.getBridgeRequestScope();
        bridgeRequestScope.setRedirectOccurred(true);
    }

    public String getNamespace() {
        if (this.namespace == null) {
            this.namespace = super.getNamespace();
            if (this.namespace.startsWith("wsrp_rewrite")) {
                BridgeContext bridgeContext = BridgeContext.getCurrentInstance();
                this.namespace = this.getNamespaceWSRP(bridgeContext);
            }
        }
        return this.namespace;
    }

    protected String getNamespaceWSRP(BridgeContext bridgeContext) {
        if (this.namespaceWSRP == null) {
            PortletConfig portletConfig = bridgeContext.getPortletConfig();
            String portletName = portletConfig.getPortletName();
            PortletContext portletContext = bridgeContext.getPortletContext();
            String portletContextName = portletContext.getPortletContextName();
            this.namespaceWSRP = portletName + portletContextName;
        }
        return this.namespaceWSRP;
    }
}

