/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.context.url.internal;

import com.liferay.faces.bridge.config.BridgeConfig;
import com.liferay.faces.bridge.context.BridgeContext;
import com.liferay.faces.bridge.context.url.BridgeURI;
import com.liferay.faces.bridge.context.url.BridgeURL;
import com.liferay.faces.bridge.helper.internal.WindowStateHelper;
import com.liferay.faces.bridge.util.internal.RequestParameter;
import com.liferay.faces.util.helper.BooleanHelper;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.portlet.BaseURL;
import javax.portlet.MimeResponse;
import javax.portlet.PortletMode;
import javax.portlet.PortletModeException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletSecurityException;
import javax.portlet.PortletURL;
import javax.portlet.ResourceURL;
import javax.portlet.WindowState;
import javax.portlet.WindowStateException;
import javax.portlet.faces.Bridge;

public abstract class BridgeURLBase
implements BridgeURL {
    private static final Logger logger = LoggerFactory.getLogger(BridgeURLBase.class);
    protected static final String RELATIVE_PATH_PREFIX = "../";
    private Boolean facesViewTarget;
    private boolean selfReferencing;
    private Map<String, String[]> parameterMap;
    private boolean secure;
    String viewIdRenderParameterName;
    String viewIdResourceParameterName;
    protected BridgeURI bridgeURI;
    protected String viewId;
    protected BridgeContext bridgeContext;

    public BridgeURLBase(BridgeContext bridgeContext, BridgeURI bridgeURI, String viewId) {
        this.bridgeContext = bridgeContext;
        this.bridgeURI = bridgeURI;
        this.viewId = viewId;
        BridgeConfig bridgeConfig = bridgeContext.getBridgeConfig();
        this.viewIdRenderParameterName = bridgeConfig.getViewIdRenderParameterName();
        this.viewIdResourceParameterName = bridgeConfig.getViewIdResourceParameterName();
    }

    public String toString() {
        String stringValue;
        block5: {
            stringValue = null;
            try {
                BaseURL baseURL = this.toBaseURL();
                if (this.bridgeURI.isEscaped()) {
                    StringWriter urlWriter = new StringWriter();
                    try {
                        baseURL.write((Writer)urlWriter, true);
                    }
                    catch (IOException e) {
                        logger.error((Throwable)e);
                        stringValue = baseURL.toString();
                    }
                    stringValue = urlWriter.toString();
                    break block5;
                }
                stringValue = baseURL.toString();
            }
            catch (MalformedURLException e) {
                logger.error((Throwable)e);
            }
        }
        return stringValue;
    }

    protected abstract BaseURL toBaseURL() throws MalformedURLException;

    protected String _toString(boolean modeChanged) {
        return this._toString(modeChanged, null);
    }

    protected String _toString(boolean modeChanged, Set<String> excludedParameterNames) {
        StringBuilder buf = new StringBuilder();
        String uri = this.bridgeURI.toString();
        int endPos = uri.indexOf("?");
        if (endPos < 0) {
            endPos = uri.length();
        }
        if (this.bridgeURI.isPortletScheme()) {
            Bridge.PortletPhase urlPortletPhase = this.bridgeURI.getPortletPhase();
            if (urlPortletPhase == Bridge.PortletPhase.ACTION_PHASE) {
                buf.append(uri.substring("portlet:action".length(), endPos));
            } else if (urlPortletPhase == Bridge.PortletPhase.RENDER_PHASE) {
                buf.append(uri.substring("portlet:render".length(), endPos));
            } else {
                buf.append(uri.substring("portlet:resource".length(), endPos));
            }
        } else {
            buf.append(uri.subSequence(0, endPos));
        }
        boolean firstParam = true;
        buf.append("?");
        Set<String> parameterNames = this.getParameterMap().keySet();
        boolean foundFacesViewIdParam = false;
        boolean foundFacesViewPathParam = false;
        for (String parameterName : parameterNames) {
            boolean addParameter = false;
            String parameterValue = this.getParameter(parameterName);
            if ("javax.portlet.faces.PortletMode".equals(parameterName)) {
                if (parameterValue != null) {
                    addParameter = this.bridgeContext.getPortletRequest().isPortletModeAllowed(new PortletMode(parameterValue));
                }
            } else if ("javax.portlet.faces.Secure".equals(parameterName)) {
                addParameter = BooleanHelper.isBooleanToken((String)parameterValue);
            } else if ("javax.portlet.faces.WindowState".equals(parameterName)) {
                addParameter = WindowStateHelper.isValid(parameterValue);
            } else {
                if (!foundFacesViewIdParam) {
                    foundFacesViewIdParam = "_jsfBridgeViewId".equals(parameterName);
                }
                if (!foundFacesViewPathParam) {
                    foundFacesViewPathParam = "_jsfBridgeViewPath".equals(parameterName);
                }
                addParameter = true;
            }
            if (!addParameter || excludedParameterNames != null && excludedParameterNames.contains(parameterName)) continue;
            if (firstParam) {
                firstParam = false;
            } else {
                buf.append("&");
            }
            buf.append(parameterName);
            buf.append("=");
            buf.append(parameterValue);
        }
        if (!(foundFacesViewIdParam || foundFacesViewPathParam || !this.isFacesViewTarget() || this.bridgeURI.isPortletScheme() || modeChanged)) {
            if (!firstParam) {
                buf.append("&");
            }
            buf.append(this.getViewIdParameterName());
            buf.append("=");
            String contextPath = this.bridgeContext.getPortletRequest().getContextPath();
            String contextRelativePath = this.bridgeURI.getContextRelativePath(contextPath);
            buf.append(contextRelativePath);
        }
        return buf.toString();
    }

    protected void copyParameters(String fromURL, BaseURL toURL) throws MalformedURLException {
        List<RequestParameter> requestParameters = this.parseRequestParameters(fromURL);
        if (requestParameters != null) {
            for (RequestParameter requestParameter : requestParameters) {
                String name = (String)requestParameter.getName();
                String value = (String)requestParameter.getValue();
                toURL.setParameter(name, value);
                logger.debug("Copied parameter to portletURL name=[{0}] value=[{1}]", new Object[]{name, value});
            }
        }
    }

    protected PortletURL createActionURL(String fromURL) throws MalformedURLException {
        try {
            logger.debug("createActionURL fromURL=[" + fromURL + "]");
            BridgeContext bridgeContext = BridgeContext.getCurrentInstance();
            MimeResponse mimeResponse = (MimeResponse)bridgeContext.getPortletResponse();
            PortletURL actionURL = mimeResponse.createActionURL();
            this.copyParameters(fromURL, (BaseURL)actionURL);
            return actionURL;
        }
        catch (ClassCastException e) {
            throw new MalformedURLException(e.getMessage());
        }
    }

    protected ResourceURL createPartialActionURL(String fromURL) throws MalformedURLException {
        logger.debug("createPartialActionURL fromURL=[" + fromURL + "]");
        return this.createResourceURL(fromURL);
    }

    protected PortletURL createRenderURL(String fromURL) throws MalformedURLException {
        BridgeContext bridgeContext = BridgeContext.getCurrentInstance();
        Bridge.PortletPhase portletRequestPhase = bridgeContext.getPortletRequestPhase();
        if (portletRequestPhase == Bridge.PortletPhase.RENDER_PHASE || portletRequestPhase == Bridge.PortletPhase.RESOURCE_PHASE) {
            try {
                logger.debug("createRenderURL fromURL=[" + fromURL + "]");
                MimeResponse mimeResponse = (MimeResponse)bridgeContext.getPortletResponse();
                PortletURL renderURL = mimeResponse.createRenderURL();
                this.copyParameters(fromURL, (BaseURL)renderURL);
                return renderURL;
            }
            catch (ClassCastException e) {
                throw new MalformedURLException(e.getMessage());
            }
        }
        throw new MalformedURLException("Unable to create a RenderURL during " + portletRequestPhase.toString());
    }

    protected ResourceURL createResourceURL(String fromURL) throws MalformedURLException {
        try {
            logger.debug("createResourceURL fromURL=[" + fromURL + "]");
            BridgeContext bridgeContext = BridgeContext.getCurrentInstance();
            MimeResponse mimeResponse = (MimeResponse)bridgeContext.getPortletResponse();
            ResourceURL resourceURL = mimeResponse.createResourceURL();
            int tokenPos = fromURL.indexOf("javax.faces.resource");
            if (tokenPos >= 0) {
                int slashPos;
                String resourceId = fromURL.substring(tokenPos);
                int queryStringPos = resourceId.indexOf(63);
                String resourceName = resourceId;
                if (queryStringPos > 0) {
                    resourceName = resourceName.substring(0, queryStringPos);
                }
                if ((slashPos = resourceName.indexOf(47)) > 0) {
                    resourceName = resourceName.substring(slashPos + 1);
                } else {
                    logger.error("There is no slash after the [{0}] token in resourceURL=[{1}]", new Object[]{"javax.faces.resource", fromURL});
                }
                resourceURL.setParameter("javax.faces.resource", resourceName);
                logger.debug("Added parameter to portletURL name=[{0}] value=[{1}]", new Object[]{"javax.faces.resource", resourceName});
            }
            this.copyParameters(fromURL, (BaseURL)resourceURL);
            return resourceURL;
        }
        catch (ClassCastException e) {
            throw new MalformedURLException(e.getMessage());
        }
    }

    protected boolean matchPathAndExtension(String file1, String file2) {
        boolean match = false;
        String path1 = null;
        int lastSlashPos = file1.lastIndexOf("/");
        if (lastSlashPos > 0) {
            path1 = file1.substring(0, lastSlashPos);
        }
        String path2 = null;
        lastSlashPos = file2.lastIndexOf("/");
        if (lastSlashPos > 0) {
            path2 = file2.substring(0, lastSlashPos);
        }
        if (path1 == null && path2 == null || path1 != null && path2 != null && path1.equals(path2)) {
            String ext1 = null;
            int lastDotPos = file1.indexOf(".");
            if (lastDotPos > 0) {
                ext1 = file1.substring(lastDotPos);
            }
            String ext2 = null;
            lastDotPos = file2.indexOf(".");
            if (lastDotPos > 0) {
                ext2 = file2.substring(lastDotPos);
            }
            if (ext1 == null && ext2 == null || ext1 != null && ext2 != null && ext1.equals(ext2)) {
                match = true;
            }
        }
        return match;
    }

    protected List<RequestParameter> parseRequestParameters(String url) throws MalformedURLException {
        String queryString;
        int pos;
        ArrayList<RequestParameter> requestParameters = null;
        if (url != null && (pos = url.indexOf("?")) >= 0 && (queryString = url.substring(pos + 1)).length() > 0) {
            String[] queryParameters;
            requestParameters = new ArrayList<RequestParameter>();
            for (String queryParameter : queryParameters = queryString.split("[&]")) {
                String name;
                String[] nameValueArray = queryParameter.split("[=]");
                if (nameValueArray.length == 1) {
                    name = nameValueArray[0].trim();
                    if (name.length() == 0) {
                        throw new MalformedURLException("Invalid name/value pair=[" + queryParameter + "]: name cannot be empty.");
                    }
                    requestParameters.add(new RequestParameter(name, ""));
                    continue;
                }
                if (nameValueArray.length == 2) {
                    name = nameValueArray[0].trim();
                    if (name.length() == 0) {
                        throw new MalformedURLException("Invalid name/value pair=[" + queryParameter + "]: name cannot be empty.");
                    }
                    String value = nameValueArray[1];
                    requestParameters.add(new RequestParameter(name, value));
                    continue;
                }
                throw new MalformedURLException("Invalid name/value pair: " + queryParameter);
            }
        }
        return requestParameters;
    }

    protected String removeParameter(String name) {
        String[] values = this.getParameterMap().remove(name);
        String value = null;
        if (values != null && values.length > 0) {
            value = values[0];
        }
        return value;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public boolean isSelfReferencing() {
        return this.selfReferencing;
    }

    public String getParameter(String name) {
        String value = null;
        Map<String, String[]> parameterMap = this.getParameterMap();
        String[] values = parameterMap.get(name);
        if (values == null) {
            PortletResponse portletResponse = this.bridgeContext.getPortletResponse();
            String responseNamespace = portletResponse.getNamespace();
            values = parameterMap.get(responseNamespace + name);
        }
        if (values != null && values.length > 0) {
            value = values[0];
        }
        return value;
    }

    public void setParameter(String name, String[] value) {
        this.getParameterMap().put(name, value);
    }

    public void setParameter(String name, String value) {
        this.getParameterMap().put(name, new String[]{value});
    }

    public Map<String, String[]> getParameterMap() {
        if (this.parameterMap == null) {
            this.parameterMap = new LinkedHashMap<String, String[]>(this.bridgeURI.getParameterMap());
        }
        return this.parameterMap;
    }

    protected void setPortletModeParameter(String portletMode, PortletURL portletURL) {
        if (portletMode != null) {
            try {
                PortletMode candidatePortletMode = new PortletMode(portletMode);
                if (this.bridgeContext.getPortletRequest().isPortletModeAllowed(candidatePortletMode)) {
                    portletURL.setPortletMode(candidatePortletMode);
                }
            }
            catch (PortletModeException e) {
                logger.error((Throwable)e);
            }
        }
    }

    protected void setRenderParameters(BaseURL baseURL) {
        Map privateParameterMap;
        Map<String, String[]> urlParameterMap = this.getParameterMap();
        Map preservedActionParams = this.bridgeContext.getPreservedActionParams();
        PortletRequest portletRequest = this.bridgeContext.getPortletRequest();
        Map publicParameterMap = portletRequest.getPublicParameterMap();
        if (publicParameterMap != null) {
            Set publicParamterMapEntrySet = publicParameterMap.entrySet();
            for (Map.Entry mapEntry : publicParamterMapEntrySet) {
                String publicParameterName = (String)mapEntry.getKey();
                if ("javax.faces.ViewState".equals(publicParameterName) || preservedActionParams.containsKey(publicParameterName) || urlParameterMap.containsKey(publicParameterName)) continue;
                baseURL.setParameter(publicParameterName, (String[])mapEntry.getValue());
            }
        }
        if ((privateParameterMap = portletRequest.getPrivateParameterMap()) != null) {
            Set privateParameterMapEntrySet = privateParameterMap.entrySet();
            for (Map.Entry mapEntry : privateParameterMapEntrySet) {
                String privateParameterName = (String)mapEntry.getKey();
                if ("javax.faces.ViewState".equals(privateParameterName) || preservedActionParams.containsKey(privateParameterName) || urlParameterMap.containsKey(privateParameterName)) continue;
                baseURL.setParameter(privateParameterName, (String[])mapEntry.getValue());
            }
        }
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    protected void setSecureParameter(String secure, BaseURL baseURL) {
        if (secure != null) {
            try {
                baseURL.setSecure(BooleanHelper.toBoolean((String)secure));
            }
            catch (PortletSecurityException e) {
                logger.error((Throwable)e);
            }
        }
    }

    public void setSelfReferencing(boolean selfReferencing) {
        this.selfReferencing = selfReferencing;
    }

    public boolean isFacesViewTarget() {
        if (this.facesViewTarget == null) {
            String contextRelativePath;
            String contextPath = this.bridgeContext.getPortletRequest().getContextPath();
            String potentialFacesViewId = contextRelativePath = this.bridgeURI.getContextRelativePath(contextPath);
            if (this.viewId != null && this.viewId.equals(potentialFacesViewId)) {
                this.facesViewTarget = Boolean.TRUE;
            } else if ((potentialFacesViewId = this.bridgeContext.getFacesViewIdFromPath(potentialFacesViewId, false)) != null) {
                this.facesViewTarget = Boolean.TRUE;
            } else {
                potentialFacesViewId = contextRelativePath == null ? this.viewId : contextRelativePath;
                if (this.viewId != null && this.matchPathAndExtension(this.viewId, potentialFacesViewId)) {
                    logger.debug("Regarding path=[{0}] as a Faces view since it has the same path and extension as the current viewId=[{1}]", new Object[]{potentialFacesViewId, this.viewId});
                    this.facesViewTarget = Boolean.TRUE;
                } else {
                    this.facesViewTarget = Boolean.FALSE;
                }
            }
        }
        return this.facesViewTarget;
    }

    protected String getViewIdParameterName() {
        if (this.bridgeURI.isPortletScheme() && this.bridgeURI.getPortletPhase() == Bridge.PortletPhase.RESOURCE_PHASE) {
            return this.viewIdResourceParameterName;
        }
        return this.viewIdRenderParameterName;
    }

    protected void setWindowStateParameter(String windowState, PortletURL portletURL) {
        if (windowState != null) {
            try {
                WindowState candidateWindowState = new WindowState(windowState);
                if (this.bridgeContext.getPortletRequest().isWindowStateAllowed(candidateWindowState)) {
                    portletURL.setWindowState(candidateWindowState);
                }
            }
            catch (WindowStateException e) {
                logger.error((Throwable)e);
            }
        }
    }
}

