/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.context.url.internal;

import com.liferay.faces.bridge.context.url.BridgeURI;
import com.liferay.faces.bridge.util.internal.URLUtil;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.Map;
import javax.portlet.faces.Bridge;

public class BridgeURIImpl
implements BridgeURI {
    private static final Logger logger = LoggerFactory.getLogger(BridgeURIImpl.class);
    private static final String RELATIVE_PATH_PREFIX = "../";
    private Boolean escaped;
    private Boolean external;
    private Boolean hierarchical;
    private Map<String, String[]> parameters;
    private Boolean pathRelative;
    private Bridge.PortletPhase portletPhase;
    private Boolean portletScheme;
    private String query;
    private String stringValue;
    private URI uri;

    public BridgeURIImpl(String uri) throws URISyntaxException {
        int queryPos;
        this.stringValue = uri;
        this.uri = new URI(uri);
        this.portletScheme = "portlet".equals(this.uri.getScheme());
        if (this.portletScheme.booleanValue() && (queryPos = uri.indexOf(63)) > 0) {
            this.query = uri.substring(queryPos + 1);
        }
    }

    public String toString() {
        return this.stringValue;
    }

    public String getContextRelativePath(String contextPath) {
        String path;
        String contextRelativePath = null;
        if (!this.isExternal() && (path = this.uri.getPath()) != null && path.length() > 0) {
            int contextPathPos = path.indexOf(contextPath);
            contextRelativePath = contextPathPos >= 0 ? path.substring(contextPathPos + contextPath.length()) : path;
        }
        return contextRelativePath;
    }

    public boolean isEscaped() {
        if (this.escaped == null) {
            this.escaped = Boolean.FALSE;
            String query = this.getQuery();
            if (query != null) {
                int ampersandPos = query.indexOf("&");
                while (ampersandPos > 0) {
                    String queryPart = query.substring(ampersandPos);
                    if (queryPart.startsWith("&amp;")) {
                        this.escaped = Boolean.TRUE;
                        ampersandPos = query.indexOf("&", ampersandPos + 1);
                        continue;
                    }
                    this.escaped = Boolean.FALSE;
                    break;
                }
            }
        }
        return this.escaped;
    }

    public boolean isAbsolute() {
        return this.uri.isAbsolute();
    }

    public boolean isOpaque() {
        return this.portletScheme != false || this.uri.isOpaque();
    }

    public boolean isPathRelative() {
        if (this.pathRelative == null) {
            this.pathRelative = Boolean.FALSE;
            String path = this.getPath();
            if (path != null && path.length() > 0 && (!path.startsWith("/") || path.startsWith(RELATIVE_PATH_PREFIX))) {
                this.pathRelative = Boolean.TRUE;
            }
        }
        return this.pathRelative;
    }

    public boolean isPortletScheme() {
        return this.portletScheme;
    }

    public boolean isRelative() {
        return !this.isAbsolute();
    }

    public boolean isExternal() {
        if (this.external == null) {
            this.external = Boolean.FALSE;
            if (!this.portletScheme.booleanValue()) {
                if (this.isAbsolute()) {
                    this.external = Boolean.TRUE;
                } else if (!this.stringValue.startsWith("/") && !this.stringValue.startsWith(RELATIVE_PATH_PREFIX)) {
                    this.external = Boolean.TRUE;
                }
            }
            if (this.stringValue.startsWith("wsrp_rewrite")) {
                this.external = Boolean.FALSE;
            }
        }
        return this.external;
    }

    public boolean isHierarchical() {
        if (this.hierarchical == null) {
            this.hierarchical = Boolean.FALSE;
            if (this.isAbsolute() && this.uri.getSchemeSpecificPart().startsWith("/") || this.isRelative()) {
                this.hierarchical = Boolean.TRUE;
            }
        }
        return this.hierarchical;
    }

    public Map<String, String[]> getParameterMap() {
        if (this.parameters == null) {
            this.parameters = Collections.unmodifiableMap(URLUtil.parseParameterMapValuesArray(this.uri.toString()));
        }
        return this.parameters;
    }

    public String getPath() {
        return this.uri.getPath();
    }

    public Bridge.PortletPhase getPortletPhase() {
        if (this.portletPhase == null) {
            String uriAsString = this.uri.toString();
            if (uriAsString != null) {
                if (this.portletScheme.booleanValue()) {
                    if (uriAsString.startsWith("portlet:action")) {
                        this.portletPhase = Bridge.PortletPhase.ACTION_PHASE;
                    } else if (uriAsString.startsWith("portlet:render")) {
                        this.portletPhase = Bridge.PortletPhase.RENDER_PHASE;
                    } else if (uriAsString.startsWith("portlet:resource")) {
                        this.portletPhase = Bridge.PortletPhase.RESOURCE_PHASE;
                    } else {
                        this.portletPhase = Bridge.PortletPhase.RESOURCE_PHASE;
                        logger.warn("Invalid keyword after 'portlet:' in URI=[{0}]", new Object[]{uriAsString});
                    }
                }
            } else {
                this.portletPhase = Bridge.PortletPhase.RESOURCE_PHASE;
                logger.warn("Unable to determine portlet phase in null URI");
            }
        }
        return this.portletPhase;
    }

    public String getQuery() {
        if (this.query == null) {
            return this.uri.getQuery();
        }
        return this.query;
    }
}

