/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.context.url.internal;

import com.liferay.faces.bridge.context.BridgeContext;
import com.liferay.faces.bridge.context.url.BridgeResourceURL;
import com.liferay.faces.bridge.context.url.BridgeURI;
import com.liferay.faces.bridge.context.url.internal.BaseURLEncodedExternalStringImpl;
import com.liferay.faces.bridge.context.url.internal.BaseURLNonEncodedStringImpl;
import com.liferay.faces.bridge.context.url.internal.BaseURLRelativeStringImpl;
import com.liferay.faces.bridge.context.url.internal.BridgeResourceURLCompatImpl;
import com.liferay.faces.bridge.context.url.internal.PortletURLFacesTargetActionImpl;
import com.liferay.faces.bridge.context.url.internal.PortletURLNonFacesTargetRenderImpl;
import com.liferay.faces.util.helper.BooleanHelper;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URLEncoder;
import java.util.HashSet;
import java.util.Set;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.portlet.BaseURL;
import javax.portlet.PortletURL;
import javax.portlet.ResourceURL;
import javax.portlet.faces.Bridge;

public class BridgeResourceURLImpl
extends BridgeResourceURLCompatImpl
implements BridgeResourceURL {
    private static final Logger logger = LoggerFactory.getLogger(BridgeResourceURLImpl.class);
    private static final String ENCODED_RESOURCE_TOKEN = "javax.faces.resource=";
    private static Set<String> EXCLUDED_PARAMETER_NAMES = new HashSet<String>();
    private boolean inProtocol;
    private boolean viewLink;

    public BridgeResourceURLImpl(BridgeContext bridgeContext, BridgeURI bridgeURI, String viewId) {
        super(bridgeContext, bridgeURI, viewId);
    }

    public void replaceBackLinkParameter(FacesContext facesContext) {
        String backLinkViewId = facesContext.getViewRoot().getViewId();
        String backLinkURL = facesContext.getApplication().getViewHandler().getActionURL(facesContext, backLinkViewId);
        String backLinkEncodedActionURL = "";
        try {
            ExternalContext externalContext = facesContext.getExternalContext();
            backLinkEncodedActionURL = URLEncoder.encode(externalContext.encodeActionURL(backLinkURL), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            logger.error(e.getMessage());
        }
        String newParamName = this.removeParameter("javax.portlet.faces.BackLink");
        this.setParameter(newParamName, backLinkEncodedActionURL);
    }

    @Override
    protected BaseURL toBaseURL() throws MalformedURLException {
        Object baseURL;
        String uri = this.bridgeURI.toString();
        if (this.bridgeURI.isOpaque()) {
            if (this.bridgeURI.isPortletScheme()) {
                String portletMode = this.getParameter("javax.portlet.faces.PortletMode");
                boolean modeChanged = portletMode != null && portletMode.length() > 0;
                String security = this.getParameter("javax.portlet.faces.Secure");
                String windowState = this.getParameter("javax.portlet.faces.WindowState");
                String urlWithModifiedParameters = this._toString(modeChanged);
                Bridge.PortletPhase urlPortletPhase = this.bridgeURI.getPortletPhase();
                baseURL = urlPortletPhase == Bridge.PortletPhase.ACTION_PHASE ? this.createActionURL(urlWithModifiedParameters) : (urlPortletPhase == Bridge.PortletPhase.RENDER_PHASE ? this.createRenderURL(urlWithModifiedParameters) : this.createResourceURL(urlWithModifiedParameters));
                if (this.isSelfReferencing()) {
                    this.setRenderParameters((BaseURL)baseURL);
                }
                if (baseURL instanceof PortletURL) {
                    PortletURL portletURL = (PortletURL)baseURL;
                    this.setPortletModeParameter(portletMode, portletURL);
                    this.setWindowStateParameter(windowState, portletURL);
                }
                this.setSecureParameter(security, (BaseURL)baseURL);
            } else {
                baseURL = new BaseURLNonEncodedStringImpl(uri, this.getParameterMap());
            }
        } else if (uri != null && uri.contains("javax.faces.resource")) {
            baseURL = uri.indexOf(ENCODED_RESOURCE_TOKEN) > 0 ? new BaseURLNonEncodedStringImpl(uri, this.getParameterMap()) : this.createResourceURL(uri);
        } else if (this.bridgeURI.isExternal()) {
            baseURL = new BaseURLEncodedExternalStringImpl(uri, this.getParameterMap(), this.bridgeContext.getPortletResponse());
        } else if (this.bridgeURI.isPathRelative()) {
            baseURL = new BaseURLRelativeStringImpl(uri, this.getParameterMap(), this.bridgeContext);
        } else if (this.viewLink) {
            String urlWithModifiedParameters = this._toString(false, EXCLUDED_PARAMETER_NAMES);
            String portletMode = this.getParameter("javax.portlet.faces.PortletMode");
            String windowState = this.getParameter("javax.portlet.faces.WindowState");
            boolean secure = BooleanHelper.toBoolean((String)this.getParameter("javax.portlet.faces.Secure"));
            if (this.isFacesViewTarget()) {
                PortletURL actionURL = this.createActionURL(urlWithModifiedParameters);
                baseURL = new PortletURLFacesTargetActionImpl(actionURL, portletMode, windowState, secure);
            } else {
                PortletURL renderURL = this.createRenderURL(urlWithModifiedParameters);
                baseURL = new PortletURLNonFacesTargetRenderImpl(renderURL, portletMode, windowState, secure, this.bridgeURI.getPath());
            }
        } else if (this.isFacesViewTarget()) {
            String urlWithModifiedParameters = this._toString(false, EXCLUDED_PARAMETER_NAMES);
            baseURL = this.createResourceURL(urlWithModifiedParameters);
        } else if (this.inProtocol) {
            String urlWithModifiedParameters = this._toString(false);
            ResourceURL resourceURL = this.createResourceURL(urlWithModifiedParameters);
            String contextPath = this.bridgeContext.getPortletRequest().getContextPath();
            resourceURL.setResourceID(this.bridgeURI.getContextRelativePath(contextPath));
            baseURL = resourceURL;
        } else {
            baseURL = new BaseURLEncodedExternalStringImpl(uri, this.getParameterMap(), this.bridgeContext.getPortletResponse());
        }
        return baseURL;
    }

    public void setInProtocol(boolean inProtocol) {
        this.inProtocol = inProtocol;
    }

    public void setViewLink(boolean viewLink) {
        this.viewLink = viewLink;
    }

    static {
        EXCLUDED_PARAMETER_NAMES.add("javax.portlet.faces.PortletMode");
        EXCLUDED_PARAMETER_NAMES.add("javax.portlet.faces.Secure");
        EXCLUDED_PARAMETER_NAMES.add("javax.portlet.faces.WindowState");
    }
}

