/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.context.url.internal;

import com.liferay.faces.bridge.config.BridgeConfig;
import com.liferay.faces.bridge.context.BridgeContext;
import com.liferay.faces.bridge.context.url.BridgeURI;
import com.liferay.faces.bridge.context.url.internal.BaseURLNonEncodedStringImpl;
import com.liferay.faces.bridge.context.url.internal.BridgeURLBase;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import java.net.MalformedURLException;
import javax.portlet.BaseURL;

public class BridgePartialActionURLImpl
extends BridgeURLBase {
    private static final Logger logger = LoggerFactory.getLogger(BridgePartialActionURLImpl.class);
    private String uri;
    private String viewIdResourceParameterName;

    public BridgePartialActionURLImpl(BridgeContext bridgeContext, BridgeURI bridgeURI, String viewId) {
        super(bridgeContext, bridgeURI, viewId);
        this.uri = bridgeURI.toString();
        BridgeConfig bridgeConfig = bridgeContext.getBridgeConfig();
        this.viewIdResourceParameterName = bridgeConfig.getViewIdResourceParameterName();
    }

    @Override
    protected BaseURL toBaseURL() throws MalformedURLException {
        BaseURLNonEncodedStringImpl baseURL = null;
        if (this.uri != null) {
            if (this.uri.startsWith("http")) {
                baseURL = new BaseURLNonEncodedStringImpl(this.uri, this.getParameterMap());
                logger.debug("URL starts with http so assuming that it has already been encoded: url=[{0}]", new Object[]{this.uri});
            } else {
                String urlWithModifiedParameters = this._toString(false);
                baseURL = this.createPartialActionURL(urlWithModifiedParameters);
            }
        } else {
            logger.warn("Unable to encode PartialActionURL for url=[null]");
        }
        return baseURL;
    }

    @Override
    protected String getViewIdParameterName() {
        return this.viewIdResourceParameterName;
    }
}

