/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.context.url.internal;

import com.liferay.faces.bridge.context.BridgeContext;
import com.liferay.faces.bridge.context.url.BridgeURI;
import com.liferay.faces.bridge.context.url.internal.BridgeURLBase;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import java.net.MalformedURLException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.portlet.BaseURL;
import javax.portlet.PortletURL;
import javax.portlet.faces.Bridge;
import javax.portlet.faces.BridgeUtil;

public class BridgeBookmarkableURLImpl
extends BridgeURLBase {
    private static final Logger logger = LoggerFactory.getLogger(BridgeBookmarkableURLImpl.class);
    private String uri;
    private String viewIdRenderParameterName;

    public BridgeBookmarkableURLImpl(BridgeContext bridgeContext, BridgeURI bridgeURI, Map<String, List<String>> parameters, String viewId) {
        super(bridgeContext, bridgeURI, viewId);
        this.uri = bridgeURI.toString();
        this.viewIdRenderParameterName = bridgeContext.getBridgeConfig().getViewIdRenderParameterName();
        if (this.uri != null && parameters != null) {
            Map<String, String[]> parameterMap = this.getParameterMap();
            Set<Map.Entry<String, List<String>>> entrySet = parameters.entrySet();
            for (Map.Entry<String, List<String>> mapEntry : entrySet) {
                String key = mapEntry.getKey();
                String[] valueArray = null;
                List<String> valueList = mapEntry.getValue();
                if (valueList != null) {
                    valueArray = valueList.toArray(new String[valueList.size()]);
                }
                parameterMap.put(key, valueArray);
            }
        }
    }

    @Override
    protected BaseURL toBaseURL() throws MalformedURLException {
        PortletURL baseURL = null;
        Bridge.PortletPhase portletRequestPhase = BridgeUtil.getPortletRequestPhase();
        if (portletRequestPhase == Bridge.PortletPhase.RENDER_PHASE || portletRequestPhase == Bridge.PortletPhase.RESOURCE_PHASE) {
            baseURL = this.createRenderURL(this.uri);
            baseURL.setParameter(this.viewIdRenderParameterName, this.viewId);
            baseURL.setParameters(this.getParameterMap());
        } else {
            logger.error("Unable to encode bookmarkable URL during Bridge.PortletPhase.[{0}].", new Object[]{portletRequestPhase});
        }
        return baseURL;
    }
}

