/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.context.url.internal;

import com.liferay.faces.bridge.context.BridgeContext;
import com.liferay.faces.bridge.context.url.BridgeURI;
import com.liferay.faces.bridge.context.url.BridgeURL;
import com.liferay.faces.bridge.context.url.internal.BaseURLDirectStringImpl;
import com.liferay.faces.bridge.context.url.internal.BaseURLNonEncodedStringImpl;
import com.liferay.faces.bridge.context.url.internal.BridgeURLBase;
import com.liferay.faces.util.helper.BooleanHelper;
import java.net.MalformedURLException;
import javax.portlet.BaseURL;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.portlet.faces.Bridge;
import javax.portlet.faces.BridgeUtil;

public class BridgeActionURLImpl
extends BridgeURLBase
implements BridgeURL {
    private PortletRequest portletRequest;

    public BridgeActionURLImpl(BridgeContext bridgeContext, BridgeURI bridgeURI, String viewId) {
        super(bridgeContext, bridgeURI, viewId);
        this.portletRequest = bridgeContext.getPortletRequest();
    }

    @Override
    protected BaseURL toBaseURL() throws MalformedURLException {
        Object baseURL;
        String uri = this.bridgeURI.toString();
        Bridge.PortletPhase portletRequestPhase = BridgeUtil.getPortletRequestPhase();
        if (portletRequestPhase == Bridge.PortletPhase.ACTION_PHASE) {
            baseURL = new BaseURLNonEncodedStringImpl(uri);
        } else if (uri.startsWith("http")) {
            baseURL = new BaseURLNonEncodedStringImpl(uri, this.getParameterMap());
        } else if (uri.startsWith("#") || this.bridgeURI.isAbsolute() && this.bridgeURI.isExternal()) {
            baseURL = new BaseURLNonEncodedStringImpl(uri, this.getParameterMap());
        } else if (this.bridgeURI.isExternal() || BooleanHelper.isTrueToken((String)this.getParameter("javax.portlet.faces.DirectLink"))) {
            baseURL = new BaseURLDirectStringImpl(uri, this.getParameterMap(), this.bridgeURI.getPath(), this.portletRequest);
        } else {
            String portletMode = this.removeParameter("javax.portlet.faces.PortletMode");
            boolean modeChanged = portletMode != null && portletMode.length() > 0;
            String secure = this.removeParameter("javax.portlet.faces.Secure");
            String windowState = this.removeParameter("javax.portlet.faces.WindowState");
            if (this.bridgeURI.isPortletScheme()) {
                String urlWithModifiedParameters = this._toString(modeChanged);
                Bridge.PortletPhase urlPortletPhase = this.bridgeURI.getPortletPhase();
                baseURL = urlPortletPhase == Bridge.PortletPhase.ACTION_PHASE ? this.createActionURL(urlWithModifiedParameters) : (urlPortletPhase == Bridge.PortletPhase.RENDER_PHASE ? this.createRenderURL(urlWithModifiedParameters) : this.createResourceURL(urlWithModifiedParameters));
            } else {
                String bridgeAjaxRedirectValue = this.removeParameter("_bridgeAjaxRedirect");
                boolean bridgeAjaxRedirect = BooleanHelper.isTrueToken((String)bridgeAjaxRedirectValue);
                String urlWithModifiedParameters = this._toString(modeChanged);
                baseURL = portletRequestPhase == Bridge.PortletPhase.EVENT_PHASE ? new BaseURLNonEncodedStringImpl(urlWithModifiedParameters) : (portletRequestPhase == Bridge.PortletPhase.RESOURCE_PHASE && bridgeAjaxRedirect ? this.createRenderURL(urlWithModifiedParameters) : this.createActionURL(urlWithModifiedParameters));
            }
            if (this.isSelfReferencing()) {
                this.setRenderParameters((BaseURL)baseURL);
            }
            if (baseURL instanceof PortletURL) {
                PortletURL portletURL = (PortletURL)baseURL;
                this.setPortletModeParameter(portletMode, portletURL);
                this.setWindowStateParameter(windowState, portletURL);
            }
            this.setSecureParameter(secure, (BaseURL)baseURL);
        }
        return baseURL;
    }
}

