/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.context.map.internal;

import com.liferay.faces.bridge.BridgeFactoryFinder;
import com.liferay.faces.bridge.bean.internal.BeanManager;
import com.liferay.faces.bridge.bean.internal.BeanManagerFactory;
import com.liferay.faces.bridge.bean.internal.PreDestroyInvoker;
import com.liferay.faces.bridge.bean.internal.PreDestroyInvokerFactory;
import com.liferay.faces.bridge.config.internal.PortletConfigParam;
import com.liferay.faces.bridge.context.BridgeContext;
import com.liferay.faces.bridge.context.map.internal.ContextMapFactory;
import com.liferay.faces.bridge.context.map.internal.RequestScopeMapEntry;
import com.liferay.faces.bridge.scope.BridgeRequestScope;
import com.liferay.faces.util.config.ApplicationConfig;
import com.liferay.faces.util.map.AbstractPropertyMap;
import com.liferay.faces.util.map.AbstractPropertyMapEntry;
import com.liferay.faces.util.product.Product;
import com.liferay.faces.util.product.ProductMap;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletRequest;

public class RequestScopeMap
extends AbstractPropertyMap<Object> {
    private static final boolean LIFERAY_PORTAL_DETECTED = ((Product)ProductMap.getInstance().get((Object)"Liferay Portal")).isDetected();
    private static final boolean NULL_PATH_ATTRIBUTES;
    private static final String REQUEST_SCOPED_FQCN = "javax.faces.bean.RequestScoped";
    private BeanManager beanManager;
    private boolean distinctRequestScopedManagedBeans;
    private String namespace;
    private PortletRequest portletRequest;
    private PreDestroyInvoker preDestroyInvoker;
    private boolean preferPreDestroy;
    private Set<String> removedAttributeNames;

    public RequestScopeMap(BridgeContext bridgeContext) {
        String appConfigAttrName = ApplicationConfig.class.getName();
        PortletContext portletContext = bridgeContext.getPortletContext();
        ApplicationConfig applicationConfig = (ApplicationConfig)portletContext.getAttribute(appConfigAttrName);
        BeanManagerFactory beanManagerFactory = (BeanManagerFactory)BridgeFactoryFinder.getFactory(BeanManagerFactory.class);
        this.beanManager = beanManagerFactory.getBeanManager(applicationConfig.getFacesConfig());
        boolean distinctRequestScopedManagedBeans = false;
        PortletConfig portletConfig = bridgeContext.getPortletConfig();
        if (LIFERAY_PORTAL_DETECTED) {
            distinctRequestScopedManagedBeans = PortletConfigParam.DistinctRequestScopedManagedBeans.getBooleanValue(portletConfig);
        }
        this.distinctRequestScopedManagedBeans = distinctRequestScopedManagedBeans;
        this.namespace = bridgeContext.getPortletResponse().getNamespace();
        this.portletRequest = bridgeContext.getPortletRequest();
        this.preferPreDestroy = PortletConfigParam.PreferPreDestroy.getBooleanValue(portletConfig);
        ContextMapFactory contextMapFactory = (ContextMapFactory)BridgeFactoryFinder.getFactory(ContextMapFactory.class);
        Map<String, Object> applicationScopeMap = contextMapFactory.getApplicationScopeMap(bridgeContext);
        PreDestroyInvokerFactory preDestroyInvokerFactory = (PreDestroyInvokerFactory)BridgeFactoryFinder.getFactory(PreDestroyInvokerFactory.class);
        this.preDestroyInvoker = preDestroyInvokerFactory.getPreDestroyInvoker(applicationScopeMap);
        BridgeRequestScope bridgeRequestScope = bridgeContext.getBridgeRequestScope();
        this.removedAttributeNames = bridgeRequestScope != null ? bridgeRequestScope.getRemovedAttributeNames() : new HashSet<String>();
    }

    public Object remove(Object key) {
        String keyAsString = (String)key;
        Object potentialManagedBeanValue = super.remove(key);
        if (this.beanManager.isManagedBean(keyAsString, potentialManagedBeanValue)) {
            this.preDestroyInvoker.invokeAnnotatedMethods(potentialManagedBeanValue, this.preferPreDestroy);
        }
        return potentialManagedBeanValue;
    }

    protected AbstractPropertyMapEntry<Object> createPropertyMapEntry(String name) {
        return new RequestScopeMapEntry(this.portletRequest, name);
    }

    protected void removeProperty(String name) {
        this.removedAttributeNames.add(name);
        this.portletRequest.removeAttribute(name);
    }

    protected Object getProperty(String name) {
        if (NULL_PATH_ATTRIBUTES && ("javax.servlet.include.path_info".equals(name) || "javax.servlet.include.servlet_path".equals(name))) {
            return null;
        }
        Object attributeValue = this.portletRequest.getAttribute(name);
        if (this.distinctRequestScopedManagedBeans && attributeValue != null) {
            Object namespacedAttributeValue;
            boolean requestScopedBean = false;
            Annotation[] annotations = attributeValue.getClass().getAnnotations();
            if (annotations != null) {
                for (Annotation annotation : annotations) {
                    if (!annotation.annotationType().getName().equals(REQUEST_SCOPED_FQCN)) continue;
                    requestScopedBean = true;
                    break;
                }
            }
            if (requestScopedBean && (namespacedAttributeValue = this.portletRequest.getAttribute(this.namespace + name)) != attributeValue) {
                attributeValue = null;
            }
        }
        return attributeValue;
    }

    protected void setProperty(String name, Object value) {
        if (this.removedAttributeNames.contains(name)) {
            this.removedAttributeNames.remove(name);
        }
        this.portletRequest.setAttribute(name, value);
    }

    protected Enumeration<String> getPropertyNames() {
        ArrayList<String> attributeNames = new ArrayList<String>();
        Enumeration portletRequestAttributeNames = this.portletRequest.getAttributeNames();
        if (portletRequestAttributeNames != null) {
            while (portletRequestAttributeNames.hasMoreElements()) {
                String attributeName = (String)portletRequestAttributeNames.nextElement();
                if (this.removedAttributeNames.contains(attributeName)) continue;
                attributeNames.add(attributeName);
            }
        }
        return Collections.enumeration(attributeNames);
    }

    static {
        Product liferay = (Product)ProductMap.getInstance().get((Object)"Liferay Portal");
        Product resin = (Product)ProductMap.getInstance().get((Object)"Resin");
        NULL_PATH_ATTRIBUTES = liferay.isDetected() && (resin.isDetected() || liferay.getBuildId() < 6100);
    }
}

