/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.context.map.internal;

import com.liferay.faces.bridge.context.BridgeContext;
import com.liferay.faces.bridge.context.map.internal.ApplicationScopeMap;
import com.liferay.faces.bridge.context.map.internal.ContextMapFactory;
import com.liferay.faces.bridge.context.map.internal.FacesRequestParameterMapImpl;
import com.liferay.faces.bridge.context.map.internal.FacesViewParameterMap;
import com.liferay.faces.bridge.context.map.internal.InitParameterMap;
import com.liferay.faces.bridge.context.map.internal.MultiPartFormDataImpl;
import com.liferay.faces.bridge.context.map.internal.MultiPartFormDataProcessorImpl;
import com.liferay.faces.bridge.context.map.internal.RequestCookieMap;
import com.liferay.faces.bridge.context.map.internal.RequestHeaderMap;
import com.liferay.faces.bridge.context.map.internal.RequestHeaderValuesMap;
import com.liferay.faces.bridge.context.map.internal.RequestParameterMap;
import com.liferay.faces.bridge.context.map.internal.RequestParameterValuesMap;
import com.liferay.faces.bridge.context.map.internal.RequestScopeMap;
import com.liferay.faces.bridge.context.map.internal.ServletContextAttributeMap;
import com.liferay.faces.bridge.context.map.internal.SessionScopeMap;
import com.liferay.faces.bridge.scope.BridgeRequestScope;
import com.liferay.faces.util.context.map.FacesRequestParameterMap;
import com.liferay.faces.util.context.map.MultiPartFormData;
import com.liferay.faces.util.model.UploadedFile;
import com.liferay.faces.util.product.Product;
import com.liferay.faces.util.product.ProductMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.portlet.ClientDataRequest;
import javax.portlet.PortletContext;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.servlet.ServletContext;
import javax.servlet.http.Cookie;

public class ContextMapFactoryImpl
extends ContextMapFactory {
    private static final boolean ICEFACES_DETECTED = ((Product)ProductMap.getInstance().get((Object)"ICEfaces")).isDetected();
    private static final String MULTIPART_FORM_DATA_FQCN = MultiPartFormData.class.getName();

    @Override
    public Map<String, Object> getApplicationScopeMap(BridgeContext bridgeContext) {
        return new ApplicationScopeMap(bridgeContext);
    }

    protected FacesRequestParameterMap getFacesRequestParameterMap(BridgeContext bridgeContext) {
        FacesRequestParameterMapImpl facesRequestParameterMap = null;
        PortletRequest portletRequest = bridgeContext.getPortletRequest();
        PortletResponse portletResponse = bridgeContext.getPortletResponse();
        String namespace = portletResponse.getNamespace();
        BridgeRequestScope bridgeRequestScope = bridgeContext.getBridgeRequestScope();
        String defaultRenderKitId = bridgeContext.getDefaultRenderKitId();
        Map<String, String> facesViewParameterMap = this.getFacesViewParameterMap(bridgeContext);
        if (portletRequest instanceof ClientDataRequest) {
            ClientDataRequest clientDataRequest = (ClientDataRequest)portletRequest;
            String contentType = clientDataRequest.getContentType();
            if (!ICEFACES_DETECTED && contentType != null && contentType.toLowerCase().startsWith("multipart/")) {
                MultiPartFormData multiPartFormData = (MultiPartFormData)portletRequest.getAttribute(MULTIPART_FORM_DATA_FQCN);
                if (multiPartFormData == null) {
                    facesRequestParameterMap = new FacesRequestParameterMapImpl(namespace, bridgeRequestScope, facesViewParameterMap, defaultRenderKitId);
                    MultiPartFormDataProcessorImpl multiPartFormDataProcessor = new MultiPartFormDataProcessorImpl();
                    Map<String, List<UploadedFile>> uploadedFileMap = multiPartFormDataProcessor.process(clientDataRequest, bridgeContext.getPortletConfig(), facesRequestParameterMap);
                    multiPartFormData = new MultiPartFormDataImpl(facesRequestParameterMap, uploadedFileMap);
                    portletRequest.setAttribute(MULTIPART_FORM_DATA_FQCN, (Object)multiPartFormData);
                } else {
                    facesRequestParameterMap = multiPartFormData.getFacesRequestParameterMap();
                }
            }
        }
        if (facesRequestParameterMap == null) {
            Map parameterMap = portletRequest.getParameterMap();
            facesRequestParameterMap = new FacesRequestParameterMapImpl(parameterMap, namespace, bridgeRequestScope, facesViewParameterMap, defaultRenderKitId);
        }
        return facesRequestParameterMap;
    }

    @Override
    public Map<String, String> getFacesViewParameterMap(BridgeContext bridgeContext) {
        String facesViewQueryString = bridgeContext.getFacesViewQueryString();
        return new FacesViewParameterMap(facesViewQueryString);
    }

    @Override
    public Map<String, String> getInitParameterMap(PortletContext portletContext) {
        return Collections.unmodifiableMap(new InitParameterMap(portletContext));
    }

    @Override
    public Map<String, Object> getRequestCookieMap(BridgeContext bridgeContext) {
        PortletRequest portletRequest = bridgeContext.getPortletRequest();
        Cookie[] cookies = portletRequest.getCookies();
        return new RequestCookieMap(cookies);
    }

    @Override
    public Map<String, String> getRequestHeaderMap(BridgeContext bridgeContext) {
        return new RequestHeaderMap(this.getRequestHeaderValuesMap(bridgeContext));
    }

    @Override
    public Map<String, String[]> getRequestHeaderValuesMap(BridgeContext bridgeContext) {
        return new RequestHeaderValuesMap(bridgeContext);
    }

    @Override
    public Map<String, String> getRequestParameterMap(BridgeContext bridgeContext) {
        FacesRequestParameterMap facesRequestParameterMap = this.getFacesRequestParameterMap(bridgeContext);
        return new RequestParameterMap(facesRequestParameterMap);
    }

    @Override
    public Map<String, String[]> getRequestParameterValuesMap(BridgeContext bridgeContext) {
        FacesRequestParameterMap facesRequestParameterMap = this.getFacesRequestParameterMap(bridgeContext);
        return new RequestParameterValuesMap(facesRequestParameterMap);
    }

    @Override
    public Map<String, Object> getRequestScopeMap(BridgeContext bridgeContext) {
        return new RequestScopeMap(bridgeContext);
    }

    @Override
    public Map<String, Object> getServletContextAttributeMap(ServletContext servletContext) {
        return new ServletContextAttributeMap(servletContext);
    }

    @Override
    public Map<String, Object> getSessionScopeMap(BridgeContext bridgeContext, int scope) {
        return new SessionScopeMap(bridgeContext, scope);
    }

    @Override
    public Map<String, List<UploadedFile>> getUploadedFileMap(BridgeContext bridgeContext) {
        PortletRequest portletRequest = bridgeContext.getPortletRequest();
        MultiPartFormData multiPartFormData = (MultiPartFormData)portletRequest.getAttribute(MULTIPART_FORM_DATA_FQCN);
        Map uploadedFileMap = null;
        if (multiPartFormData != null) {
            uploadedFileMap = multiPartFormData.getUploadedFileMap();
        }
        return uploadedFileMap;
    }

    public ContextMapFactoryImpl getWrapped() {
        return null;
    }
}

