/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.context.map.internal;

import com.liferay.faces.bridge.BridgeFactoryFinder;
import com.liferay.faces.bridge.bean.internal.BeanManager;
import com.liferay.faces.bridge.bean.internal.BeanManagerFactory;
import com.liferay.faces.bridge.bean.internal.PreDestroyInvoker;
import com.liferay.faces.bridge.bean.internal.PreDestroyInvokerFactory;
import com.liferay.faces.bridge.config.internal.PortletConfigParam;
import com.liferay.faces.bridge.context.BridgeContext;
import com.liferay.faces.bridge.context.map.internal.ApplicationScopeMapEntry;
import com.liferay.faces.util.config.ApplicationConfig;
import com.liferay.faces.util.map.AbstractPropertyMap;
import com.liferay.faces.util.map.AbstractPropertyMapEntry;
import java.util.Enumeration;
import java.util.Map;
import java.util.Set;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;

public class ApplicationScopeMap
extends AbstractPropertyMap<Object> {
    private BeanManager beanManager;
    private PortletContext portletContext;
    private PreDestroyInvoker preDestroyInvoker;
    private boolean preferPreDestroy;

    public ApplicationScopeMap(BridgeContext bridgeContext) {
        BeanManagerFactory beanManagerFactory = (BeanManagerFactory)BridgeFactoryFinder.getFactory(BeanManagerFactory.class);
        this.portletContext = bridgeContext.getPortletContext();
        String appConfigAttrName = ApplicationConfig.class.getName();
        ApplicationConfig applicationConfig = (ApplicationConfig)this.portletContext.getAttribute(appConfigAttrName);
        this.beanManager = beanManagerFactory.getBeanManager(applicationConfig.getFacesConfig());
        PortletConfig portletConfig = bridgeContext.getPortletConfig();
        this.preferPreDestroy = PortletConfigParam.PreferPreDestroy.getBooleanValue(portletConfig);
        PreDestroyInvokerFactory preDestroyInvokerFactory = (PreDestroyInvokerFactory)BridgeFactoryFinder.getFactory(PreDestroyInvokerFactory.class);
        this.preDestroyInvoker = preDestroyInvokerFactory.getPreDestroyInvoker((Map<String, Object>)((Object)this));
    }

    public void clear() {
        Set mapEntries = this.entrySet();
        if (mapEntries != null) {
            for (Map.Entry mapEntry : mapEntries) {
                Object potentialManagedBeanValue;
                String potentialManagedBeanName = (String)mapEntry.getKey();
                if (!this.beanManager.isManagedBean(potentialManagedBeanName, potentialManagedBeanValue = mapEntry.getValue())) continue;
                this.preDestroyInvoker.invokeAnnotatedMethods(potentialManagedBeanValue, this.preferPreDestroy);
            }
        }
        super.clear();
    }

    public Object remove(Object key) {
        String potentialManagedBeanName = (String)key;
        Object potentialManagedBeanValue = super.remove(key);
        if (this.beanManager.isManagedBean(potentialManagedBeanName, potentialManagedBeanValue)) {
            this.preDestroyInvoker.invokeAnnotatedMethods(potentialManagedBeanValue, this.preferPreDestroy);
        }
        return potentialManagedBeanValue;
    }

    protected AbstractPropertyMapEntry<Object> createPropertyMapEntry(String name) {
        return new ApplicationScopeMapEntry(this.portletContext, name);
    }

    protected void removeProperty(String name) {
        this.portletContext.removeAttribute(name);
    }

    protected Object getProperty(String name) {
        return this.portletContext.getAttribute(name);
    }

    protected void setProperty(String name, Object value) {
        this.portletContext.setAttribute(name, value);
    }

    protected Enumeration<String> getPropertyNames() {
        return this.portletContext.getAttributeNames();
    }
}

