/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.context.internal;

import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import com.liferay.faces.util.product.Product;
import com.liferay.faces.util.product.ProductMap;
import java.lang.reflect.Method;
import javax.servlet.jsp.PageContext;

public class ScriptTagUtil {
    private static final Logger logger = LoggerFactory.getLogger(ScriptTagUtil.class);
    private static final String FLUSH_SCRIPT_DATA = "flushScriptData";
    private static final Method FLUSH_SCRIPT_DATA_METHOD;
    private static final String SCRIPT_TAG_FQCN = "com.liferay.taglib.aui.ScriptTag";

    public static void flushScriptData(PageContext pageContext) {
        try {
            if (FLUSH_SCRIPT_DATA_METHOD != null) {
                FLUSH_SCRIPT_DATA_METHOD.invoke(null, pageContext);
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
    }

    static {
        Product liferayPortal = (Product)ProductMap.getInstance().get((Object)"Liferay Portal");
        if (liferayPortal.isDetected()) {
            int buildNumber = liferayPortal.getBuildId();
            if (buildNumber >= 6011) {
                Method flushScriptDataMethod = null;
                try {
                    Class<?> scriptTagClass = Class.forName(SCRIPT_TAG_FQCN);
                    flushScriptDataMethod = scriptTagClass.getMethod(FLUSH_SCRIPT_DATA, PageContext.class);
                }
                catch (Exception e) {
                    logger.error((Throwable)e);
                }
                FLUSH_SCRIPT_DATA_METHOD = flushScriptDataMethod;
            } else {
                FLUSH_SCRIPT_DATA_METHOD = null;
            }
        } else {
            FLUSH_SCRIPT_DATA_METHOD = null;
        }
    }
}

