/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.context.internal;

import com.liferay.faces.bridge.context.internal.IncongruityContextBaseImpl;
import com.liferay.faces.bridge.lifecycle.internal.DelayedResponseOutputStream;
import com.liferay.faces.bridge.lifecycle.internal.DelayedResponseOutputWriter;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import javax.faces.context.ExternalContext;
import javax.faces.context.Flash;

public abstract class IncongruityContextCompatImpl
extends IncongruityContextBaseImpl {
    private static final Logger logger = LoggerFactory.getLogger(IncongruityContextCompatImpl.class);
    private static final String REQUEST_CONTENT_LENGTH = "requestContentLength";
    private static final String RESPONSE_BUFFER_SIZE = "responseBufferSize";
    private static final String RESPONSE_COMMITTED = "responseCommitted";
    private static final String RESPONSE_CONTENT_LENGTH = "responseContentLength";
    private static final String RESPONSE_CONTENT_TYPE = "responseContentType";
    private static final String RESPONSE_OUTPUT_STREAM = "responseOutputStream";
    private static final String RESPONSE_OUTPUT_WRITER = "responseOutputWriter";
    private static final String RESPONSE_STATUS = "responseStatus";

    public void addResponseCookie(String name, String value, Map<String, Object> properties) {
        throw new IllegalStateException();
    }

    public void addResponseHeader(String name, String value) {
        throw new IllegalStateException();
    }

    public String encodeBookmarkableURL(String baseUrl, Map<String, List<String>> parameters) {
        throw new IllegalStateException();
    }

    public String encodePartialActionURL(String url) {
        throw new IllegalStateException();
    }

    public String encodeRedirectURL(String baseUrl, Map<String, List<String>> parameters) {
        throw new IllegalStateException();
    }

    public void invalidateSession() {
        throw new IllegalStateException();
    }

    public void responseFlushBuffer() throws IOException {
        this.getIncongruousActions().add(IncongruityContextBaseImpl.IncongruousAction.RESPONSE_FLUSH_BUFFER);
    }

    public void responseReset() {
        this.getIncongruousActions().add(IncongruityContextBaseImpl.IncongruousAction.RESPONSE_RESET);
    }

    public void responseSendError(int statusCode, String message) throws IOException {
        throw new IllegalStateException();
    }

    protected void makeCongruousJSF2(ExternalContext externalContext, IncongruityContextBaseImpl.IncongruousAction incongruousAction) throws IOException {
        if (incongruousAction == IncongruityContextBaseImpl.IncongruousAction.RESPONSE_FLUSH_BUFFER) {
            logger.debug("responseFlushBuffer");
            externalContext.responseFlushBuffer();
        } else if (incongruousAction == IncongruityContextBaseImpl.IncongruousAction.RESPONSE_RESET) {
            logger.debug("responseReset");
            externalContext.responseReset();
        } else if (incongruousAction == IncongruityContextBaseImpl.IncongruousAction.SET_RESPONSE_BUFFER_SIZE) {
            int responseBufferSize = this.getResponseBufferSize();
            logger.debug("setResponseBufferSize(\"{0}\")", new Object[]{responseBufferSize});
            externalContext.setResponseBufferSize(responseBufferSize);
        } else if (incongruousAction == IncongruityContextBaseImpl.IncongruousAction.SET_RESPONSE_CONTENT_LENGTH) {
            int responseContentLength = this.getResponseContentLength();
            logger.debug("setResponseContentLength(\"{0}\")", new Object[]{responseContentLength});
            externalContext.setResponseContentLength(responseContentLength);
        } else if (incongruousAction == IncongruityContextBaseImpl.IncongruousAction.SET_RESPONSE_CONTENT_TYPE) {
            String responseContentType = this.getResponseContentType();
            logger.debug("setResponseContentType(\"{0}\")", new Object[]{responseContentType});
            externalContext.setResponseContentType(responseContentType);
        } else if (incongruousAction == IncongruityContextBaseImpl.IncongruousAction.WRITE_RESPONSE_OUTPUT_WRITER) {
            DelayedResponseOutputWriter delayedResponseOutputWriter = (DelayedResponseOutputWriter)this.getResponseOutputWriter();
            String delayedOutput = delayedResponseOutputWriter.toString();
            logger.debug("writing responseOutputWriter, delayedOutput=[{0}]", new Object[]{delayedOutput});
            if (delayedOutput != null && delayedOutput.length() > 0) {
                Writer outputWriter = externalContext.getResponseOutputWriter();
                outputWriter.write(delayedOutput);
            }
        } else if (incongruousAction == IncongruityContextBaseImpl.IncongruousAction.WRITE_RESPONSE_OUTPUT_STREAM) {
            DelayedResponseOutputStream delayedResponseOutputStream = (DelayedResponseOutputStream)this.getResponseOutputStream();
            byte[] delayedOutputByteArray = delayedResponseOutputStream.toByteArray();
            int length = 0;
            if (delayedOutputByteArray != null) {
                length = delayedOutputByteArray.length;
            }
            logger.debug("writing responseOutputStream, delayedOutputByteArray.length=[{0}]", new Object[]{length});
            if (delayedOutputByteArray != null && length > 0) {
                OutputStream outputStream = externalContext.getResponseOutputStream();
                outputStream.write(delayedOutputByteArray);
            }
        }
    }

    public String getContextName() {
        throw new IllegalStateException();
    }

    public boolean isResponseCommitted() {
        Boolean responseCommitted = (Boolean)this.attributeMap.get(RESPONSE_COMMITTED);
        if (responseCommitted == null) {
            return Boolean.FALSE;
        }
        return responseCommitted;
    }

    public Flash getFlash() {
        throw new IllegalStateException();
    }

    public String getMimeType(String file) {
        throw new IllegalStateException();
    }

    public String getRealPath(String path) {
        throw new IllegalStateException();
    }

    public int getRequestContentLength() {
        return (Integer)this.attributeMap.get(REQUEST_CONTENT_LENGTH);
    }

    public void setRequestContentLength(int length) {
        this.attributeMap.put(REQUEST_CONTENT_LENGTH, length);
    }

    public String getRequestScheme() {
        throw new IllegalStateException();
    }

    public String getRequestServerName() {
        throw new IllegalStateException();
    }

    public int getRequestServerPort() {
        throw new IllegalStateException();
    }

    public int getResponseBufferSize() {
        return (Integer)this.attributeMap.get(RESPONSE_BUFFER_SIZE);
    }

    public void setResponseBufferSize(int size) {
        this.attributeMap.put(RESPONSE_BUFFER_SIZE, size);
        this.getIncongruousActions().add(IncongruityContextBaseImpl.IncongruousAction.SET_RESPONSE_BUFFER_SIZE);
    }

    public void setResponseCommitted(boolean committed) {
        this.attributeMap.put(RESPONSE_COMMITTED, committed);
    }

    public int getResponseContentLength() {
        return (Integer)this.attributeMap.get(RESPONSE_CONTENT_LENGTH);
    }

    public void setResponseContentLength(int length) {
        this.attributeMap.put(RESPONSE_CONTENT_LENGTH, length);
        this.getIncongruousActions().add(IncongruityContextBaseImpl.IncongruousAction.SET_RESPONSE_CONTENT_LENGTH);
    }

    public String getResponseContentType() {
        return (String)this.attributeMap.get(RESPONSE_CONTENT_TYPE);
    }

    public void setResponseContentType(String contentType) {
        this.attributeMap.put(RESPONSE_CONTENT_TYPE, contentType);
        this.getIncongruousActions().add(IncongruityContextBaseImpl.IncongruousAction.SET_RESPONSE_CONTENT_TYPE);
    }

    public void setResponseHeader(String name, String value) {
        throw new IllegalStateException();
    }

    public OutputStream getResponseOutputStream() throws IOException {
        DelayedResponseOutputStream responseOutputstream = (DelayedResponseOutputStream)this.attributeMap.get(RESPONSE_OUTPUT_STREAM);
        if (responseOutputstream == null) {
            responseOutputstream = new DelayedResponseOutputStream();
            this.attributeMap.put(RESPONSE_OUTPUT_STREAM, responseOutputstream);
        }
        return responseOutputstream;
    }

    public Writer getResponseOutputWriter() throws IOException {
        DelayedResponseOutputWriter responseOutputWriter = (DelayedResponseOutputWriter)this.attributeMap.get(RESPONSE_OUTPUT_WRITER);
        if (responseOutputWriter == null) {
            responseOutputWriter = new DelayedResponseOutputWriter();
            this.attributeMap.put(RESPONSE_OUTPUT_WRITER, responseOutputWriter);
        }
        return responseOutputWriter;
    }

    public void setResponseStatus(int statusCode) {
        this.attributeMap.put(RESPONSE_STATUS, statusCode);
        this.getIncongruousActions().add(IncongruityContextBaseImpl.IncongruousAction.SET_RESPONSE_STATUS);
    }
}

