/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.context.internal;

import com.liferay.faces.bridge.context.internal.FacesView;
import com.liferay.faces.util.config.ConfiguredServletMapping;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import java.util.List;

public class FacesViewImpl
implements FacesView {
    private static final Logger logger = LoggerFactory.getLogger(FacesViewImpl.class);
    private static final String EXTENSION_JSP = ".jsp";
    private String viewId;
    private String extension;
    private boolean extensionMapped;
    private String navigationQueryString;
    private String servletPath;
    private boolean pathMapped;

    public FacesViewImpl(String viewId, List<String> configuredExtensions, List<ConfiguredServletMapping> configuredFacesServletMappings) {
        this(viewId, null, configuredExtensions, configuredFacesServletMappings);
    }

    public FacesViewImpl(String viewId, String navigationQueryString, List<String> configuredSuffixes, List<ConfiguredServletMapping> configuredFacesServletMappings) {
        this.viewId = viewId;
        this.navigationQueryString = navigationQueryString;
        if (configuredFacesServletMappings != null) {
            ConfiguredServletMapping extensionMappedServletMapping = null;
            for (ConfiguredServletMapping facesServletMapping : configuredFacesServletMappings) {
                if (!facesServletMapping.isPathMapped()) continue;
                logger.debug("Attempting to determine if viewId=[{0}] is path-mapped to urlPatttern=[{1}]", new Object[]{viewId, facesServletMapping.getUrlPattern()});
                if (!facesServletMapping.isMatch(viewId)) continue;
                this.servletPath = facesServletMapping.getServletPath();
                this.pathMapped = true;
                break;
            }
            if (!this.pathMapped) {
                for (ConfiguredServletMapping facesServletMapping : configuredFacesServletMappings) {
                    int pos;
                    if (!facesServletMapping.isExtensionMapped()) continue;
                    if (extensionMappedServletMapping == null) {
                        extensionMappedServletMapping = facesServletMapping;
                    }
                    logger.debug("Attempting to determine if viewId=[{0}] is extension-mapped to urlPattern=[{1}]", new Object[]{viewId, facesServletMapping.getUrlPattern()});
                    if (!facesServletMapping.isMatch(viewId)) continue;
                    this.extension = facesServletMapping.getExtension();
                    this.extensionMapped = true;
                    if (!EXTENSION_JSP.equals(this.extension) || (pos = viewId.lastIndexOf(".")) <= 0) break;
                    this.extension = configuredFacesServletMappings.get(0).getExtension();
                    this.viewId = viewId.substring(0, pos) + this.extension;
                    break;
                }
                if (!this.extensionMapped) {
                    for (String configuredSuffix : configuredSuffixes) {
                        if (viewId == null || !viewId.contains(configuredSuffix)) continue;
                        this.extension = configuredSuffix;
                        this.extensionMapped = true;
                        logger.debug("Associated viewId=[{0}] as extension-mapped to urlPattern=[*.{1}]", new Object[]{viewId, configuredSuffix});
                        break;
                    }
                }
            }
        }
    }

    @Override
    public boolean isExtensionMapped() {
        return this.extensionMapped;
    }

    @Override
    public boolean isPathMapped() {
        return this.pathMapped;
    }

    public boolean isServletMapped() {
        return this.extensionMapped || this.pathMapped;
    }

    @Override
    public String getExtension() {
        return this.extension;
    }

    @Override
    public String getQueryString() {
        return this.navigationQueryString;
    }

    @Override
    public String getServletPath() {
        return this.servletPath;
    }

    @Override
    public String getViewId() {
        return this.viewId;
    }
}

