/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.context.internal;

import com.liferay.faces.bridge.context.internal.BridgePortalContextLiferayCompatImpl;
import com.liferay.faces.util.helper.BooleanHelper;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import com.liferay.faces.util.product.Product;
import javax.portlet.PortalContext;
import javax.portlet.PortletRequest;

public class BridgePortalContextLiferayImpl
extends BridgePortalContextLiferayCompatImpl {
    private static final Logger logger = LoggerFactory.getLogger(BridgePortalContextLiferayImpl.class);
    private String ableToAddScriptResourceToHead;
    private String ableToAddScriptTextToHead;
    private String ableToAddStyleSheetResourceToHead;
    private String ableToSetHttpStatusCode;
    private String liferayAbleToSetHttpStatusCode;
    private String namespacedParametersRequired;

    public BridgePortalContextLiferayImpl(PortalContext portalContext, PortletRequest portletRequest, Product liferayPortal) {
        super(portalContext);
        boolean runtimePortlet;
        Boolean renderPortletResource = (Boolean)portletRequest.getAttribute("RENDER_PORTLET_RESOURCE");
        boolean bl = runtimePortlet = renderPortletResource != null && renderPortletResource != false;
        if (runtimePortlet) {
            this.ableToAddScriptResourceToHead = null;
            this.ableToAddScriptTextToHead = null;
            this.ableToAddStyleSheetResourceToHead = null;
        } else if (BooleanHelper.isTrueToken((String)portletRequest.getParameter("wsrp"))) {
            this.ableToAddScriptResourceToHead = null;
            this.ableToAddScriptTextToHead = null;
            this.ableToAddStyleSheetResourceToHead = null;
        } else {
            this.ableToAddScriptResourceToHead = "true";
            this.ableToAddScriptTextToHead = "true";
            this.ableToAddStyleSheetResourceToHead = "true";
        }
        int liferayBuildNumber = liferayPortal.getBuildId();
        if (logger.isDebugEnabled()) {
            logger.debug("Detected Liferay build number {0}", new Object[]{Long.toString(liferayBuildNumber)});
        }
        if (liferayBuildNumber >= 6011 || liferayBuildNumber >= 6005 && liferayBuildNumber <= 6010) {
            this.liferayAbleToSetHttpStatusCode = "true";
        }
        if (this.isLiferayNamingspacingParameters(portletRequest)) {
            this.namespacedParametersRequired = "true";
        }
    }

    @Override
    protected String getAddScriptResourceToHead() {
        return this.ableToAddScriptResourceToHead;
    }

    @Override
    protected String getAddScriptTextToHead() {
        return this.ableToAddScriptTextToHead;
    }

    @Override
    protected String getAddStyleSheetResourceToHead() {
        return this.ableToAddStyleSheetResourceToHead;
    }

    @Override
    public String getCreateRenderUrlDuringActionPhase() {
        return "true";
    }

    @Override
    protected String getMarkupHeadElementSupported() {
        return null;
    }

    @Override
    protected String getNamespacedParametersRequired() {
        return this.namespacedParametersRequired;
    }

    @Override
    protected String getPostRedirectGetSupported() {
        return null;
    }

    @Override
    protected String getSetHttpStatusCode() {
        if (this.ableToSetHttpStatusCode == null) {
            this.ableToSetHttpStatusCode = super.getSetHttpStatusCode();
            if (this.ableToSetHttpStatusCode == null) {
                this.ableToSetHttpStatusCode = this.liferayAbleToSetHttpStatusCode;
            }
        }
        return this.ableToSetHttpStatusCode;
    }
}

