/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.context.internal;

import com.liferay.faces.bridge.config.BridgeConfig;
import com.liferay.faces.bridge.context.BridgeContext;
import com.liferay.faces.bridge.context.IncongruityContext;
import com.liferay.faces.bridge.context.internal.BridgeContextImpl;
import com.liferay.faces.bridge.scope.BridgeRequestScope;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import com.liferay.portal.theme.PortletDisplay;
import com.liferay.portal.theme.ThemeDisplay;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletMode;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.WindowState;
import javax.portlet.faces.Bridge;

public class BridgeContextLiferayImpl
extends BridgeContextImpl {
    private static final Logger logger = LoggerFactory.getLogger(BridgeContextLiferayImpl.class);
    private String NAMESPACED_P_P_COL_ID;
    private String NAMESPACED_P_P_COL_POS;
    private String NAMESPACED_P_P_COL_COUNT;
    private String NAMESPACED_P_P_MODE;
    private String NAMESPACED_P_P_STATE;
    private String requestURL;

    public BridgeContextLiferayImpl(BridgeConfig bridgeConfig, BridgeRequestScope bridgeRequestScope, PortletConfig portletConfig, PortletContext portletContext, PortletRequest portletRequest, PortletResponse portletResponse, Bridge.PortletPhase portletPhase, IncongruityContext incongruityContext) {
        super(bridgeConfig, bridgeRequestScope, portletConfig, portletContext, portletRequest, portletResponse, portletPhase, incongruityContext);
        String namespace = portletResponse.getNamespace();
        this.NAMESPACED_P_P_COL_ID = namespace.concat("p_p_col_id");
        this.NAMESPACED_P_P_COL_POS = namespace.concat("p_p_col_pos");
        this.NAMESPACED_P_P_COL_COUNT = namespace.concat("p_p_col_count");
        this.NAMESPACED_P_P_MODE = namespace.concat("p_p_mode");
        this.NAMESPACED_P_P_STATE = namespace.concat("p_p_state");
        if (portletRequest instanceof RenderRequest) {
            PortletMode portletMode = portletRequest.getPortletMode();
            WindowState windowState = portletRequest.getWindowState();
            ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            PortletDisplay portletDisplay = themeDisplay.getPortletDisplay();
            this.saveRenderAttributes(portletMode, windowState, portletDisplay, portletContext);
        }
        BridgeContextLiferayImpl.setCurrentInstance((BridgeContext)this);
    }

    @Override
    public void release() {
        super.release();
        this.NAMESPACED_P_P_COL_COUNT = null;
        this.NAMESPACED_P_P_COL_ID = null;
        this.NAMESPACED_P_P_COL_POS = null;
        this.NAMESPACED_P_P_MODE = null;
        this.NAMESPACED_P_P_STATE = null;
        this.requestURL = null;
    }

    protected void saveRenderAttributes(PortletMode portletMode, WindowState windowState, PortletDisplay portletDisplay, PortletContext portletContext) {
        try {
            portletContext.setAttribute(this.NAMESPACED_P_P_COL_ID, (Object)portletDisplay.getColumnId());
            portletContext.setAttribute(this.NAMESPACED_P_P_COL_POS, (Object)Integer.toString(portletDisplay.getColumnPos()));
            portletContext.setAttribute(this.NAMESPACED_P_P_COL_COUNT, (Object)Integer.toString(portletDisplay.getColumnCount()));
            if (portletMode != null) {
                portletContext.setAttribute(this.NAMESPACED_P_P_MODE, (Object)portletMode.toString());
            }
            if (windowState != null) {
                portletContext.setAttribute(this.NAMESPACED_P_P_STATE, (Object)windowState.toString());
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), new Object[]{e});
        }
    }

    @Override
    protected String getRequestURL() {
        if (this.requestURL == null) {
            StringBuilder buf = new StringBuilder();
            ThemeDisplay themeDisplay = (ThemeDisplay)this.getPortletRequest().getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            buf.append(themeDisplay.getURLPortal());
            buf.append(themeDisplay.getURLCurrent());
            this.requestURL = buf.toString();
        }
        return this.requestURL;
    }
}

