/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.context.internal;

import com.liferay.faces.bridge.BridgeFactoryFinder;
import com.liferay.faces.bridge.application.internal.BridgeNavigationUtil;
import com.liferay.faces.bridge.config.BridgeConfig;
import com.liferay.faces.bridge.config.internal.PortletConfigParam;
import com.liferay.faces.bridge.context.BridgeContext;
import com.liferay.faces.bridge.context.IncongruityContext;
import com.liferay.faces.bridge.context.internal.BridgeContextCompatImpl;
import com.liferay.faces.bridge.context.internal.FacesView;
import com.liferay.faces.bridge.context.internal.FacesViewImpl;
import com.liferay.faces.bridge.context.internal.RenderRedirectWriterImpl;
import com.liferay.faces.bridge.context.map.internal.ContextMapFactory;
import com.liferay.faces.bridge.context.map.internal.RequestHeaderMap;
import com.liferay.faces.bridge.context.map.internal.RequestHeaderValuesMap;
import com.liferay.faces.bridge.context.url.BridgeResourceURL;
import com.liferay.faces.bridge.context.url.BridgeURI;
import com.liferay.faces.bridge.context.url.BridgeURIFactory;
import com.liferay.faces.bridge.context.url.BridgeURL;
import com.liferay.faces.bridge.context.url.BridgeURLFactory;
import com.liferay.faces.bridge.scope.BridgeRequestScope;
import com.liferay.faces.util.config.ConfiguredServletMapping;
import com.liferay.faces.util.helper.BooleanHelper;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.portlet.ActionResponse;
import javax.portlet.MimeResponse;
import javax.portlet.PortalContext;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletMode;
import javax.portlet.PortletModeException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.ResourceResponse;
import javax.portlet.StateAwareResponse;
import javax.portlet.WindowStateException;
import javax.portlet.faces.Bridge;
import javax.portlet.faces.BridgeDefaultViewNotSpecifiedException;
import javax.portlet.faces.BridgeInvalidViewPathException;

public class BridgeContextImpl
extends BridgeContextCompatImpl {
    private static final String REQUEST_ATTR_PORTLET_REQUEST = "javax.portlet.request";
    private static final String REQUEST_ATTR_QUERY_STRING = "javax.servlet.forward.query_string";
    private static final String DIRECT_LINK_EQUALS_TRUE = "javax.portlet.faces.DirectLink=true";
    private static final Logger logger = LoggerFactory.getLogger(BridgeContextImpl.class);
    private Map<String, Object> attributeMap = new HashMap<String, Object>();
    private BridgeConfig bridgeConfig;
    private BridgeRequestScope bridgeRequestScope;
    private BridgeURIFactory bridgeURIFactory;
    private BridgeURLFactory bridgeURLFactory;
    private List<String> configuredSuffixes;
    private List<ConfiguredServletMapping> configuredFacesServletMappings;
    private ContextMapFactory contextMapFactory;
    private String defaultRenderKitId;
    private Map<String, String> defaultViewIdMap;
    private FacesView facesView;
    private IncongruityContext incongruityContext;
    private List<String> preFacesRequestAttrNames;
    private PortletConfig portletConfig;
    private PortletContext portletContext;
    private PortletRequest portletRequest;
    private Bridge.PortletPhase portletPhase;
    private PortletResponse portletResponse;
    private Boolean preserveActionParams;
    private Map<String, String[]> preservedActionParams;
    private boolean processingAfterViewContent;
    private boolean renderRedirect;
    private boolean renderRedirectAfterDispatch;
    private Boolean renderRedirectEnabled;
    private BridgeURL renderRedirectURL;
    private Map<String, String> requestHeaderMap;
    private Map<String, String[]> requestHeaderValuesMap;
    private Map<String, String> requestParameterMap;
    private Map<String, String[]> requestParameterValuesMap;
    private StringWrapper requestPathInfo;
    private String requestServletPath;
    private String requestQueryString;
    private String requestURL;
    private Writer responseOutputWriter;
    private String savedViewState;
    private String viewIdAndQueryString;

    public BridgeContextImpl(BridgeConfig bridgeConfig, BridgeRequestScope bridgeRequestScope, PortletConfig portletConfig, PortletContext portletContext, PortletRequest portletRequest, PortletResponse portletResponse, Bridge.PortletPhase portletPhase, IncongruityContext incongruityContext) {
        this.bridgeConfig = bridgeConfig;
        this.configuredFacesServletMappings = (List)bridgeConfig.getAttributes().get("configuredFacesServletMappings");
        this.configuredSuffixes = (List)bridgeConfig.getAttributes().get("configuredSuffixes");
        this.bridgeRequestScope = bridgeRequestScope;
        this.portletConfig = portletConfig;
        this.portletContext = portletContext;
        this.portletRequest = portletRequest;
        this.portletResponse = portletResponse;
        this.portletPhase = portletPhase;
        this.incongruityContext = incongruityContext;
        this.bridgeURIFactory = (BridgeURIFactory)BridgeFactoryFinder.getFactory(BridgeURIFactory.class);
        this.bridgeURLFactory = (BridgeURLFactory)BridgeFactoryFinder.getFactory(BridgeURLFactory.class);
        this.contextMapFactory = (ContextMapFactory)BridgeFactoryFinder.getFactory(ContextMapFactory.class);
        logger.debug("User-Agent requested URL=[{0}]", new Object[]{this.getRequestURL()});
        BridgeContextImpl.setCurrentInstance((BridgeContext)this);
    }

    public BridgeURL encodeActionURL(String url) {
        logger.debug("encodeActionURL fromURL=[{0}]", new Object[]{url});
        BridgeURL bridgeActionURL = null;
        try {
            BridgeURI bridgeURI = this.bridgeURIFactory.getBridgeURI(url);
            BridgeContext bridgeContext = BridgeContext.getCurrentInstance();
            FacesContext facesContext = FacesContext.getCurrentInstance();
            UIViewRoot viewRoot = facesContext.getViewRoot();
            String currentFacesViewId = viewRoot.getViewId();
            bridgeActionURL = this.bridgeURLFactory.getBridgeActionURL(bridgeContext, bridgeURI, currentFacesViewId);
            Map parameterMap = bridgeActionURL.getParameterMap();
            if (bridgeURI.isPortletScheme()) {
                String facesViewPathParameter;
                String facesViewIdParameter = bridgeActionURL.getParameter("_jsfBridgeViewId");
                if ("_jsfBridgeCurrentView".equals(facesViewIdParameter)) {
                    bridgeActionURL.setSelfReferencing(true);
                    parameterMap.remove("_jsfBridgeViewId");
                }
                if ("_jsfBridgeCurrentView".equals(facesViewPathParameter = bridgeActionURL.getParameter("_jsfBridgeViewPath"))) {
                    bridgeActionURL.setSelfReferencing(true);
                    parameterMap.remove("_jsfBridgeViewPath");
                }
            } else {
                String contextPath;
                String directLinkParam = bridgeActionURL.getParameter("javax.portlet.faces.DirectLink");
                if (BooleanHelper.isFalseToken((String)directLinkParam)) {
                    parameterMap.remove("javax.portlet.faces.DirectLink");
                }
                String contextRelativeViewPath = null;
                if (!bridgeURI.isExternal() && (contextRelativeViewPath = bridgeURI.getContextRelativePath(contextPath = bridgeContext.getPortletRequest().getContextPath())) == null) {
                    contextRelativeViewPath = viewRoot.getViewId();
                }
                FacesViewImpl targetFacesView = new FacesViewImpl(contextRelativeViewPath, this.configuredSuffixes, this.configuredFacesServletMappings);
                if (!(bridgeURI.isAbsolute() || targetFacesView.isExtensionMapped() || targetFacesView.isPathMapped() || url.startsWith("#"))) {
                    bridgeActionURL.setParameter("_jsfBridgeNonFacesView", contextRelativeViewPath);
                }
            }
        }
        catch (URISyntaxException e) {
            logger.error((Throwable)e);
        }
        return bridgeActionURL;
    }

    public BridgeURL encodeBookmarkableURL(String baseURL, Map<String, List<String>> parameters) {
        logger.debug("encodeBookmarkableURL fromURL=[{0}]", new Object[]{baseURL});
        String viewId = baseURL;
        BridgeContext bridgeContext = BridgeContext.getCurrentInstance();
        PortletRequest portletRequest = bridgeContext.getPortletRequest();
        String requestContextPath = portletRequest.getContextPath();
        if (baseURL.startsWith(requestContextPath)) {
            viewId = baseURL.substring(requestContextPath.length());
        }
        try {
            BridgeURI bridgeURI = this.bridgeURIFactory.getBridgeURI(baseURL);
            return this.bridgeURLFactory.getBridgeBookmarkableURL(bridgeContext, bridgeURI, parameters, viewId);
        }
        catch (URISyntaxException e) {
            throw new FacesException((Throwable)e);
        }
    }

    public BridgeURL encodePartialActionURL(String url) {
        logger.debug("encodePartialActionURL fromURL=[{0}]", new Object[]{url});
        BridgeContext bridgeContext = BridgeContext.getCurrentInstance();
        FacesContext facesContext = FacesContext.getCurrentInstance();
        UIViewRoot viewRoot = facesContext.getViewRoot();
        String currentFacesViewId = viewRoot.getViewId();
        try {
            BridgeURI bridgeURI = this.bridgeURIFactory.getBridgeURI(url);
            BridgeURL bridgePartialActionURL = this.bridgeURLFactory.getBridgePartialActionURL(bridgeContext, bridgeURI, currentFacesViewId);
            bridgePartialActionURL.setParameter("_jsfBridgeAjax", Boolean.TRUE.toString());
            return bridgePartialActionURL;
        }
        catch (URISyntaxException e) {
            throw new FacesException((Throwable)e);
        }
    }

    public BridgeURL encodeRedirectURL(String baseUrl, Map<String, List<String>> parameters) {
        logger.debug("encodeRedirectURL fromURL=[{0}]", new Object[]{baseUrl});
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (this.isJSF2PartialRequest(facesContext)) {
            ArrayList<String> bridgeAjaxRedirect = new ArrayList<String>();
            bridgeAjaxRedirect.add("true");
            parameters.put("_bridgeAjaxRedirect", bridgeAjaxRedirect);
        }
        try {
            BridgeContext bridgeContext = BridgeContext.getCurrentInstance();
            BridgeURI bridgeURI = this.bridgeURIFactory.getBridgeURI(baseUrl);
            String redirectViewId = null;
            if (!bridgeURI.isExternal()) {
                String contextPath = bridgeContext.getPortletRequest().getContextPath();
                redirectViewId = bridgeURI.getContextRelativePath(contextPath);
            }
            return this.bridgeURLFactory.getBridgeRedirectURL(bridgeContext, bridgeURI, parameters, redirectViewId);
        }
        catch (URISyntaxException e) {
            throw new FacesException((Throwable)e);
        }
    }

    public BridgeResourceURL encodeResourceURL(String url) {
        logger.debug("encodeResourceURL fromURL=[{0}]", new Object[]{url});
        String currentFacesViewId = null;
        FacesContext facesContext = FacesContext.getCurrentInstance();
        UIViewRoot uiViewRoot = facesContext.getViewRoot();
        if (uiViewRoot != null) {
            currentFacesViewId = uiViewRoot.getViewId();
        }
        BridgeContext bridgeContext = BridgeContext.getCurrentInstance();
        try {
            BridgeURI bridgeURI = this.bridgeURIFactory.getBridgeURI(url);
            BridgeResourceURL bridgeResourceURL = this.bridgeURLFactory.getBridgeResourceURL(bridgeContext, bridgeURI, currentFacesViewId);
            String viewLinkParam = bridgeResourceURL.getParameter("javax.portlet.faces.ViewLink");
            Map parameterMap = bridgeResourceURL.getParameterMap();
            if (BooleanHelper.isTrueToken((String)viewLinkParam)) {
                parameterMap.remove("javax.portlet.faces.ViewLink");
                bridgeResourceURL.setViewLink(true);
                if (bridgeResourceURL.getParameter("javax.portlet.faces.BackLink") != null) {
                    bridgeResourceURL.replaceBackLinkParameter(facesContext);
                }
            }
            if (bridgeURI.isOpaque()) {
                if (bridgeURI.isPortletScheme()) {
                    String facesViewPathParameter;
                    String facesViewIdParameter = bridgeResourceURL.getParameter("_jsfBridgeViewId");
                    if ("_jsfBridgeCurrentView".equals(facesViewIdParameter)) {
                        bridgeResourceURL.setSelfReferencing(true);
                        parameterMap.remove("_jsfBridgeViewId");
                    }
                    if ("_jsfBridgeCurrentView".equals(facesViewPathParameter = bridgeResourceURL.getParameter("_jsfBridgeViewPath"))) {
                        bridgeResourceURL.setSelfReferencing(true);
                        parameterMap.remove("_jsfBridgeViewPath");
                    }
                }
            } else if (bridgeURI.isHierarchical() && bridgeURI.isExternal()) {
                if (bridgeResourceURL.getParameter("javax.portlet.faces.BackLink") != null) {
                    bridgeResourceURL.replaceBackLinkParameter(facesContext);
                }
            } else if (bridgeURI.isHierarchical() && !bridgeURI.isExternal()) {
                if (bridgeResourceURL.getParameter("javax.portlet.faces.BackLink") != null) {
                    bridgeResourceURL.replaceBackLinkParameter(facesContext);
                }
                if (bridgeResourceURL.getParameter("javax.portlet.faces.InProtocolResourceLink") != null) {
                    bridgeResourceURL.setInProtocol(true);
                    parameterMap.remove("javax.portlet.faces.PortletMode");
                    parameterMap.remove("javax.portlet.faces.WindowState");
                    String secureParam = bridgeResourceURL.getParameter("javax.portlet.faces.Secure");
                    bridgeResourceURL.setSecure(BooleanHelper.isTrueToken((String)secureParam));
                    parameterMap.remove("javax.portlet.faces.Secure");
                }
            }
            return bridgeResourceURL;
        }
        catch (URISyntaxException e) {
            throw new FacesException((Throwable)e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void redirect(String url) throws IOException {
        if (url != null) {
            logger.debug("redirect url=[{0}]", new Object[]{url});
            if (this.portletPhase == Bridge.PortletPhase.ACTION_PHASE || this.portletPhase == Bridge.PortletPhase.EVENT_PHASE || this.portletPhase == Bridge.PortletPhase.RENDER_PHASE) {
                try {
                    boolean directLink;
                    BridgeURI bridgeURI = this.bridgeURIFactory.getBridgeURI(url);
                    String queryString = bridgeURI.getQuery();
                    boolean bl = directLink = queryString != null && queryString.contains(DIRECT_LINK_EQUALS_TRUE);
                    if (this.portletPhase == Bridge.PortletPhase.ACTION_PHASE && (url.startsWith("#") || bridgeURI.isExternal() || directLink)) {
                        this.bridgeRequestScope.setRedirectOccurred(true);
                        ActionResponse actionResponse = (ActionResponse)this.portletResponse;
                        actionResponse.sendRedirect(url);
                        return;
                    }
                    FacesContext facesContext = FacesContext.getCurrentInstance();
                    BridgeContext bridgeContext = BridgeContext.getCurrentInstance();
                    PortalContext portalContext = bridgeContext.getPortletRequest().getPortalContext();
                    String createRenderUrlDuringActionPhaseSupport = portalContext.getProperty("com.liferay.faces.bridge.create.render.url.during.action.phase.support");
                    if (this.portletPhase == Bridge.PortletPhase.ACTION_PHASE && createRenderUrlDuringActionPhaseSupport != null && bridgeURI.isAbsolute()) {
                        ActionResponse actionResponse = (ActionResponse)this.getPortletResponse();
                        actionResponse.sendRedirect(bridgeURI.toString());
                        return;
                    }
                    if (this.portletPhase == Bridge.PortletPhase.ACTION_PHASE || this.portletPhase == Bridge.PortletPhase.EVENT_PHASE) {
                        String contextPath = bridgeContext.getPortletRequest().getContextPath();
                        String newViewId = bridgeURI.getContextRelativePath(contextPath);
                        UIViewRoot viewRoot = facesContext.getViewRoot();
                        String currentFacesViewId = viewRoot.getViewId();
                        if (!currentFacesViewId.equals(newViewId)) {
                            ViewHandler viewHandler = facesContext.getApplication().getViewHandler();
                            UIViewRoot newViewRoot = viewHandler.createView(facesContext, newViewId);
                            facesContext.setViewRoot(newViewRoot);
                        }
                        this.partialViewContextRenderAll(facesContext);
                        facesContext.responseComplete();
                        this.getBridgeRequestScope().setRedirectOccurred(true);
                        try {
                            StateAwareResponse stateAwareResponse = (StateAwareResponse)this.portletResponse;
                            BridgeURL bridgeRedirectURL = this.bridgeURLFactory.getBridgeRedirectURL(bridgeContext, bridgeURI, null, null);
                            BridgeNavigationUtil.navigate(this.portletRequest, stateAwareResponse, this.bridgeRequestScope, bridgeRedirectURL);
                            return;
                        }
                        catch (PortletModeException e) {
                            logger.error(e.getMessage());
                            return;
                        }
                        catch (WindowStateException e) {
                            logger.error(e.getMessage());
                        }
                        return;
                    }
                    if (this.portletPhase != Bridge.PortletPhase.RENDER_PHASE) return;
                    BridgeURL bridgeRedirectURL = this.bridgeURLFactory.getBridgeRedirectURL(bridgeContext, bridgeURI, null, null);
                    if (bridgeRedirectURL.isFacesViewTarget()) {
                        this.renderRedirect = true;
                        this.renderRedirectURL = bridgeRedirectURL;
                        return;
                    }
                    String viewIdRenderParameterName = this.bridgeConfig.getViewIdRenderParameterName();
                    String viewIdRenderParameterValue = bridgeRedirectURL.getParameter(viewIdRenderParameterName);
                    if (viewIdRenderParameterValue == null) throw new IllegalStateException("6.1.3.1: Unable to redirect to a non-Faces view during the RENDER_PHASE.");
                    this.renderRedirect = true;
                    viewIdRenderParameterValue = URLDecoder.decode(viewIdRenderParameterValue, "UTF-8");
                    BridgeURI redirectURI = this.bridgeURIFactory.getBridgeURI(viewIdRenderParameterValue);
                    UIViewRoot viewRoot = facesContext.getViewRoot();
                    String currentFacesViewId = viewRoot.getViewId();
                    this.renderRedirectURL = bridgeRedirectURL = this.bridgeURLFactory.getBridgeRedirectURL(bridgeContext, redirectURI, null, currentFacesViewId);
                    return;
                }
                catch (URISyntaxException e) {
                    logger.error((Throwable)e);
                }
                return;
            }
            FacesContext facesContext = FacesContext.getCurrentInstance();
            if (!this.isJSF2PartialRequest(facesContext)) throw new UnsupportedEncodingException("Can only redirect during RESOURCE_PHASE if a JSF partial/Ajax request has been triggered");
            BridgeContext bridgeContext = BridgeContext.getCurrentInstance();
            try {
                BridgeURI bridgeURI = this.bridgeURIFactory.getBridgeURI(url);
                BridgeURL bridgeRedirectURL = this.bridgeURLFactory.getBridgeRedirectURL(bridgeContext, bridgeURI, null, null);
                this.redirectJSF2PartialResponse(facesContext, (ResourceResponse)this.portletResponse, bridgeRedirectURL.toString());
                return;
            }
            catch (Exception e) {
                logger.error((Throwable)e);
                throw new IOException(e.getMessage());
            }
        }
        logger.error("redirect url=null");
    }

    public void release() {
        this.attributeMap = null;
        this.bridgeConfig = null;
        this.bridgeRequestScope = null;
        this.bridgeURLFactory = null;
        this.configuredFacesServletMappings = null;
        this.configuredSuffixes = null;
        this.contextMapFactory = null;
        this.defaultRenderKitId = null;
        this.defaultViewIdMap = null;
        this.facesView = null;
        this.preFacesRequestAttrNames = null;
        this.portletConfig = null;
        this.portletContext = null;
        this.portletRequest = null;
        this.portletPhase = null;
        this.portletResponse = null;
        this.preserveActionParams = null;
        this.preservedActionParams = null;
        this.renderRedirect = false;
        this.renderRedirectAfterDispatch = false;
        this.renderRedirectURL = null;
        this.requestHeaderMap = null;
        this.requestHeaderValuesMap = null;
        this.requestParameterMap = null;
        this.requestParameterValuesMap = null;
        this.requestPathInfo = null;
        this.requestServletPath = null;
        this.requestQueryString = null;
        this.requestURL = null;
        this.savedViewState = null;
        this.viewIdAndQueryString = null;
        BridgeContextImpl.setCurrentInstance(null);
    }

    public Map<String, Object> getAttributes() {
        return this.attributeMap;
    }

    public BridgeConfig getBridgeConfig() {
        return this.bridgeConfig;
    }

    public BridgeRequestScope getBridgeRequestScope() {
        return this.bridgeRequestScope;
    }

    public String getDefaultRenderKitId() {
        if (this.defaultRenderKitId == null) {
            String attributeName = "javax.portlet.faces." + this.portletConfig.getPortletName() + "." + "defaultRenderKitId";
            this.defaultRenderKitId = (String)this.portletContext.getAttribute(attributeName);
        }
        return this.defaultRenderKitId;
    }

    public Map<String, String> getDefaultViewIdMap() {
        if (this.defaultViewIdMap == null) {
            String portletName = this.portletConfig.getPortletName();
            String attrNameDefaultViewIdMap = "javax.portlet.faces." + portletName + "." + "defaultViewIdMap";
            this.defaultViewIdMap = (Map)this.portletConfig.getPortletContext().getAttribute(attrNameDefaultViewIdMap);
        }
        return this.defaultViewIdMap;
    }

    protected FacesView getFacesView() throws BridgeDefaultViewNotSpecifiedException, BridgeInvalidViewPathException {
        if (this.facesView == null) {
            String fullViewId = this.getFacesViewIdAndQueryString();
            String viewId = null;
            String navigationQueryString = null;
            if (fullViewId != null) {
                int pos = fullViewId.indexOf("?");
                if (pos > 0) {
                    navigationQueryString = fullViewId.substring(pos + 1);
                    viewId = fullViewId.substring(0, pos);
                } else {
                    viewId = fullViewId;
                }
            }
            this.facesView = new FacesViewImpl(viewId, navigationQueryString, this.configuredSuffixes, this.configuredFacesServletMappings);
        }
        return this.facesView;
    }

    public String getFacesViewId() throws BridgeDefaultViewNotSpecifiedException, BridgeInvalidViewPathException {
        return this.getFacesView().getViewId();
    }

    protected String getFacesViewIdAndQueryString() throws BridgeDefaultViewNotSpecifiedException, BridgeInvalidViewPathException {
        if (this.viewIdAndQueryString == null) {
            this.viewIdAndQueryString = this.getFacesViewIdRequestAttribute("javax.portlet.faces.viewId");
            if (this.viewIdAndQueryString == null) {
                String viewPath = this.getFacesViewIdRequestAttribute("javax.portlet.faces.viewPath");
                if (viewPath != null) {
                    String contextPath;
                    int pos = viewPath.indexOf("?");
                    if (pos > 0) {
                        viewPath = viewPath.substring(0, pos);
                    }
                    if ((pos = viewPath.indexOf(contextPath = this.portletRequest.getContextPath())) >= 0) {
                        viewPath = viewPath.substring(pos + contextPath.length());
                    }
                    this.viewIdAndQueryString = this.getFacesViewIdFromPath(viewPath);
                    if (this.viewIdAndQueryString == null) {
                        throw new BridgeInvalidViewPathException();
                    }
                }
                if (this.viewIdAndQueryString == null) {
                    if (this.renderRedirectURL != null) {
                        this.viewIdAndQueryString = this.renderRedirectURL.toString();
                    }
                    if (this.viewIdAndQueryString == null) {
                        String requestParameterName = this.portletPhase == Bridge.PortletPhase.RESOURCE_PHASE ? this.bridgeConfig.getViewIdResourceParameterName() : this.bridgeConfig.getViewIdRenderParameterName();
                        this.viewIdAndQueryString = this.getFacesViewIdRequestParameter(requestParameterName);
                        if (this.viewIdAndQueryString == null) {
                            PortletMode currentPortletMode = this.portletRequest.getPortletMode();
                            this.viewIdAndQueryString = this.getDefaultViewIdMap().get(currentPortletMode.toString());
                            logger.debug("portlet.xml viewId=[{0}] portletMode=[{1}]", new Object[]{this.viewIdAndQueryString, currentPortletMode});
                            if (this.viewIdAndQueryString == null) {
                                throw new BridgeDefaultViewNotSpecifiedException();
                            }
                        } else {
                            logger.debug("request parameter {0}=[{1}]", new Object[]{requestParameterName, this.viewIdAndQueryString});
                        }
                    } else {
                        logger.debug("redirect viewId=[{0}]", new Object[]{this.viewIdAndQueryString});
                    }
                }
            } else {
                logger.debug("javax.portlet.faces.viewId=[{0}]", new Object[]{this.viewIdAndQueryString});
            }
        }
        return this.viewIdAndQueryString;
    }

    public String getFacesViewIdFromPath(String viewPath) {
        return this.getFacesViewIdFromPath(viewPath, true);
    }

    public String getFacesViewIdFromPath(String viewPath, boolean mustExist) {
        String facesViewId = null;
        for (ConfiguredServletMapping configuredFacesServletMapping : this.configuredFacesServletMappings) {
            logger.debug("Attempting to determine the facesViewId from {0}=[{1}]", new Object[]{"javax.portlet.faces.viewPath", viewPath});
            if (!configuredFacesServletMapping.isMatch(viewPath)) continue;
            if (configuredFacesServletMapping.isExtensionMapped()) {
                for (String defaultSuffix : this.configuredSuffixes) {
                    int pos = viewPath.lastIndexOf(".");
                    if (pos <= 0) continue;
                    if (mustExist) {
                        String resourcePath = viewPath.substring(0, pos) + defaultSuffix;
                        try {
                            URL resourceURL = this.getPortletContext().getResource(resourcePath);
                            if (resourceURL == null) continue;
                            facesViewId = viewPath;
                            break;
                        }
                        catch (MalformedURLException e) {
                            logger.error((Throwable)e);
                            continue;
                        }
                    }
                    facesViewId = viewPath;
                    break;
                }
                if (facesViewId == null) {
                    logger.error("Matched EXTENSION MAPPING for for urlPattern=[{0}] and viewPath=[{1}] but unable to find a facesViewId with extensions[{2}]", new Object[]{configuredFacesServletMapping.getUrlPattern(), viewPath, this.configuredSuffixes});
                }
            } else if (configuredFacesServletMapping.isPathMapped()) {
                facesViewId = viewPath;
            }
            if (facesViewId == null) continue;
            break;
        }
        return facesViewId;
    }

    protected String getFacesViewIdRequestAttribute(String name) {
        String value = (String)this.getPortletRequest().getAttribute(name);
        if (value != null && (value.contains(":") || value.contains("%3A") || value.contains("%253A"))) {
            logger.warn("Invalid character in request attribute {0}=[{1}]", new Object[]{name, value});
            value = null;
        }
        return value;
    }

    protected String getFacesViewIdRequestParameter(String name) {
        String value = this.getPortletRequest().getParameter(name);
        if (value != null && (value.contains(":") || value.contains("%3A") || value.contains("%253A"))) {
            logger.warn("Invalid character in request parameter {0}=[{1}]", new Object[]{name, value});
            value = null;
        }
        return value;
    }

    public String getFacesViewQueryString() {
        return this.getFacesView().getQueryString();
    }

    public boolean isRenderRedirectAfterDispatch() {
        return this.renderRedirectAfterDispatch;
    }

    public IncongruityContext getIncongruityContext() {
        return this.incongruityContext;
    }

    public String getInitParameter(String name) {
        String initParameter = this.portletConfig.getInitParameter(name);
        if (initParameter == null) {
            initParameter = this.portletContext.getInitParameter(name);
        }
        return initParameter;
    }

    public PortletConfig getPortletConfig() {
        return this.portletConfig;
    }

    public PortletContext getPortletContext() {
        return this.portletContext;
    }

    public PortletRequest getPortletRequest() {
        return this.portletRequest;
    }

    public void setPortletRequest(PortletRequest portletRequest) {
        this.portletRequest = portletRequest;
        this.requestParameterMap = null;
        this.requestParameterValuesMap = null;
        this.requestHeaderMap = null;
        this.requestHeaderValuesMap = null;
    }

    public Bridge.PortletPhase getPortletRequestPhase() {
        return this.portletPhase;
    }

    public PortletResponse getPortletResponse() {
        return this.portletResponse;
    }

    public void setPortletResponse(PortletResponse portletResponse) {
        this.portletResponse = portletResponse;
    }

    public List<String> getPreFacesRequestAttrNames() {
        return this.preFacesRequestAttrNames;
    }

    public void setPreFacesRequestAttrNames(List<String> preFacesRequestAttrNames) {
        this.preFacesRequestAttrNames = preFacesRequestAttrNames;
    }

    public Map<String, String[]> getPreservedActionParams() {
        if (this.preservedActionParams == null) {
            this.preservedActionParams = new HashMap<String, String[]>();
        }
        return this.preservedActionParams;
    }

    public void setPreservedActionParams(Map<String, String[]> preservedActionParams) {
        this.preservedActionParams = preservedActionParams;
    }

    public void setProcessingAfterViewContent(boolean processingAfterViewContent) {
        this.processingAfterViewContent = processingAfterViewContent;
    }

    public void setRenderRedirectAfterDispatch(boolean renderRedirectAfterDispatch) {
        this.renderRedirectAfterDispatch = renderRedirectAfterDispatch;
    }

    public BridgeURL getRenderRedirectURL() {
        return this.renderRedirectURL;
    }

    public void setRenderRedirectURL(BridgeURL renderRedirectURL) {
        this.renderRedirectURL = renderRedirectURL;
    }

    public Map<String, String> getRequestHeaderMap() {
        if (this.requestHeaderMap == null) {
            this.requestHeaderMap = Collections.unmodifiableMap(new RequestHeaderMap(this.getRequestHeaderValuesMap()));
        }
        return this.requestHeaderMap;
    }

    public Map<String, String[]> getRequestHeaderValuesMap() {
        if (this.requestHeaderValuesMap == null) {
            BridgeContext bridgeContext = BridgeContext.getCurrentInstance();
            this.requestHeaderValuesMap = Collections.unmodifiableMap(new RequestHeaderValuesMap(bridgeContext));
        }
        return this.requestHeaderValuesMap;
    }

    public Map<String, String> getRequestParameterMap() {
        if (this.requestParameterMap == null) {
            BridgeContext bridgeContext = BridgeContext.getCurrentInstance();
            this.requestParameterMap = this.contextMapFactory.getRequestParameterMap(bridgeContext);
        }
        return this.requestParameterMap;
    }

    public Map<String, String[]> getRequestParameterValuesMap() {
        if (this.requestParameterValuesMap == null) {
            BridgeContext bridgeContext = BridgeContext.getCurrentInstance();
            this.requestParameterValuesMap = this.contextMapFactory.getRequestParameterValuesMap(bridgeContext);
        }
        return this.requestParameterValuesMap;
    }

    public String getRequestPathInfo() {
        String returnValue = null;
        if (this.requestPathInfo == null) {
            FacesView facesView = this.getFacesView();
            String viewId = facesView.getViewId();
            if (facesView.isExtensionMapped()) {
                logger.debug("requestPathInfo=[null] EXTENSION=[{1}] viewId=[{2}]", new Object[]{facesView.getExtension(), viewId});
            } else if (facesView.isPathMapped()) {
                returnValue = viewId.substring(facesView.getServletPath().length());
                logger.debug("requestPathInfo=[{0}] PATH=[{1}] viewId=[{2}]", new Object[]{returnValue, facesView.getServletPath(), viewId});
            } else {
                returnValue = facesView.getViewId();
                logger.debug("requestPathInfo=[{0}] servletMapping=[NONE] viewId=[{1}]", new Object[]{returnValue, viewId});
            }
            this.requestPathInfo = new StringWrapper(returnValue);
        } else {
            returnValue = this.requestPathInfo.getValue();
        }
        return returnValue;
    }

    protected String getRequestQueryString(PortletRequest portletRequest) {
        if (this.requestQueryString == null) {
            Object portletRequestAsObject;
            this.requestQueryString = (String)portletRequest.getAttribute(REQUEST_ATTR_QUERY_STRING);
            if (this.requestQueryString == null && (portletRequestAsObject = portletRequest.getAttribute(REQUEST_ATTR_PORTLET_REQUEST)) != null && portletRequestAsObject instanceof PortletRequest) {
                portletRequest = (PortletRequest)portletRequestAsObject;
                this.requestQueryString = (String)portletRequest.getAttribute(REQUEST_ATTR_QUERY_STRING);
            }
        }
        return this.requestQueryString;
    }

    public String getRequestServletPath() {
        if (this.requestServletPath == null) {
            FacesView facesView = this.getFacesView();
            String viewId = facesView.getViewId();
            if (facesView.isExtensionMapped()) {
                this.requestServletPath = facesView.getViewId();
                logger.debug("requestServletPath=[{0}] extensionMapped=[{1}] viewId=[{2}]", new Object[]{this.requestServletPath, facesView.getExtension(), viewId});
            } else if (facesView.isPathMapped()) {
                this.requestServletPath = facesView.getViewId();
                int pos = this.requestServletPath.lastIndexOf("/*");
                if (pos >= 0) {
                    this.requestServletPath = this.requestServletPath.substring(0, pos);
                }
                logger.debug("requestServletPath=[{0}] pathMapped=[{1}] viewId=[{2}]", new Object[]{this.requestServletPath, facesView.getServletPath(), viewId});
            } else {
                this.requestServletPath = "";
                logger.debug("requestServletPath=[{0}] servletMapping=[NONE] viewId=[{1}]", new Object[]{this.requestServletPath, viewId});
            }
        }
        return this.requestServletPath;
    }

    protected String getRequestURL() {
        if (this.requestURL == null) {
            StringBuilder buf = new StringBuilder();
            PortletRequest portletRequest = this.getPortletRequest();
            buf.append(portletRequest.getScheme());
            buf.append("://");
            buf.append(portletRequest.getServerName());
            buf.append(":");
            buf.append(portletRequest.getServerPort());
            buf.append(portletRequest.getContextPath());
            buf.append("?");
            buf.append(this.getRequestQueryString(portletRequest));
            this.requestURL = buf.toString();
        }
        return this.requestURL;
    }

    public Writer getResponseOutputWriter() throws IOException {
        if (this.responseOutputWriter == null) {
            MimeResponse mimeResponse = (MimeResponse)this.portletResponse;
            if (this.portletPhase == Bridge.PortletPhase.RENDER_PHASE) {
                if (this.renderRedirectEnabled == null) {
                    this.renderRedirectEnabled = PortletConfigParam.RenderRedirectEnabled.getBooleanValue(this.portletConfig);
                }
                this.responseOutputWriter = this.renderRedirectEnabled.booleanValue() ? new RenderRedirectWriterImpl(mimeResponse.getWriter()) : mimeResponse.getWriter();
            } else {
                this.responseOutputWriter = mimeResponse.getWriter();
            }
        }
        return this.responseOutputWriter;
    }

    public boolean isPreserveActionParams() {
        if (this.preserveActionParams == null) {
            String initParamName = "javax.portlet.faces." + this.portletConfig.getPortletName() + "." + "preserveActionParams";
            Object initParamValue = this.portletContext.getAttribute(initParamName);
            this.preserveActionParams = initParamValue != null && initParamValue instanceof Boolean ? (Boolean)initParamValue : Boolean.FALSE;
        }
        return this.preserveActionParams;
    }

    public String getSavedViewState() {
        return this.savedViewState;
    }

    public void setSavedViewState(String savedViewState) {
        this.savedViewState = savedViewState;
    }

    public boolean isProcessingAfterViewContent() {
        return this.processingAfterViewContent;
    }

    public boolean isRenderRedirect() {
        return this.renderRedirect;
    }

    protected class StringWrapper {
        private String value;

        public StringWrapper(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

