/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.context.flash.internal;

import com.liferay.faces.bridge.context.flash.internal.BridgeFlash;
import com.liferay.faces.bridge.context.flash.internal.BridgeFlashFactory;
import com.liferay.faces.bridge.context.flash.internal.BridgeFlashFallbackImpl;
import com.liferay.faces.bridge.context.flash.internal.BridgeFlashMojarraImpl;
import com.liferay.faces.bridge.context.flash.internal.BridgeFlashMyFacesImpl;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import java.lang.reflect.Method;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.Flash;

public class BridgeFlashFactoryImpl
extends BridgeFlashFactory {
    private static final Logger logger = LoggerFactory.getLogger(BridgeFlashFactory.class);
    private static final String MOJARRA_FLASH_FQCN = "com.sun.faces.context.flash.ELFlash";
    private static final String MOJARRA_GET_FLASH_METHOD_NAME = "getFlash";
    private static final String MYFACES_FLASH_FQCN_NEW = "org.apache.myfaces.shared.context.flash.FlashImpl";
    private static final String MYFACES_FLASH_FQCN_OLD = "org.apache.myfaces.shared_impl.context.flash.FlashImpl";
    private static final String MYFACES_GET_FLASH_METHOD_NAME = "getCurrentInstance";
    private static final String WARNING_MSG = "Unable to create an instance of [{0}]; falling back to [{1}]";
    private static final Method mojarraGetFlashMethod;
    private static final Method myFacesGetFlashMethod;

    @Override
    public BridgeFlash getBridgeFlash() {
        BridgeFlash bridgeFlash = null;
        if (mojarraGetFlashMethod != null) {
            try {
                Flash mojarraFlash = (Flash)mojarraGetFlashMethod.invoke(null, new Object[0]);
                bridgeFlash = new BridgeFlashMojarraImpl(mojarraFlash);
            }
            catch (Exception e) {
                logger.warn(WARNING_MSG, new Object[]{MOJARRA_FLASH_FQCN, BridgeFlashFallbackImpl.class.getName()});
                bridgeFlash = new BridgeFlashFallbackImpl();
            }
        } else if (myFacesGetFlashMethod != null) {
            try {
                FacesContext facesContext = FacesContext.getCurrentInstance();
                ExternalContext externalContext = facesContext.getExternalContext();
                Flash myFacesFlash = (Flash)myFacesGetFlashMethod.invoke(null, externalContext);
                bridgeFlash = new BridgeFlashMyFacesImpl(myFacesFlash);
            }
            catch (Exception e) {
                logger.warn(WARNING_MSG, new Object[]{MYFACES_FLASH_FQCN_NEW, BridgeFlashFallbackImpl.class.getName()});
                bridgeFlash = new BridgeFlashFallbackImpl();
            }
        }
        return bridgeFlash;
    }

    public BridgeFlashFactory getWrapped() {
        return null;
    }

    static {
        Method mojarraMethod = null;
        Method myFacesMethod = null;
        try {
            Class<?> mojarraFlashClass = Class.forName(MOJARRA_FLASH_FQCN);
            mojarraMethod = mojarraFlashClass.getMethod(MOJARRA_GET_FLASH_METHOD_NAME, new Class[0]);
        }
        catch (Exception e1) {
            try {
                Class<?> myFacesFlashClass = Class.forName(MYFACES_FLASH_FQCN_NEW);
                myFacesMethod = myFacesFlashClass.getMethod(MYFACES_GET_FLASH_METHOD_NAME, ExternalContext.class);
            }
            catch (Exception e2) {
                try {
                    Class<?> myFacesFlashClass = Class.forName(MYFACES_FLASH_FQCN_OLD);
                    myFacesMethod = myFacesFlashClass.getMethod(MYFACES_GET_FLASH_METHOD_NAME, ExternalContext.class);
                }
                catch (Exception e3) {
                    logger.error("Classloader unable to find either the Mojarra or MyFaces Flash implementations");
                }
            }
        }
        mojarraGetFlashMethod = mojarraMethod;
        myFacesGetFlashMethod = myFacesMethod;
    }
}

