/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.config.internal;

import com.liferay.faces.util.helper.BooleanHelper;
import com.liferay.faces.util.helper.IntegerHelper;
import com.liferay.faces.util.helper.LongHelper;
import java.util.HashMap;
import java.util.Map;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;

public class PortletConfigParamUtil {
    private static final Map<String, Object> configParamCache = new HashMap<String, Object>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean getBooleanValue(PortletConfig portletConfig, String name, String alternateName, boolean defaultBooleanValue) {
        boolean booleanValue = defaultBooleanValue;
        String portletName = portletConfig.getPortletName();
        if (portletName == null) {
            String configuredValue = PortletConfigParamUtil.getConfiguredValue(portletConfig, name, alternateName);
            if (configuredValue != null) {
                booleanValue = BooleanHelper.isTrueToken((String)configuredValue);
            }
        } else {
            String configParamName = portletName + name;
            Object cachedValue = configParamCache.get(configParamName);
            if (cachedValue != null && cachedValue instanceof Boolean) {
                booleanValue = (Boolean)cachedValue;
            } else {
                String configuredValue = PortletConfigParamUtil.getConfiguredValue(portletConfig, name, alternateName);
                if (configuredValue != null) {
                    booleanValue = BooleanHelper.isTrueToken((String)configuredValue);
                }
                Map<String, Object> map = configParamCache;
                synchronized (map) {
                    configParamCache.put(configParamName, booleanValue);
                }
            }
        }
        return booleanValue;
    }

    public static String getConfiguredValue(PortletConfig portletConfig, String name, String alternateName) {
        String configuredValue = portletConfig.getInitParameter(name);
        PortletContext portletContext = null;
        if (configuredValue == null) {
            portletContext = portletConfig.getPortletContext();
            configuredValue = portletContext.getInitParameter(name);
        }
        if (configuredValue == null && alternateName != null && (configuredValue = portletConfig.getInitParameter(alternateName)) == null) {
            configuredValue = portletContext.getInitParameter(alternateName);
        }
        return configuredValue;
    }

    public static boolean isSpecified(PortletConfig portletConfig, String name, String alternateName) {
        return PortletConfigParamUtil.getConfiguredValue(portletConfig, name, alternateName) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getIntegerValue(PortletConfig portletConfig, String name, String alternateName, int defaultIntegerValue) {
        int integerValue = defaultIntegerValue;
        String portletName = portletConfig.getPortletName();
        if (portletName == null) {
            String configuredValue = PortletConfigParamUtil.getConfiguredValue(portletConfig, name, alternateName);
            if (configuredValue != null) {
                integerValue = IntegerHelper.toInteger((String)configuredValue);
            }
        } else {
            String configParamName = portletName + name;
            Object cachedValue = configParamCache.get(configParamName);
            if (cachedValue != null && cachedValue instanceof Integer) {
                integerValue = (Integer)cachedValue;
            } else {
                String configuredValue = PortletConfigParamUtil.getConfiguredValue(portletConfig, name, alternateName);
                if (configuredValue != null) {
                    integerValue = IntegerHelper.toInteger((String)configuredValue);
                }
                Map<String, Object> map = configParamCache;
                synchronized (map) {
                    configParamCache.put(configParamName, integerValue);
                }
            }
        }
        return integerValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getLongValue(PortletConfig portletConfig, String name, String alternateName, long defaultLongValue) {
        long longValue = defaultLongValue;
        String portletName = portletConfig.getPortletName();
        if (portletName == null) {
            String configuredValue = PortletConfigParamUtil.getConfiguredValue(portletConfig, name, alternateName);
            if (configuredValue != null) {
                longValue = LongHelper.toLong((String)configuredValue);
            }
        } else {
            String configParamName = portletName + name;
            Object cachedValue = configParamCache.get(configParamName);
            if (cachedValue != null && cachedValue instanceof Long) {
                longValue = (Long)cachedValue;
            } else {
                String configuredValue = PortletConfigParamUtil.getConfiguredValue(portletConfig, name, alternateName);
                if (configuredValue != null) {
                    longValue = LongHelper.toLong((String)configuredValue);
                }
                Map<String, Object> map = configParamCache;
                synchronized (map) {
                    configParamCache.put(configParamName, longValue);
                }
            }
        }
        return longValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getStringValue(PortletConfig portletConfig, String name, String alternateName, String defaultStringValue) {
        String stringValue = defaultStringValue;
        String portletName = portletConfig.getPortletName();
        if (portletName == null) {
            String configuredValue = PortletConfigParamUtil.getConfiguredValue(portletConfig, name, alternateName);
            if (configuredValue != null) {
                stringValue = configuredValue;
            }
        } else {
            String configParamName = portletName + name;
            Object cachedValue = configParamCache.get(configParamName);
            if (cachedValue != null && cachedValue instanceof String) {
                stringValue = (String)cachedValue;
            } else {
                String configuredValue = PortletConfigParamUtil.getConfiguredValue(portletConfig, name, alternateName);
                if (configuredValue != null) {
                    stringValue = configuredValue;
                }
                Map<String, Object> map = configParamCache;
                synchronized (map) {
                    configParamCache.put(configParamName, stringValue);
                }
            }
        }
        return stringValue;
    }
}

