/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.config.internal;

import com.liferay.faces.bridge.config.BridgeConfig;
import com.liferay.faces.bridge.config.internal.BridgeConfigAttributeMap;
import com.liferay.faces.bridge.config.internal.PortletConfigParam;
import com.liferay.faces.util.config.ApplicationConfig;
import com.liferay.faces.util.config.ConfiguredElement;
import com.liferay.faces.util.config.FacesConfig;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;

public class BridgeConfigImpl
implements BridgeConfig {
    private static final String EXCLUDED_ATTRIBUTE = "excluded-attribute";
    private static final String MODEL_EL = "model-el";
    private static final String PARAMETER = "parameter";
    private static final String RENDER_RESPONSE_WRAPPER_CLASS = "render-response-wrapper-class";
    private static final String RESOURCE_RESPONSE_WRAPPER_CLASS = "resource-response-wrapper-class";
    private Map<String, Object> bridgeConfigAttributeMap = new BridgeConfigAttributeMap();
    private Set<String> excludedRequestAttributes;
    private Map<String, String[]> publicParameterMappings;
    private String viewIdRenderParameterName;
    private String viewIdResourceParameterName;
    private String writeBehindRenderResponseWrapper;
    private String writeBehindResourceResponseWrapper;

    public BridgeConfigImpl(PortletConfig portletConfig) {
        String configuredElementName;
        String appConfigAttrName = ApplicationConfig.class.getName();
        PortletContext portletContext = portletConfig.getPortletContext();
        ApplicationConfig applicationConfig = (ApplicationConfig)portletContext.getAttribute(appConfigAttrName);
        FacesConfig facesConfig = applicationConfig.getFacesConfig();
        this.bridgeConfigAttributeMap.put("configuredFacesServletMappings", facesConfig.getConfiguredFacesServletMappings());
        this.bridgeConfigAttributeMap.put("configuredSystemEventListeners", facesConfig.getConfiguredSystemEventListeners());
        this.bridgeConfigAttributeMap.put("configuredSuffixes", facesConfig.getConfiguredSuffixes());
        this.excludedRequestAttributes = new HashSet<String>();
        List configuredApplicationExtensions = facesConfig.getConfiguredApplicationExtensions();
        for (ConfiguredElement configuredElement : configuredApplicationExtensions) {
            String configuredElementName2 = configuredElement.getName();
            if (!EXCLUDED_ATTRIBUTE.equals(configuredElementName2)) continue;
            String excludedAttributeName = configuredElement.getValue();
            this.excludedRequestAttributes.add(excludedAttributeName);
        }
        this.publicParameterMappings = new HashMap<String, String[]>();
        String parameter = null;
        String modelEL = null;
        for (ConfiguredElement configuredElement : configuredApplicationExtensions) {
            configuredElementName = configuredElement.getName();
            if (PARAMETER.equals(configuredElementName)) {
                parameter = configuredElement.getValue();
                continue;
            }
            if (!MODEL_EL.equals(configuredElementName)) continue;
            modelEL = configuredElement.getValue();
            if (parameter == null || modelEL == null || modelEL.length() <= 0) continue;
            String[] newValue = new String[]{modelEL};
            String[] existingValue = this.publicParameterMappings.get(parameter);
            if (existingValue != null) {
                int total = existingValue.length + 1;
                newValue = new String[total];
                for (int i = 0; i < existingValue.length; ++i) {
                    newValue[i] = existingValue[i];
                }
                newValue[total - 1] = modelEL;
            }
            this.publicParameterMappings.put(parameter, newValue);
        }
        for (ConfiguredElement configuredElement : configuredApplicationExtensions) {
            configuredElementName = configuredElement.getName();
            if (!RENDER_RESPONSE_WRAPPER_CLASS.equals(configuredElementName)) continue;
            this.writeBehindRenderResponseWrapper = configuredElement.getValue();
        }
        for (ConfiguredElement configuredElement : configuredApplicationExtensions) {
            configuredElementName = configuredElement.getName();
            if (!RESOURCE_RESPONSE_WRAPPER_CLASS.equals(configuredElementName)) continue;
            this.writeBehindResourceResponseWrapper = configuredElement.getValue();
        }
        this.viewIdResourceParameterName = PortletConfigParam.ViewIdResourceParameterName.getStringValue(portletConfig);
        this.viewIdRenderParameterName = PortletConfigParam.ViewIdRenderParameterName.getStringValue(portletConfig);
    }

    public Map<String, Object> getAttributes() {
        return this.bridgeConfigAttributeMap;
    }

    public Set<String> getExcludedRequestAttributes() {
        return this.excludedRequestAttributes;
    }

    public Map<String, String[]> getPublicParameterMappings() {
        return this.publicParameterMappings;
    }

    public String getViewIdRenderParameterName() {
        return this.viewIdRenderParameterName;
    }

    public String getViewIdResourceParameterName() {
        return this.viewIdResourceParameterName;
    }

    public String getWriteBehindRenderResponseWrapper() {
        return this.writeBehindRenderResponseWrapper;
    }

    public String getWriteBehindResourceResponseWrapper() {
        return this.writeBehindResourceResponseWrapper;
    }
}

