/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.component.inputfile.internal;

import com.liferay.faces.bridge.BridgeFactoryFinder;
import com.liferay.faces.bridge.component.inputfile.InputFile;
import com.liferay.faces.bridge.component.inputfile.internal.InputFileDelegationResponseWriter;
import com.liferay.faces.bridge.component.inputfile.internal.InputFileRendererCompat;
import com.liferay.faces.bridge.context.BridgeContext;
import com.liferay.faces.bridge.context.map.internal.ContextMapFactory;
import com.liferay.faces.bridge.event.FileUploadEvent;
import com.liferay.faces.bridge.model.internal.UploadedFileBridgeImpl;
import com.liferay.faces.util.model.UploadedFile;
import com.liferay.faces.util.render.internal.DelegationResponseWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.FacesEvent;
import javax.faces.render.FacesRenderer;

@FacesRenderer(componentFamily="javax.faces.Input", rendererType="com.liferay.faces.bridge.component.inputfile.InputFileRenderer")
public class InputFileRenderer
extends InputFileRendererCompat {
    public void decode(FacesContext facesContext, UIComponent uiComponent) {
        String clientId;
        List<UploadedFile> uploadedFiles;
        InputFile inputFile = (InputFile)uiComponent;
        Map<String, List<UploadedFile>> uploadedFileMap = this.getUploadedFileMap(facesContext);
        if (uploadedFileMap != null && (uploadedFiles = uploadedFileMap.get(clientId = uiComponent.getClientId(facesContext))) != null && uploadedFiles.size() > 0) {
            UploadedFileBridgeImpl bridgeUploadedFile;
            ArrayList<UploadedFileBridgeImpl> bridgeUploadedFiles = new ArrayList<UploadedFileBridgeImpl>(uploadedFiles.size());
            for (UploadedFile uploadedFile : uploadedFiles) {
                bridgeUploadedFile = new UploadedFileBridgeImpl(uploadedFile);
                bridgeUploadedFiles.add(bridgeUploadedFile);
            }
            inputFile.setSubmittedValue(bridgeUploadedFiles);
            for (UploadedFile uploadedFile : uploadedFiles) {
                bridgeUploadedFile = new UploadedFileBridgeImpl(uploadedFile);
                FileUploadEvent fileUploadEvent = new FileUploadEvent(uiComponent, (com.liferay.faces.bridge.model.UploadedFile)bridgeUploadedFile);
                uiComponent.queueEvent((FacesEvent)fileUploadEvent);
            }
        }
    }

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        ResponseWriter responseWriter = facesContext.getResponseWriter();
        InputFileDelegationResponseWriter delegationResponseWriter = new InputFileDelegationResponseWriter(responseWriter);
        super.encodeEnd(facesContext, uiComponent, (DelegationResponseWriter)delegationResponseWriter);
    }

    protected Map<String, List<UploadedFile>> getUploadedFileMap(FacesContext facesContext) {
        ContextMapFactory contextMapFactory = (ContextMapFactory)BridgeFactoryFinder.getFactory(ContextMapFactory.class);
        BridgeContext bridgeContext = BridgeContext.getCurrentInstance();
        return contextMapFactory.getUploadedFileMap(bridgeContext);
    }
}

