/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.bean.internal;

import com.liferay.faces.bridge.bean.internal.PreDestroyInvokerImpl;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import java.lang.reflect.Method;
import java.util.Map;

public class PreDestroyInvokerMojarraImpl
extends PreDestroyInvokerImpl {
    private static final Logger logger = LoggerFactory.getLogger(PreDestroyInvokerMojarraImpl.class);
    private static final String INVOKE_PRE_DESTROY = "invokePreDestroy";
    private Method invokePreDestroyMethod;
    private Object mojarraInjectionProvider;

    public PreDestroyInvokerMojarraImpl(Map<String, Object> applicationMap) {
        this.mojarraInjectionProvider = this.getInjectionProvider(applicationMap);
        try {
            this.invokePreDestroyMethod = this.mojarraInjectionProvider.getClass().getMethod(INVOKE_PRE_DESTROY, Object.class);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
    }

    @Override
    public void invokeAnnotatedMethods(Object managedBean, boolean preferPreDestroy) {
        if (preferPreDestroy) {
            if (this.invokePreDestroyMethod != null) {
                try {
                    logger.debug("Invoking methods annotated with @PreDestroy: mojarraInjectionProvider=[{0}] managedBean=[{1}]", new Object[]{this.mojarraInjectionProvider, managedBean});
                    this.invokePreDestroyMethod.invoke(this.mojarraInjectionProvider, managedBean);
                }
                catch (Exception e) {
                    logger.error((Throwable)e);
                }
            } else {
                super.invokeAnnotatedMethods(managedBean, preferPreDestroy);
            }
        } else {
            super.invokeAnnotatedMethods(managedBean, preferPreDestroy);
        }
    }

    public String toString() {
        return this.mojarraInjectionProvider.toString();
    }

    protected Object getInjectionProvider(Map<String, Object> applicationMap) {
        try {
            Object applicationAssociate = applicationMap.get("com.sun.faces.ApplicationAssociate");
            if (applicationAssociate != null) {
                Method getInjectionProviderMethod = applicationAssociate.getClass().getMethod("getInjectionProvider", new Class[0]);
                Object mojarraInjectionProvider = getInjectionProviderMethod.invoke(applicationAssociate, new Object[0]);
                logger.debug("mojarraInjectionProvider=[{0}]", new Object[]{mojarraInjectionProvider});
                return mojarraInjectionProvider;
            }
            return null;
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            return null;
        }
    }
}

