/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.application.internal;

import com.liferay.faces.bridge.application.internal.ViewHandlerCompatImpl;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;

public class ViewHandlerImpl
extends ViewHandlerCompatImpl {
    private static final Logger logger = LoggerFactory.getLogger(ViewHandlerImpl.class);
    private ViewHandler wrappedViewHandler;

    public ViewHandlerImpl(ViewHandler viewHandler) {
        this.wrappedViewHandler = viewHandler;
    }

    public UIViewRoot createView(FacesContext facesContext, String viewId) {
        int pos;
        logger.debug("Creating view for viewId=[{0}]", new Object[]{viewId});
        String queryString = null;
        if (viewId != null && (pos = (viewId = this.evaluateExpressionJSF1(facesContext, viewId)).indexOf("?")) > 0) {
            queryString = viewId.substring(pos);
            logger.debug("Temporarily removed query-string from viewId=[{0}]", new Object[]{viewId});
            viewId = viewId.substring(0, pos);
        }
        UIViewRoot uiViewRoot = super.createView(facesContext, viewId);
        if (queryString != null) {
            logger.debug("Adding back query-string viewId=[{0}]", new Object[]{viewId});
            uiViewRoot.setViewId(viewId + queryString);
        }
        return uiViewRoot;
    }

    public UIViewRoot restoreView(FacesContext facesContext, String viewId) {
        logger.debug("Restoring view for viewId=[{0}]", new Object[]{viewId});
        return super.restoreView(facesContext, viewId);
    }

    public String getActionURL(FacesContext facesContext, String viewId) {
        String actionURL = null;
        if (viewId != null) {
            int dotPos;
            boolean replacedDotChars = false;
            int questionMarkPos = viewId.indexOf("?");
            if (questionMarkPos > 0 && (dotPos = viewId.indexOf(".", questionMarkPos)) > 0) {
                String queryString = viewId.substring(questionMarkPos);
                queryString = queryString.replaceAll("[.]", "_DOT_");
                viewId = viewId.substring(0, questionMarkPos) + queryString;
                replacedDotChars = true;
            }
            actionURL = super.getActionURL(facesContext, viewId);
            if (replacedDotChars) {
                actionURL = actionURL.replaceAll("_DOT_", ".");
            }
        }
        return actionURL;
    }

    public ViewHandler getWrapped() {
        return this.wrappedViewHandler;
    }
}

