/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.application.internal;

import com.liferay.faces.util.application.ResourceValidator;
import com.liferay.faces.util.application.ResourceValidatorWrapper;
import com.liferay.faces.util.config.ApplicationConfig;
import com.liferay.faces.util.config.ConfiguredServlet;
import com.liferay.faces.util.config.ConfiguredServletMapping;
import com.liferay.faces.util.config.WebConfig;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;

public abstract class ResourceValidatorBaseImpl
extends ResourceValidatorWrapper {
    private static final Logger logger = LoggerFactory.getLogger(ResourceValidatorBaseImpl.class);
    private ResourceValidator wrappedResourceValidator;

    public ResourceValidatorBaseImpl(ResourceValidator resourceValidator) {
        this.wrappedResourceValidator = resourceValidator;
    }

    public boolean isSelfReferencing(FacesContext facesContext, String resourceId) {
        boolean selfReferencing = super.isSelfReferencing(facesContext, resourceId);
        if (!selfReferencing && resourceId != null) {
            HashSet<String> invokerServletNames = new HashSet<String>();
            ExternalContext externalContext = facesContext.getExternalContext();
            Map applicationMap = externalContext.getApplicationMap();
            ApplicationConfig applicationConfig = (ApplicationConfig)applicationMap.get(ApplicationConfig.class.getName());
            WebConfig webConfig = applicationConfig.getWebConfig();
            List configuredServlets = webConfig.getConfiguredServlets();
            for (ConfiguredServlet configuredServlet : configuredServlets) {
                String configuredServletClass = configuredServlet.getServletClass();
                if (!this.isInvokerServletClass(configuredServletClass)) continue;
                invokerServletNames.add(configuredServlet.getServletName());
            }
            List configuredServletMappings = webConfig.getConfiguredServletMappings();
            for (ConfiguredServletMapping configuredServletMapping : configuredServletMappings) {
                if (!invokerServletNames.contains(configuredServletMapping.getServletName()) || !configuredServletMapping.isMatch(resourceId)) continue;
                selfReferencing = true;
                break;
            }
        }
        return selfReferencing;
    }

    protected abstract String getInvokerServletFQCN();

    protected boolean isInvokerServletClass(String servletClassFQCN) {
        boolean invokerServletClass = false;
        String invokerServletFQCN = this.getInvokerServletFQCN();
        if (invokerServletFQCN.equals(servletClassFQCN)) {
            invokerServletClass = true;
        } else {
            try {
                Class<?> invokerServletClazz = Class.forName(invokerServletFQCN);
                try {
                    Class<?> servletClazz = Class.forName(servletClassFQCN);
                    invokerServletClass = invokerServletClazz.isAssignableFrom(servletClazz);
                }
                catch (Throwable t) {
                    logger.error("Unable to load servletClassFQCN=[{0}] error=[{1}]", new Object[]{servletClassFQCN, t.getMessage()});
                }
            }
            catch (Throwable t) {
                logger.error("Unable to load invokerServletFQCN=[{0}] error=[{1}]", new Object[]{invokerServletFQCN, t.getMessage()});
            }
        }
        return invokerServletClass;
    }

    public ResourceValidator getWrapped() {
        return this.wrappedResourceValidator;
    }
}

